/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.virtualbng;

import java.nio.ByteBuffer;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ARP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.virtualbng.VbngConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class VirtualPublicHosts {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String APP_NAME = "org.onosproject.virtualbng.VirtualPublicHosts";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VbngConfigurationService vbngConfigService;
    private ApplicationId appId;
    private ArpRequestProcessor processor = new ArpRequestProcessor();

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)6));
        this.requestIntercepts();
        this.log.info("vBNG virtual public hosts started");
    }

    @Deactivate
    public void deactivate() {
        this.withdrawIntercepts();
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.processor = null;
        this.log.info("vBNG virtual public hosts Stopped");
    }

    private void requestIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_ARP);
        this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
    }

    private void withdrawIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_ARP);
        this.packetService.cancelPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindVbngConfigService(VbngConfigurationService vbngConfigurationService) {
        this.vbngConfigService = vbngConfigurationService;
    }

    protected void unbindVbngConfigService(VbngConfigurationService vbngConfigurationService) {
        if (this.vbngConfigService == vbngConfigurationService) {
            this.vbngConfigService = null;
        }
    }

    private class ArpRequestProcessor
    implements PacketProcessor {
        private ArpRequestProcessor() {
        }

        public void process(PacketContext context) {
            InboundPacket pkt = context.inPacket();
            Ethernet ethPkt = pkt.parsed();
            if (ethPkt == null || ethPkt.getEtherType() != Ethernet.TYPE_ARP) {
                return;
            }
            ARP arpPacket = (ARP)ethPkt.getPayload();
            if (arpPacket.getOpCode() != 1) {
                return;
            }
            Ip4Address targetIpAddress = Ip4Address.valueOf((byte[])arpPacket.getTargetProtocolAddress());
            if (!VirtualPublicHosts.this.vbngConfigService.isAssignedPublicIpAddress((IpAddress)targetIpAddress)) {
                return;
            }
            MacAddress virtualHostMac = VirtualPublicHosts.this.vbngConfigService.getPublicFacingMac();
            if (virtualHostMac == null) {
                return;
            }
            ConnectPoint srcConnectPoint = pkt.receivedFrom();
            Ethernet eth = ARP.buildArpReply((Ip4Address)targetIpAddress, (MacAddress)virtualHostMac, (Ethernet)ethPkt);
            TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
            builder.setOutput(srcConnectPoint.port());
            VirtualPublicHosts.this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(srcConnectPoint.deviceId(), builder.build(), ByteBuffer.wrap(eth.serialize())));
        }
    }
}

