/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.virtualbng;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.net.ConnectPoint;
import org.onosproject.virtualbng.VbngConfiguration;
import org.onosproject.virtualbng.VbngConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class VbngConfigurationManager
implements VbngConfigurationService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String CONFIG_DIR = "../config";
    private static final String DEFAULT_CONFIG_FILE = "virtualbng.json";
    private String configFileName = "virtualbng.json";
    private Map<IpPrefix, Boolean> localPublicIpPrefixes = new ConcurrentHashMap<IpPrefix, Boolean>();
    private Map<IpAddress, IpAddress> ipAddressMap = new ConcurrentHashMap<IpAddress, IpAddress>();
    private IpAddress nextHopIpAddress;
    private MacAddress macOfPublicIpAddresses;
    private IpAddress xosIpAddress;
    private int xosRestPort;
    private Map<String, ConnectPoint> nodeToPort;

    @Activate
    public void activate() {
        this.readConfiguration();
        this.log.info("vBNG configuration service started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("vBNG configuration service stopped");
    }

    public void readConfiguration() {
        this.readConfiguration(this.configFileName);
    }

    private void readConfiguration(String configFilename) {
        File configFile = new File(CONFIG_DIR, configFilename);
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.log.info("Loading config: {}", (Object)configFile.getAbsolutePath());
            VbngConfiguration config = (VbngConfiguration)mapper.readValue(configFile, VbngConfiguration.class);
            for (IpPrefix prefix : config.getLocalPublicIpPrefixes()) {
                this.localPublicIpPrefixes.put(prefix, true);
            }
            this.nextHopIpAddress = config.getNextHopIpAddress();
            this.macOfPublicIpAddresses = config.getPublicFacingMac();
            this.xosIpAddress = config.getXosIpAddress();
            this.xosRestPort = config.getXosRestPort();
            this.nodeToPort = config.getHosts();
        }
        catch (FileNotFoundException e) {
            this.log.warn("Configuration file not found: {}", (Object)this.configFileName);
        }
        catch (IOException e) {
            this.log.error("Error loading configuration", (Throwable)e);
        }
    }

    @Override
    public IpAddress getNextHopIpAddress() {
        return this.nextHopIpAddress;
    }

    @Override
    public MacAddress getPublicFacingMac() {
        return this.macOfPublicIpAddresses;
    }

    @Override
    public IpAddress getXosIpAddress() {
        return this.xosIpAddress;
    }

    @Override
    public int getXosRestPort() {
        return this.xosRestPort;
    }

    @Override
    public Map<String, ConnectPoint> getNodeToPort() {
        return this.nodeToPort;
    }

    @Override
    public synchronized IpAddress getAvailablePublicIpAddress(IpAddress privateIpAddress) {
        IpAddress publicIpAddress = this.ipAddressMap.get(privateIpAddress);
        if (publicIpAddress != null) {
            return publicIpAddress;
        }
        for (Map.Entry<IpPrefix, Boolean> prefix : this.localPublicIpPrefixes.entrySet()) {
            if (!prefix.getValue().booleanValue()) continue;
            if (prefix.getKey().prefixLength() == 32) {
                this.updateIpPrefixStatus(prefix.getKey(), false);
                publicIpAddress = prefix.getKey().address();
                this.ipAddressMap.put(privateIpAddress, publicIpAddress);
                return publicIpAddress;
            }
            int prefixLen = prefix.getKey().prefixLength();
            int availableIpNum = (int)Math.pow(2.0, 32 - prefixLen) - 1;
            for (int i = 1; i <= availableIpNum; ++i) {
                publicIpAddress = this.increaseIpAddress(prefix.getKey().address(), i);
                if (publicIpAddress == null) {
                    return null;
                }
                if (this.ipAddressMap.values().contains(publicIpAddress)) continue;
                if (i == availableIpNum) {
                    this.updateIpPrefixStatus(prefix.getKey(), false);
                    this.ipAddressMap.put(privateIpAddress, publicIpAddress);
                    return publicIpAddress;
                }
                this.ipAddressMap.put(privateIpAddress, publicIpAddress);
                return publicIpAddress;
            }
        }
        return null;
    }

    @Override
    public IpAddress getAssignedPublicIpAddress(IpAddress privateIpAddress) {
        return this.ipAddressMap.get(privateIpAddress);
    }

    @Override
    public boolean isAssignedPublicIpAddress(IpAddress ipAddress) {
        return this.ipAddressMap.containsValue(ipAddress);
    }

    @Override
    public synchronized IpAddress recycleAssignedPublicIpAddress(IpAddress privateIpAddress) {
        IpAddress publicIpAddress = this.ipAddressMap.remove(privateIpAddress);
        if (publicIpAddress == null) {
            return null;
        }
        for (Map.Entry<IpPrefix, Boolean> prefixEntry : this.localPublicIpPrefixes.entrySet()) {
            if (!prefixEntry.getKey().contains(publicIpAddress) || prefixEntry.getValue().booleanValue()) continue;
            this.updateIpPrefixStatus(prefixEntry.getKey(), true);
        }
        this.log.info("[DELETE] Private IP to Public IP mapping: {} --> {}", (Object)privateIpAddress, (Object)publicIpAddress);
        return publicIpAddress;
    }

    @Override
    public Map<IpAddress, IpAddress> getIpAddressMappings() {
        return Collections.unmodifiableMap(this.ipAddressMap);
    }

    @Override
    public synchronized boolean assignSpecifiedPublicIp(IpAddress publicIpAddress, IpAddress privateIpAddress) {
        boolean isPublicIpExist = false;
        for (Map.Entry<IpPrefix, Boolean> prefix : this.localPublicIpPrefixes.entrySet()) {
            if (!prefix.getKey().contains(publicIpAddress)) continue;
            isPublicIpExist = true;
            if (!prefix.getValue().booleanValue() || this.isAssignedPublicIpAddress(publicIpAddress)) {
                this.log.info("The public IP address {} is already assigned, and not available.", (Object)publicIpAddress);
                return false;
            }
            this.ipAddressMap.put(privateIpAddress, publicIpAddress);
            if (prefix.getKey().prefixLength() == 32) {
                this.updateIpPrefixStatus(prefix.getKey(), false);
                return true;
            }
            int prefixLen = prefix.getKey().prefixLength();
            int availableIpNum = (int)Math.pow(2.0, 32 - prefixLen) - 1;
            int usedIpNum = 0;
            for (Map.Entry<IpAddress, IpAddress> ipAddressMapEntry : this.ipAddressMap.entrySet()) {
                if (!prefix.getKey().contains(ipAddressMapEntry.getValue())) continue;
                ++usedIpNum;
            }
            if (usedIpNum == availableIpNum) {
                this.updateIpPrefixStatus(prefix.getKey(), false);
            }
            return true;
        }
        if (!isPublicIpExist) {
            this.log.info("The public IP address {} retrieved from XOS mapping does not exist", (Object)publicIpAddress);
        }
        return false;
    }

    private IpAddress increaseIpAddress(IpAddress ipAddress, int num) {
        if (ipAddress.isIp6()) {
            this.log.info("vBNG currently does not handle IPv6");
            return null;
        }
        return IpAddress.valueOf((int)(ipAddress.getIp4Address().toInt() + num));
    }

    private void updateIpPrefixStatus(IpPrefix ipPprefix, boolean b) {
        this.localPublicIpPrefixes.replace(ipPprefix, b);
    }
}

