/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.virtualbng;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.virtualbng.RestClient;
import org.onosproject.virtualbng.VbngConfigurationService;
import org.onosproject.virtualbng.VbngService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class VbngManager
implements VbngService {
    private static final String APP_NAME = "org.onosproject.virtualbng";
    private static final String VBNG_MAP_NAME = "vbng_mapping";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VbngConfigurationService vbngConfigurationService;
    private ApplicationId appId;
    private Map<IpAddress, PointToPointIntent> p2pIntentsFromHost;
    private Map<IpAddress, PointToPointIntent> p2pIntentsToHost;
    private Map<IpAddress, VcpeHost> privateIpAddressMap;
    private Map<String, ConnectPoint> nodeToPort;
    private HostListener hostListener;
    private IpAddress nextHopIpAddress;
    private static final DeviceId FABRIC_DEVICE_ID = DeviceId.deviceId((String)"of:8f0e486e73000187");

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.p2pIntentsFromHost = new ConcurrentHashMap<IpAddress, PointToPointIntent>();
        this.p2pIntentsToHost = new ConcurrentHashMap<IpAddress, PointToPointIntent>();
        this.privateIpAddressMap = new ConcurrentHashMap<IpAddress, VcpeHost>();
        this.nextHopIpAddress = this.vbngConfigurationService.getNextHopIpAddress();
        this.nodeToPort = this.vbngConfigurationService.getNodeToPort();
        this.hostListener = new InternalHostListener();
        this.hostService.addListener((EventListener)this.hostListener);
        this.log.info("vBNG Started");
        this.statusRecovery();
    }

    @Deactivate
    public void deactivate() {
        this.hostService.removeListener((EventListener)this.hostListener);
        this.log.info("vBNG Stopped");
    }

    private void statusRecovery() {
        ObjectNode map;
        this.log.info("vBNG starts to recover from XOS record......");
        try {
            RestClient restClient = new RestClient(this.vbngConfigurationService.getXosIpAddress(), this.vbngConfigurationService.getXosRestPort());
            map = restClient.getRest();
        }
        catch (Exception e) {
            this.log.error("Could not contact XOS", (Throwable)e);
            return;
        }
        if (map == null) {
            this.log.info("Stop to recover vBNG status due to the vBNG map is null!");
            return;
        }
        this.log.info("Get record from XOS: {}", (Object)map);
        ArrayNode array = (ArrayNode)map.get(VBNG_MAP_NAME);
        Iterator entries = array.elements();
        while (entries.hasNext()) {
            ObjectNode entry = (ObjectNode)entries.next();
            IpAddress hostIpAdddress = IpAddress.valueOf((String)entry.get("private_ip").asText());
            IpAddress publicIpAddress = IpAddress.valueOf((String)entry.get("routeable_subnet").asText());
            MacAddress macAddress = MacAddress.valueOf((String)entry.get("mac").asText());
            String hostName = entry.get("hostname").asText();
            this.createVbng(hostIpAdddress, publicIpAddress, macAddress, hostName);
        }
    }

    private void createVbng(IpAddress privateIpAddress, IpAddress publicIpAddress, MacAddress hostMacAddress, String hostName) {
        boolean result = this.vbngConfigurationService.assignSpecifiedPublicIp(publicIpAddress, privateIpAddress);
        if (!result) {
            this.log.info("Assign public IP address {} for private IP address {} failed!", (Object)publicIpAddress, (Object)privateIpAddress);
            this.log.info("Failed to create vBNG for private IP address {}", (Object)privateIpAddress);
            return;
        }
        this.log.info("[ADD] Private IP to Public IP mapping: {} --> {}", (Object)privateIpAddress, (Object)publicIpAddress);
        if (!this.setupForwardingPaths(privateIpAddress, publicIpAddress, hostMacAddress, hostName)) {
            this.privateIpAddressMap.put(privateIpAddress, new VcpeHost(hostMacAddress, hostName));
        }
    }

    @Override
    public IpAddress createVbng(IpAddress privateIpAddress, MacAddress hostMacAddress, String hostName) {
        IpAddress publicIpAddress = this.vbngConfigurationService.getAvailablePublicIpAddress(privateIpAddress);
        if (publicIpAddress == null) {
            this.log.info("Did not find an available public IP address to use.");
            return null;
        }
        this.log.info("[ADD] Private IP to Public IP mapping: {} --> {}", (Object)privateIpAddress, (Object)publicIpAddress);
        if (!this.setupForwardingPaths(privateIpAddress, publicIpAddress, hostMacAddress, hostName)) {
            this.privateIpAddressMap.put(privateIpAddress, new VcpeHost(hostMacAddress, hostName));
        }
        return publicIpAddress;
    }

    @Override
    public IpAddress deleteVbng(IpAddress privateIpAddress) {
        IpAddress assignedPublicIpAddress = this.vbngConfigurationService.recycleAssignedPublicIpAddress(privateIpAddress);
        if (assignedPublicIpAddress == null) {
            return null;
        }
        this.privateIpAddressMap.remove(privateIpAddress);
        this.removeForwardingPaths(privateIpAddress);
        return assignedPublicIpAddress;
    }

    private void removeForwardingPaths(IpAddress privateIp) {
        PointToPointIntent toLocalHostIntent;
        PointToPointIntent toNextHopIntent = this.p2pIntentsFromHost.remove(privateIp);
        if (toNextHopIntent != null) {
            this.intentService.withdraw((Intent)toNextHopIntent);
        }
        if ((toLocalHostIntent = this.p2pIntentsToHost.remove(privateIp)) != null) {
            this.intentService.withdraw((Intent)toLocalHostIntent);
        }
    }

    private boolean setupForwardingPaths(IpAddress privateIp, IpAddress publicIp, MacAddress hostMacAddress, String hostName) {
        Preconditions.checkNotNull((Object)privateIp);
        Preconditions.checkNotNull((Object)publicIp);
        Preconditions.checkNotNull((Object)hostMacAddress);
        Preconditions.checkNotNull((Object)hostName);
        if (this.nextHopIpAddress == null) {
            this.log.warn("Did not find next hop IP address");
            return false;
        }
        if (this.p2pIntentsFromHost.containsKey(privateIp) && this.p2pIntentsToHost.containsKey(privateIp)) {
            return true;
        }
        Host nextHopHost = null;
        if (this.hostService.getHostsByIp(this.nextHopIpAddress).isEmpty()) {
            this.hostService.startMonitoringIp(this.nextHopIpAddress);
            if (this.hostService.getHostsByIp(privateIp).isEmpty()) {
                this.hostService.startMonitoringIp(privateIp);
            }
            return false;
        }
        nextHopHost = (Host)this.hostService.getHostsByIp(this.nextHopIpAddress).iterator().next();
        ConnectPoint nextHopConnectPoint = new ConnectPoint(nextHopHost.location().elementId(), nextHopHost.location().port());
        ConnectPoint localHostConnectPoint = this.nodeToPort.get(hostName);
        if (!this.p2pIntentsFromHost.containsKey(privateIp)) {
            PointToPointIntent toNextHopIntent = this.srcMatchIntentGenerator(privateIp, publicIp, nextHopHost.mac(), nextHopConnectPoint, localHostConnectPoint);
            this.p2pIntentsFromHost.put(privateIp, toNextHopIntent);
            this.intentService.submit((Intent)toNextHopIntent);
        }
        if (!this.p2pIntentsToHost.containsKey(privateIp)) {
            PointToPointIntent toLocalHostIntent = this.dstMatchIntentGenerator(publicIp, privateIp, hostMacAddress, localHostConnectPoint, nextHopConnectPoint);
            this.p2pIntentsToHost.put(privateIp, toLocalHostIntent);
            this.intentService.submit((Intent)toLocalHostIntent);
        }
        return true;
    }

    private void createVbngAgain(IpAddress privateIpAddress) {
        IpAddress publicIpAddress = this.vbngConfigurationService.getAssignedPublicIpAddress(privateIpAddress);
        if (publicIpAddress == null) {
            this.privateIpAddressMap.remove(privateIpAddress);
            return;
        }
        VcpeHost vcpeHost = this.privateIpAddressMap.get(privateIpAddress);
        if (this.setupForwardingPaths(privateIpAddress, publicIpAddress, vcpeHost.macAddress, vcpeHost.hostName)) {
            this.privateIpAddressMap.remove(privateIpAddress);
        }
    }

    private PointToPointIntent srcMatchIntentGenerator(IpAddress srcIpAddress, IpAddress newSrcIpAddress, MacAddress dstMacAddress, ConnectPoint dstConnectPoint, ConnectPoint srcConnectPoint) {
        Preconditions.checkNotNull((Object)srcIpAddress);
        Preconditions.checkNotNull((Object)newSrcIpAddress);
        Preconditions.checkNotNull((Object)dstMacAddress);
        Preconditions.checkNotNull((Object)dstConnectPoint);
        Preconditions.checkNotNull((Object)srcConnectPoint);
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchIPSrc(IpPrefix.valueOf((IpAddress)srcIpAddress, (int)32));
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.setEthDst(dstMacAddress);
        treatment.setIpSrc(newSrcIpAddress);
        Key key = Key.of((String)(srcIpAddress.toString() + "MatchSrc"), (ApplicationId)this.appId);
        PointToPointIntent intent = PointToPointIntent.builder().appId(this.appId).key(key).selector(selector.build()).treatment(treatment.build()).egressPoint(dstConnectPoint).ingressPoint(srcConnectPoint).build();
        this.log.info("Generated a PointToPointIntent for traffic from local host : {}", (Object)intent);
        return intent;
    }

    private PointToPointIntent dstMatchIntentGenerator(IpAddress dstIpAddress, IpAddress newDstIpAddress, MacAddress dstMacAddress, ConnectPoint dstConnectPoint, ConnectPoint srcConnectPoint) {
        Preconditions.checkNotNull((Object)dstIpAddress);
        Preconditions.checkNotNull((Object)newDstIpAddress);
        Preconditions.checkNotNull((Object)dstMacAddress);
        Preconditions.checkNotNull((Object)dstConnectPoint);
        Preconditions.checkNotNull((Object)srcConnectPoint);
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchIPDst(IpPrefix.valueOf((IpAddress)dstIpAddress, (int)32));
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.setEthDst(dstMacAddress);
        treatment.setIpDst(newDstIpAddress);
        Key key = Key.of((String)(newDstIpAddress.toString() + "MatchDst"), (ApplicationId)this.appId);
        PointToPointIntent intent = PointToPointIntent.builder().appId(this.appId).key(key).selector(selector.build()).treatment(treatment.build()).egressPoint(dstConnectPoint).ingressPoint(srcConnectPoint).build();
        this.log.info("Generated a PointToPointIntent for traffic to local host : {}", (Object)intent);
        return intent;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindVbngConfigurationService(VbngConfigurationService vbngConfigurationService) {
        this.vbngConfigurationService = vbngConfigurationService;
    }

    protected void unbindVbngConfigurationService(VbngConfigurationService vbngConfigurationService) {
        if (this.vbngConfigurationService == vbngConfigurationService) {
            this.vbngConfigurationService = null;
        }
    }

    private class VcpeHost {
        MacAddress macAddress;
        String hostName;

        public VcpeHost(MacAddress macAddress, String hostName) {
            this.macAddress = macAddress;
            this.hostName = hostName;
        }
    }

    private class InternalHostListener
    implements HostListener {
        private InternalHostListener() {
        }

        public void event(HostEvent event) {
            VbngManager.this.log.debug("Received HostEvent {}", (Object)event);
            Host host = (Host)event.subject();
            if (event.type() != HostEvent.Type.HOST_ADDED) {
                return;
            }
            for (IpAddress ipAddress : host.ipAddresses()) {
                if (VbngManager.this.nextHopIpAddress == null || !ipAddress.equals((Object)VbngManager.this.nextHopIpAddress)) continue;
                for (Map.Entry entry : VbngManager.this.privateIpAddressMap.entrySet()) {
                    VbngManager.this.createVbngAgain((IpAddress)entry.getKey());
                }
            }
        }
    }
}

