/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.virtualbng;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.net.MediaType;
import java.io.IOException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.onlab.packet.IpAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String UTF_8 = MediaType.JSON_UTF_8.toString();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String url;

    RestClient(IpAddress xosServerIpAddress, int xosServerPort) {
        this.url = "http://" + xosServerIpAddress.toString() + ":" + xosServerPort + "/xoslib/rs/vbng_mapping/";
    }

    public Invocation.Builder getClientBuilder(String localUrl) {
        this.log.info("URL: {}", (Object)localUrl);
        Client client = ClientBuilder.newClient();
        WebTarget wt = client.target(localUrl);
        return wt.request(new String[]{UTF_8});
    }

    public ObjectNode getRest() {
        JsonNode node;
        Invocation.Builder builder = this.getClientBuilder(this.url);
        Response response = builder.get();
        if (response.getStatus() != 200) {
            this.log.info("REST GET request returned error code {}", (Object)response.getStatus());
            return null;
        }
        String jsonString = (String)builder.get(String.class);
        this.log.info("Fetched JSON string: {}", (Object)jsonString);
        try {
            node = MAPPER.readTree(jsonString);
        }
        catch (IOException e) {
            this.log.error("Failed to read JSON string", (Throwable)e);
            return null;
        }
        return (ObjectNode)node;
    }
}

