/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.TestApplicationId;
import org.onosproject.app.ApplicationService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.HostServiceAdapter;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentServiceAdapter;
import org.onosproject.net.intent.IntentUtils;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.routing.IntentSynchronizationAdminService;
import org.onosproject.routing.IntentSynchronizationService;
import org.onosproject.vpls.Vpls;

public class VplsTest {
    private static final int NUM_DEVICES = 7;
    private static final MacAddress MAC1 = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private static final MacAddress MAC2 = MacAddress.valueOf((String)"00:00:00:00:00:02");
    private static final MacAddress MAC3 = MacAddress.valueOf((String)"00:00:00:00:00:03");
    private static final MacAddress MAC4 = MacAddress.valueOf((String)"00:00:00:00:00:04");
    private static final MacAddress MAC5 = MacAddress.valueOf((String)"00:00:00:00:00:05");
    private static final MacAddress MAC6 = MacAddress.valueOf((String)"00:00:00:00:00:06");
    private static final MacAddress MAC7 = MacAddress.valueOf((String)"00:00:00:00:00:07");
    private static final Ip4Address IP1 = Ip4Address.valueOf((String)"192.168.1.1");
    private static final Ip4Address IP2 = Ip4Address.valueOf((String)"192.168.1.2");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final VlanId VLAN1 = VlanId.vlanId((short)1);
    private static final VlanId VLAN2 = VlanId.vlanId((short)2);
    private static final int PRIORITY_OFFSET = 1000;
    private static final String PREFIX_BROADCAST = "brc";
    private static final String PREFIX_UNICAST = "uni";
    private static final DeviceId DID1 = VplsTest.getDeviceId(1);
    private static final DeviceId DID2 = VplsTest.getDeviceId(2);
    private static final DeviceId DID3 = VplsTest.getDeviceId(3);
    private static final DeviceId DID4 = VplsTest.getDeviceId(4);
    private static final DeviceId DID5 = VplsTest.getDeviceId(5);
    private static final DeviceId DID6 = VplsTest.getDeviceId(6);
    private static final ConnectPoint C1 = new ConnectPoint((ElementId)DID1, P1);
    private static final ConnectPoint C2 = new ConnectPoint((ElementId)DID2, P1);
    private static final ConnectPoint C3 = new ConnectPoint((ElementId)DID3, P1);
    private static final ConnectPoint C4 = new ConnectPoint((ElementId)DID4, P1);
    private static final ConnectPoint C5 = new ConnectPoint((ElementId)DID5, P1);
    private static final ConnectPoint C6 = new ConnectPoint((ElementId)DID6, P1);
    private static final HostId HID1 = HostId.hostId((MacAddress)MAC1, (VlanId)VLAN1);
    private static final HostId HID2 = HostId.hostId((MacAddress)MAC2, (VlanId)VLAN1);
    private static final HostId HID3 = HostId.hostId((MacAddress)MAC3, (VlanId)VLAN1);
    private static final HostId HID4 = HostId.hostId((MacAddress)MAC4, (VlanId)VLAN2);
    private static final HostId HID5 = HostId.hostId((MacAddress)MAC5, (VlanId)VLAN2);
    private static final HostId HID6 = HostId.hostId((MacAddress)MAC6, (VlanId)VLAN2);
    private static final HostId HID7 = HostId.hostId((MacAddress)MAC7, (VlanId)VlanId.NONE);
    private ApplicationService applicationService;
    private CoreService coreService;
    private HostListener hostListener;
    private Set<Host> hostsAvailable;
    private HostService hostService;
    private IntentService intentService;
    private InterfaceService interfaceService;
    private Vpls vpls;
    private static final String APP_NAME = "org.onosproject.vpls";
    private static final ApplicationId APPID = TestApplicationId.create((String)"org.onosproject.vpls");
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static IdGenerator idGenerator;

    @Before
    public void setUp() throws Exception {
        idGenerator = new TestIdGenerator();
        Intent.bindIdGenerator((IdGenerator)idGenerator);
        this.applicationService = (ApplicationService)EasyMock.createMock(ApplicationService.class);
        this.coreService = (CoreService)EasyMock.createMock(CoreService.class);
        EasyMock.expect((Object)this.coreService.registerApplication(APP_NAME)).andReturn((Object)APPID);
        EasyMock.replay((Object[])new Object[]{this.coreService});
        this.hostsAvailable = Sets.newHashSet();
        this.hostService = new TestHostService(this.hostsAvailable);
        this.intentService = new TestIntentService();
        TestIntentSynchronizer intentSynchronizer = new TestIntentSynchronizer(this.intentService);
        this.interfaceService = (InterfaceService)EasyMock.createMock(InterfaceService.class);
        this.interfaceService.addListener((EventListener)EasyMock.anyObject(InterfaceListener.class));
        EasyMock.expectLastCall().anyTimes();
        this.addIntfConfig();
        this.vpls = new Vpls();
        this.vpls.applicationService = this.applicationService;
        this.vpls.coreService = this.coreService;
        this.vpls.hostService = this.hostService;
        this.vpls.intentService = this.intentService;
        this.vpls.interfaceService = this.interfaceService;
        this.vpls.intentSynchronizer = intentSynchronizer;
    }

    @After
    public void tearDown() {
        Intent.unbindIdGenerator((IdGenerator)idGenerator);
    }

    private void addIntfConfig() {
        HashSet interfaces = Sets.newHashSet();
        HashSet vlanOneSet = Sets.newHashSet();
        HashSet vlanTwoSet = Sets.newHashSet();
        for (int i = 1; i <= 6; ++i) {
            ConnectPoint cp = new ConnectPoint((ElementId)VplsTest.getDeviceId(i), P1);
            Interface intf = new Interface("intfOne", cp, Collections.emptyList(), null, VlanId.NONE);
            if (i <= 3) {
                intf = new Interface("intfTwo", cp, Collections.emptyList(), null, VLAN1);
                interfaces.add(intf);
                vlanOneSet.add(intf);
            } else if (i > 3 && i <= 6) {
                intf = new Interface("intfThree", cp, Collections.emptyList(), null, VLAN2);
                interfaces.add(intf);
                vlanTwoSet.add(intf);
            }
            EasyMock.expect((Object)this.interfaceService.getInterfacesByPort(cp)).andReturn((Object)Sets.newHashSet((Object[])new Interface[]{intf})).anyTimes();
        }
        EasyMock.expect((Object)this.interfaceService.getInterfacesByVlan(VLAN1)).andReturn((Object)vlanOneSet).anyTimes();
        EasyMock.expect((Object)this.interfaceService.getInterfacesByVlan(VLAN2)).andReturn((Object)vlanTwoSet).anyTimes();
        EasyMock.expect((Object)this.interfaceService.getInterfaces()).andReturn((Object)interfaces).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.interfaceService});
    }

    @Test
    public void testActivateNoHosts() {
        this.vpls.activate();
        ArrayList expectedIntents = Lists.newArrayList();
        expectedIntents.addAll(this.generateVlanOneBrc());
        expectedIntents.addAll(this.generateVlanTwoBrc());
        this.checkIntents(expectedIntents);
    }

    @Test
    public void testFourInterfacesConfiguredHostsPresent() {
        DefaultHost h1 = new DefaultHost(PID, HID1, MAC1, VLAN1, VplsTest.getLocation(1), Collections.singleton(IP1), new Annotations[0]);
        DefaultHost h2 = new DefaultHost(PID, HID2, MAC2, VLAN1, VplsTest.getLocation(2), Collections.singleton(IP2), new Annotations[0]);
        DefaultHost h3 = new DefaultHost(PID, HID3, MAC3, VLAN1, VplsTest.getLocation(3), Collections.EMPTY_SET, new Annotations[0]);
        DefaultHost h4 = new DefaultHost(PID, HID4, MAC4, VLAN2, VplsTest.getLocation(4), Collections.EMPTY_SET, new Annotations[0]);
        DefaultHost h5 = new DefaultHost(PID, HID5, MAC5, VLAN2, VplsTest.getLocation(5), Collections.EMPTY_SET, new Annotations[0]);
        DefaultHost h6 = new DefaultHost(PID, HID6, MAC6, VLAN2, VplsTest.getLocation(6), Collections.EMPTY_SET, new Annotations[0]);
        this.hostsAvailable.addAll(Sets.newHashSet((Object[])new Host[]{h1, h2, h3, h4, h5, h6}));
        this.vpls.activate();
        ArrayList expectedIntents = Lists.newArrayList();
        expectedIntents.addAll(this.generateVlanOneBrc());
        expectedIntents.addAll(this.generateVlanOneUni());
        expectedIntents.addAll(this.generateVlanTwoBrc());
        expectedIntents.addAll(this.generateVlanTwoUni());
        this.checkIntents(expectedIntents);
    }

    @Test
    public void testFourInterfacesThreeHostEventsSameVlan() {
        this.vpls.activate();
        DefaultHost h1 = new DefaultHost(PID, HID1, MAC1, VLAN1, VplsTest.getLocation(1), Collections.singleton(IP1), new Annotations[0]);
        DefaultHost h2 = new DefaultHost(PID, HID2, MAC2, VLAN1, VplsTest.getLocation(2), Collections.singleton(IP2), new Annotations[0]);
        DefaultHost h3 = new DefaultHost(PID, HID3, MAC3, VLAN1, VplsTest.getLocation(3), Collections.EMPTY_SET, new Annotations[0]);
        DefaultHost h7 = new DefaultHost(PID, HID7, MAC7, VLAN1, VplsTest.getLocation(7), Collections.EMPTY_SET, new Annotations[0]);
        this.hostsAvailable.addAll(Sets.newHashSet((Object[])new Host[]{h1, h2, h3, h7}));
        this.hostsAvailable.forEach(host -> this.hostListener.event((Event)new HostEvent(HostEvent.Type.HOST_ADDED, host)));
        ArrayList expectedIntents = Lists.newArrayList();
        expectedIntents.addAll(this.generateVlanOneBrc());
        expectedIntents.addAll(this.generateVlanOneUni());
        expectedIntents.addAll(this.generateVlanTwoBrc());
        this.checkIntents(expectedIntents);
    }

    @Test
    public void testFourInterfacesTwoHostEventsDifferentVlan() {
        this.vpls.activate();
        DefaultHost h1 = new DefaultHost(PID, HID1, MAC1, VLAN1, VplsTest.getLocation(1), Collections.singleton(IP1), new Annotations[0]);
        DefaultHost h4 = new DefaultHost(PID, HID4, MAC4, VLAN2, VplsTest.getLocation(4), Collections.EMPTY_SET, new Annotations[0]);
        this.hostsAvailable.addAll(Sets.newHashSet((Object[])new Host[]{h1, h4}));
        this.hostsAvailable.forEach(host -> this.hostListener.event((Event)new HostEvent(HostEvent.Type.HOST_ADDED, host)));
        ArrayList expectedIntents = Lists.newArrayList();
        expectedIntents.addAll(this.generateVlanOneBrc());
        expectedIntents.addAll(this.generateVlanTwoBrc());
        this.checkIntents(expectedIntents);
    }

    private void checkIntents(List<Intent> intents) {
        Assert.assertEquals((long)intents.size(), (long)this.intentService.getIntentCount());
        for (Intent intentOne : intents) {
            boolean found = false;
            for (Intent intentTwo : this.intentService.getIntents()) {
                if (!intentOne.key().equals((Object)intentTwo.key())) continue;
                found = true;
                Assert.assertTrue((String)String.format("Comparing %s and %s", intentOne, intentTwo), (boolean)IntentUtils.intentsAreEqual((Intent)intentOne, (Intent)intentTwo));
                break;
            }
            Assert.assertTrue((boolean)found);
        }
    }

    private List<SinglePointToMultiPointIntent> generateVlanOneBrc() {
        Key key = null;
        ArrayList intents = Lists.newArrayList();
        key = Key.of((String)("brc-" + DID1 + "-" + P1 + "-" + VLAN1), (ApplicationId)APPID);
        intents.add(this.buildBrcIntent(key, C1, Sets.newHashSet((Object[])new ConnectPoint[]{C2, C3}), VLAN1));
        key = Key.of((String)("brc-" + DID2 + "-" + P1 + "-" + VLAN1), (ApplicationId)APPID);
        intents.add(this.buildBrcIntent(key, C2, Sets.newHashSet((Object[])new ConnectPoint[]{C1, C3}), VLAN1));
        key = Key.of((String)("brc-" + DID3 + "-" + P1 + "-" + VLAN1), (ApplicationId)APPID);
        intents.add(this.buildBrcIntent(key, C3, Sets.newHashSet((Object[])new ConnectPoint[]{C1, C2}), VLAN1));
        return intents;
    }

    private List<MultiPointToSinglePointIntent> generateVlanOneUni() {
        Key key = null;
        ArrayList intents = Lists.newArrayList();
        key = Key.of((String)("uni-" + DID1 + "-" + P1 + "-" + VLAN1), (ApplicationId)APPID);
        intents.add(this.buildUniIntent(key, Sets.newHashSet((Object[])new ConnectPoint[]{C2, C3}), C1, VLAN1, MAC1));
        key = Key.of((String)("uni-" + DID2 + "-" + P1 + "-" + VLAN1), (ApplicationId)APPID);
        intents.add(this.buildUniIntent(key, Sets.newHashSet((Object[])new ConnectPoint[]{C1, C3}), C2, VLAN1, MAC2));
        key = Key.of((String)("uni-" + DID3 + "-" + P1 + "-" + VLAN1), (ApplicationId)APPID);
        intents.add(this.buildUniIntent(key, Sets.newHashSet((Object[])new ConnectPoint[]{C1, C2}), C3, VLAN1, MAC3));
        return intents;
    }

    private List<SinglePointToMultiPointIntent> generateVlanTwoBrc() {
        Key key = null;
        ArrayList intents = Lists.newArrayList();
        key = Key.of((String)("brc-" + DID4 + "-" + P1 + "-" + VLAN2), (ApplicationId)APPID);
        intents.add(this.buildBrcIntent(key, C4, Sets.newHashSet((Object[])new ConnectPoint[]{C5, C6}), VLAN2));
        key = Key.of((String)("brc-" + DID5 + "-" + P1 + "-" + VLAN2), (ApplicationId)APPID);
        intents.add(this.buildBrcIntent(key, C5, Sets.newHashSet((Object[])new ConnectPoint[]{C4, C6}), VLAN2));
        key = Key.of((String)("brc-" + DID6 + "-" + P1 + "-" + VLAN2), (ApplicationId)APPID);
        intents.add(this.buildBrcIntent(key, C6, Sets.newHashSet((Object[])new ConnectPoint[]{C4, C5}), VLAN2));
        return intents;
    }

    private List<MultiPointToSinglePointIntent> generateVlanTwoUni() {
        Key key = null;
        ArrayList intents = Lists.newArrayList();
        key = Key.of((String)("uni-" + DID4 + "-" + P1 + "-" + VLAN2), (ApplicationId)APPID);
        intents.add(this.buildUniIntent(key, Sets.newHashSet((Object[])new ConnectPoint[]{C5, C6}), C4, VLAN2, MAC4));
        key = Key.of((String)("uni-" + DID5 + "-" + P1 + "-" + VLAN2), (ApplicationId)APPID);
        intents.add(this.buildUniIntent(key, Sets.newHashSet((Object[])new ConnectPoint[]{C4, C6}), C5, VLAN2, MAC5));
        key = Key.of((String)("uni-" + DID6 + "-" + P1 + "-" + VLAN2), (ApplicationId)APPID);
        intents.add(this.buildUniIntent(key, Sets.newHashSet((Object[])new ConnectPoint[]{C4, C5}), C6, VLAN2, MAC6));
        return intents;
    }

    private SinglePointToMultiPointIntent buildBrcIntent(Key key, ConnectPoint src, Set<ConnectPoint> dsts, VlanId vlanId) {
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthDst(MacAddress.BROADCAST).matchVlanId(vlanId).build();
        SinglePointToMultiPointIntent intent = SinglePointToMultiPointIntent.builder().appId(APPID).key(key).selector(selector).treatment(treatment).ingressPoint(src).egressPoints(dsts).priority(1000).build();
        return intent;
    }

    private MultiPointToSinglePointIntent buildUniIntent(Key key, Set<ConnectPoint> srcs, ConnectPoint dst, VlanId vlanId, MacAddress mac) {
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        TrafficSelector.Builder builder = DefaultTrafficSelector.builder().matchEthDst(mac).matchVlanId(vlanId);
        TrafficSelector selector = builder.build();
        MultiPointToSinglePointIntent intent = MultiPointToSinglePointIntent.builder().appId(APPID).key(key).selector(selector).treatment(treatment).ingressPoints(srcs).egressPoint(dst).priority(1000).build();
        return intent;
    }

    private static DeviceId getDeviceId(int i) {
        return DeviceId.deviceId((String)("" + i));
    }

    private static HostLocation getLocation(int i) {
        return new HostLocation(new ConnectPoint((ElementId)VplsTest.getDeviceId(i), P1), 123L);
    }

    private class TestIntentSynchronizer
    implements IntentSynchronizationService,
    IntentSynchronizationAdminService {
        private final IntentService intentService;

        public TestIntentSynchronizer(IntentService intentService) {
            this.intentService = intentService;
        }

        public void submit(Intent intent) {
            this.intentService.submit(intent);
        }

        public void withdraw(Intent intent) {
            this.intentService.withdraw(intent);
        }

        public void modifyPrimary(boolean isPrimary) {
        }

        public void removeIntents() {
        }

        public void removeIntentsByAppId(ApplicationId applicationId) {
        }
    }

    private static class TestIdGenerator
    implements IdGenerator {
        private final AtomicLong id = new AtomicLong(0L);

        private TestIdGenerator() {
        }

        public long getNewId() {
            return this.id.getAndIncrement();
        }
    }

    private class TestHostService
    extends HostServiceAdapter {
        private Set<Host> hosts;

        public TestHostService(Set<Host> hosts) {
            this.hosts = hosts;
        }

        public void addListener(HostListener listener) {
            VplsTest.this.hostListener = listener;
        }

        public Set<Host> getConnectedHosts(ConnectPoint connectPoint) {
            return this.hosts.stream().filter(h -> h.location().elementId().equals(connectPoint.elementId()) && h.location().port().equals((Object)connectPoint.port())).collect(Collectors.toSet());
        }
    }

    private class TestIntentService
    extends IntentServiceAdapter {
        private Set<Intent> intents = Sets.newHashSet();

        public void submit(Intent intent) {
            this.intents.add(intent);
        }

        public long getIntentCount() {
            return this.intents.size();
        }

        public Iterable<Intent> getIntents() {
            return this.intents;
        }

        public Intent getIntent(Key intentKey) {
            for (Intent intent : this.intents) {
                if (!intent.key().equals((Object)intentKey)) continue;
                return intent;
            }
            return null;
        }
    }
}

