/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;
import org.onosproject.routing.IntentSynchronizationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntentInstaller {
    private static final Logger log = LoggerFactory.getLogger(IntentInstaller.class);
    private static final int PRIORITY_OFFSET = 1000;
    private static final String PREFIX_BROADCAST = "brc";
    private static final String PREFIX_UNICAST = "uni";
    private final ApplicationId appId;
    private final IntentSynchronizationService intentSynchronizer;
    private final IntentService intentService;

    public IntentInstaller(ApplicationId appId, IntentService intentService, IntentSynchronizationService intentSynchronizer) {
        this.appId = appId;
        this.intentService = intentService;
        this.intentSynchronizer = intentSynchronizer;
    }

    protected void installIntents(SetMultimap<VlanId, Pair<ConnectPoint, MacAddress>> confHostPresentCPoint) {
        ArrayList<Intent> intents = new ArrayList<Intent>();
        confHostPresentCPoint.keySet().stream().filter(vlanId -> confHostPresentCPoint.get(vlanId) != null).forEach(vlanId -> {
            Set cPoints = confHostPresentCPoint.get(vlanId);
            cPoints.forEach(cPoint -> {
                Key uniKey;
                MacAddress mac = (MacAddress)cPoint.getValue();
                ConnectPoint src = (ConnectPoint)cPoint.getKey();
                Set<ConnectPoint> dsts = cPoints.stream().map(Pair::getKey).filter(cp -> !cp.equals((Object)src)).collect(Collectors.toSet());
                Key brcKey = this.buildKey(PREFIX_BROADCAST, src, (VlanId)vlanId);
                if (this.intentService.getIntent(brcKey) == null && dsts.size() > 0) {
                    intents.add((Intent)this.buildBrcIntent(brcKey, src, dsts, (VlanId)vlanId));
                }
                if (mac != null && this.countMacInCPoints(cPoints) > 1 && dsts.size() > 0 && this.intentService.getIntent(uniKey = this.buildKey(PREFIX_UNICAST, src, (VlanId)vlanId)) == null) {
                    MultiPointToSinglePointIntent uniIntent = this.buildUniIntent(uniKey, dsts, src, (VlanId)vlanId, mac);
                    intents.add((Intent)uniIntent);
                }
            });
        });
        this.submitIntents(intents);
    }

    private void submitIntents(Collection<Intent> intents) {
        log.debug("Submitting intents to the Intent Synchronizer");
        intents.forEach(intent -> this.intentSynchronizer.submit(intent));
    }

    private SinglePointToMultiPointIntent buildBrcIntent(Key key, ConnectPoint src, Set<ConnectPoint> dsts, VlanId vlanId) {
        log.debug("Building p2mp intent from {}", (Object)src);
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        TrafficSelector.Builder builder = DefaultTrafficSelector.builder().matchEthDst(MacAddress.BROADCAST).matchVlanId(vlanId);
        TrafficSelector selector = builder.build();
        SinglePointToMultiPointIntent intent = SinglePointToMultiPointIntent.builder().appId(this.appId).key(key).selector(selector).treatment(treatment).ingressPoint(src).egressPoints(dsts).priority(1000).build();
        return intent;
    }

    private MultiPointToSinglePointIntent buildUniIntent(Key key, Set<ConnectPoint> srcs, ConnectPoint dst, VlanId vlanId, MacAddress mac) {
        log.debug("Building mp2p intent to {}", (Object)dst);
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        TrafficSelector.Builder builder = DefaultTrafficSelector.builder().matchEthDst(mac).matchVlanId(vlanId);
        TrafficSelector selector = builder.build();
        MultiPointToSinglePointIntent intent = MultiPointToSinglePointIntent.builder().appId(this.appId).key(key).selector(selector).treatment(treatment).ingressPoints(srcs).egressPoint(dst).priority(1000).build();
        return intent;
    }

    private Key buildKey(String prefix, ConnectPoint cPoint, VlanId vlanId) {
        String keyString = prefix + "-" + cPoint.deviceId() + "-" + cPoint.port() + "-" + vlanId;
        return Key.of((String)keyString, (ApplicationId)this.appId);
    }

    private int countMacInCPoints(Set<Pair<ConnectPoint, MacAddress>> cPoints) {
        return (int)cPoints.stream().filter(p -> p.getValue() != null).count();
    }
}

