/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.app.ApplicationService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.IntentService;
import org.onosproject.routing.IntentSynchronizationService;
import org.onosproject.vpls.IntentInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class Vpls {
    protected static final String VPLS_APP = "org.onosproject.vpls";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationService applicationService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentSynchronizationService intentSynchronizer;
    private final HostListener hostListener = new InternalHostListener();
    private final InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private IntentInstaller intentInstaller;
    private ApplicationId appId;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(VPLS_APP);
        this.intentInstaller = new IntentInstaller(this.appId, this.intentService, this.intentSynchronizer);
        this.applicationService.registerDeactivateHook(this.appId, () -> this.intentSynchronizer.removeIntentsByAppId(this.appId));
        this.hostService.addListener((EventListener)this.hostListener);
        this.interfaceService.addListener((EventListener)this.interfaceListener);
        this.setupConnectivity();
        this.log.debug("Activated");
    }

    @Deactivate
    public void deactivate() {
        this.intentSynchronizer.removeIntentsByAppId(this.appId);
        this.log.debug("Deactivated");
    }

    protected void setupConnectivity() {
        SetMultimap<VlanId, ConnectPoint> confCPointsByVlan = this.getConfigCPoints();
        SetMultimap<VlanId, Pair<ConnectPoint, MacAddress>> confHostPresentCPoint = this.pairAvailableHosts(confCPointsByVlan);
        this.intentInstaller.installIntents(confHostPresentCPoint);
    }

    protected SetMultimap<VlanId, ConnectPoint> getConfigCPoints() {
        this.log.debug("Checking interface configuration");
        HashMultimap confCPointsByVlan = HashMultimap.create();
        this.interfaceService.getInterfaces().stream().filter(intf -> intf.ipAddressesList().isEmpty()).forEach(arg_0 -> Vpls.lambda$getConfigCPoints$8((SetMultimap)confCPointsByVlan, arg_0));
        return confCPointsByVlan;
    }

    protected SetMultimap<VlanId, Pair<ConnectPoint, MacAddress>> pairAvailableHosts(SetMultimap<VlanId, ConnectPoint> confCPointsByVlan) {
        this.log.debug("Binding connected hosts MAC addresses");
        HashMultimap confHostPresentCPoint = HashMultimap.create();
        confCPointsByVlan.entries().forEach(arg_0 -> this.lambda$pairAvailableHosts$9((SetMultimap)confHostPresentCPoint, arg_0));
        return confHostPresentCPoint;
    }

    private void bindMacAddr(Map.Entry<VlanId, ConnectPoint> e, SetMultimap<VlanId, Pair<ConnectPoint, MacAddress>> confHostPresentCPoint) {
        VlanId vlanId = e.getKey();
        ConnectPoint cp = e.getValue();
        Set connectedHosts = this.hostService.getConnectedHosts(cp);
        connectedHosts.forEach(host -> {
            if (host.vlan().equals((Object)vlanId)) {
                confHostPresentCPoint.put((Object)vlanId, (Object)Pair.of((Object)cp, (Object)host.mac()));
            } else {
                confHostPresentCPoint.put((Object)vlanId, (Object)Pair.of((Object)cp, null));
            }
        });
        if (connectedHosts.isEmpty()) {
            confHostPresentCPoint.put((Object)vlanId, (Object)Pair.of((Object)cp, null));
        }
    }

    private /* synthetic */ void lambda$pairAvailableHosts$9(SetMultimap confHostPresentCPoint, Map.Entry e) {
        this.bindMacAddr(e, (SetMultimap<VlanId, Pair<ConnectPoint, MacAddress>>)confHostPresentCPoint);
    }

    private static /* synthetic */ void lambda$getConfigCPoints$8(SetMultimap confCPointsByVlan, Interface intf) {
        confCPointsByVlan.put((Object)intf.vlan(), (Object)intf.connectPoint());
    }

    protected void bindApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    protected void unbindApplicationService(ApplicationService applicationService) {
        if (this.applicationService == applicationService) {
            this.applicationService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindIntentSynchronizer(IntentSynchronizationService intentSynchronizationService) {
        this.intentSynchronizer = intentSynchronizationService;
    }

    protected void unbindIntentSynchronizer(IntentSynchronizationService intentSynchronizationService) {
        if (this.intentSynchronizer == intentSynchronizationService) {
            this.intentSynchronizer = null;
        }
    }

    private class InternalInterfaceListener
    implements InterfaceListener {
        private InternalInterfaceListener() {
        }

        public void event(InterfaceEvent event) {
            Vpls.this.log.debug("Received InterfaceConfigEvent {}", (Object)event);
            switch ((InterfaceEvent.Type)event.type()) {
                case INTERFACE_ADDED: 
                case INTERFACE_UPDATED: 
                case INTERFACE_REMOVED: {
                    Vpls.this.setupConnectivity();
                    break;
                }
            }
        }
    }

    class InternalHostListener
    implements HostListener {
        InternalHostListener() {
        }

        public void event(HostEvent event) {
            Vpls.this.log.debug("Received HostEvent {}", (Object)event);
            switch ((HostEvent.Type)event.type()) {
                case HOST_ADDED: 
                case HOST_UPDATED: 
                case HOST_REMOVED: {
                    Vpls.this.setupConnectivity();
                    break;
                }
            }
        }
    }
}

