/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.incubator.net.neighbour.NeighbourMessageHandler;
import org.onosproject.incubator.net.neighbour.NeighbourResolutionService;
import org.onosproject.net.Host;
import org.onosproject.net.host.HostService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class VplsNeighbourHandler {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NeighbourResolutionService neighbourService;
    private VplsInterfaceListener interfaceListener = new VplsInterfaceListener();
    private VplsNeighbourMessageHandler neighbourHandler = new VplsNeighbourMessageHandler();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<Interface, NeighbourMessageHandler> neighbourHandlers = Maps.newHashMap();
    private ApplicationId appId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.vpls");
        this.interfaceService.addListener((EventListener)this.interfaceListener);
        this.interfaceService.getInterfaces().forEach(intf -> {
            this.neighbourHandlers.put((Interface)intf, this.neighbourHandler);
            this.neighbourService.registerNeighbourHandler(intf, (NeighbourMessageHandler)this.neighbourHandler, this.appId);
        });
        this.log.debug("Activated");
    }

    @Deactivate
    protected void deactivate() {
        this.interfaceService.removeListener((EventListener)this.interfaceListener);
        this.neighbourHandlers.entrySet().forEach(e -> this.neighbourService.unregisterNeighbourHandler((Interface)e.getKey(), (NeighbourMessageHandler)e.getValue(), this.appId));
        this.log.debug("Deactivated");
    }

    private void configNeighbourHandler(Interface intf, NeighbourMessageHandler handler, InterfaceEvent.Type eventType) {
        switch (eventType) {
            case INTERFACE_ADDED: {
                this.neighbourHandlers.put(intf, handler);
                this.neighbourService.registerNeighbourHandler(intf, handler, this.appId);
                break;
            }
            case INTERFACE_REMOVED: {
                this.neighbourHandlers.remove(intf, handler);
                this.neighbourService.unregisterNeighbourHandler(intf, handler, this.appId);
                break;
            }
            case INTERFACE_UPDATED: {
                break;
            }
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindNeighbourService(NeighbourResolutionService neighbourResolutionService) {
        this.neighbourService = neighbourResolutionService;
    }

    protected void unbindNeighbourService(NeighbourResolutionService neighbourResolutionService) {
        if (this.neighbourService == neighbourResolutionService) {
            this.neighbourService = null;
        }
    }

    private class VplsInterfaceListener
    implements InterfaceListener {
        private VplsInterfaceListener() {
        }

        public void event(InterfaceEvent event) {
            VplsNeighbourHandler.this.configNeighbourHandler((Interface)event.subject(), VplsNeighbourHandler.this.neighbourHandler, (InterfaceEvent.Type)event.type());
        }
    }

    private class VplsNeighbourMessageHandler
    implements NeighbourMessageHandler {
        private VplsNeighbourMessageHandler() {
        }

        public void handleMessage(NeighbourMessageContext context, HostService hostService) {
            switch (context.type()) {
                case REQUEST: {
                    VplsNeighbourHandler.this.interfaceService.getInterfacesByVlan(context.vlan()).stream().map(Interface::connectPoint).forEach(arg_0 -> ((NeighbourMessageContext)context).forward(arg_0));
                    break;
                }
                case REPLY: {
                    hostService.getHostsByMac(context.dstMac()).stream().filter(host -> host.vlan().equals((Object)context.vlan())).map(Host::location).forEach(arg_0 -> ((NeighbourMessageContext)context).forward(arg_0));
                    break;
                }
                default: {
                    VplsNeighbourHandler.this.log.warn("Unknown context type: {}", (Object)context.type());
                }
            }
        }
    }
}

