/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.cli.completer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.onosproject.cli.AbstractChoicesCompleter;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.net.EncapsulationType;
import org.onosproject.vpls.cli.VplsCommandEnum;
import org.onosproject.vpls.config.VplsConfigService;

public class VplsOptArgCompleter
extends AbstractChoicesCompleter {
    public List<String> choices() {
        VplsConfigService vplsConfigService = (VplsConfigService)AbstractShellCommand.get(VplsConfigService.class);
        ArrayList argumentList = Lists.newArrayList((Object[])this.getArgumentList().getArguments());
        String argOne = (String)argumentList.get(1);
        VplsCommandEnum vplsCommandEnum = VplsCommandEnum.enumFromString(argOne);
        if (vplsCommandEnum != null) {
            switch (vplsCommandEnum) {
                case ADD_IFACE: {
                    return this.availableIfaces(vplsConfigService);
                }
                case SET_ENCAP: {
                    return this.encap();
                }
                case REMOVE_IFACE: {
                    return this.vplsIfaces(vplsConfigService);
                }
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private List<String> availableIfaces(VplsConfigService vplsConfigService) {
        ArrayList ifacesAvailable = Lists.newArrayList();
        HashSet allIfaces = Sets.newHashSet(vplsConfigService.allIfaces());
        HashSet usedIfaces = Sets.newHashSet(vplsConfigService.ifaces());
        allIfaces.removeAll(usedIfaces);
        allIfaces.forEach(iface -> ifacesAvailable.add(iface.name()));
        return ifacesAvailable;
    }

    private List<String> encap() {
        return Arrays.stream(EncapsulationType.values()).map(Enum::toString).collect(Collectors.toList());
    }

    private List<String> vplsIfaces(VplsConfigService vplsConfigService) {
        ArgumentCompleter.ArgumentList list = this.getArgumentList();
        String vplsName = list.getArguments()[2];
        ArrayList vplsIfaces = Lists.newArrayList();
        Set<Interface> connectPoints = vplsConfigService.ifaces(vplsName);
        connectPoints.forEach(iface -> vplsIfaces.add(iface.name()));
        return vplsIfaces;
    }
}

