/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.SetMultimap;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.incubator.net.neighbour.NeighbourMessageHandler;
import org.onosproject.incubator.net.neighbour.NeighbourResolutionService;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.HostService;
import org.onosproject.vpls.config.VplsConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class VplsNeighbourHandler {
    private static final String UNKNOWN_CONTEXT = "Unknown context type: {}";
    private static final String CAN_NOT_FIND_VPLS = "Cannot find VPLS for port {} with VLAN Id {}.";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NeighbourResolutionService neighbourService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VplsConfigService vplsConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService configService;
    private VplsInterfaceListener interfaceListener = new VplsInterfaceListener();
    protected VplsNeighbourMessageHandler neighbourHandler = new VplsNeighbourMessageHandler();
    protected VplsConfigListener configListener = new VplsConfigListener();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationId appId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.vpls");
        this.interfaceService.addListener((EventListener)this.interfaceListener);
        this.configService.addListener((EventListener)this.configListener);
        this.configNeighbourHandler();
    }

    @Deactivate
    protected void deactivate() {
        this.interfaceService.removeListener((EventListener)this.interfaceListener);
        this.configService.removeListener((EventListener)this.configListener);
        this.neighbourService.unregisterNeighbourHandlers(this.appId);
    }

    private void configNeighbourHandler() {
        this.neighbourService.unregisterNeighbourHandlers(this.appId);
        Set<Interface> interfaces = this.vplsConfigService.allIfaces();
        this.interfaceService.getInterfaces().stream().filter(interfaces::contains).forEach(intf -> this.neighbourService.registerNeighbourHandler(intf, (NeighbourMessageHandler)this.neighbourHandler, this.appId));
    }

    protected void handleRequest(NeighbourMessageContext context) {
        SetMultimap<String, Interface> interfaces = this.vplsConfigService.ifacesByVplsName(context.vlan(), context.inPort());
        if (interfaces != null) {
            interfaces.values().stream().filter(intf -> !context.inPort().equals((Object)intf.connectPoint())).forEach(arg_0 -> ((NeighbourMessageContext)context).forward(arg_0));
        } else {
            this.log.debug(CAN_NOT_FIND_VPLS, (Object)context.inPort(), (Object)context.vlan());
        }
    }

    protected void handleReply(NeighbourMessageContext context, HostService hostService) {
        Set hosts = hostService.getHostsByMac(context.dstMac());
        SetMultimap<String, Interface> interfaces = this.vplsConfigService.ifacesByVplsName(context.vlan(), context.inPort());
        if (interfaces != null) {
            hosts.forEach(host -> interfaces.values().stream().filter(intf -> intf.connectPoint().equals((Object)host.location())).filter(intf -> intf.vlan().equals((Object)host.vlan())).forEach(arg_0 -> ((NeighbourMessageContext)context).forward(arg_0)));
        } else {
            this.log.debug(CAN_NOT_FIND_VPLS, (Object)context.inPort(), (Object)context.vlan());
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindNeighbourService(NeighbourResolutionService neighbourResolutionService) {
        this.neighbourService = neighbourResolutionService;
    }

    protected void unbindNeighbourService(NeighbourResolutionService neighbourResolutionService) {
        if (this.neighbourService == neighbourResolutionService) {
            this.neighbourService = null;
        }
    }

    protected void bindVplsConfigService(VplsConfigService vplsConfigService) {
        this.vplsConfigService = vplsConfigService;
    }

    protected void unbindVplsConfigService(VplsConfigService vplsConfigService) {
        if (this.vplsConfigService == vplsConfigService) {
            this.vplsConfigService = null;
        }
    }

    protected void bindConfigService(NetworkConfigService networkConfigService) {
        this.configService = networkConfigService;
    }

    protected void unbindConfigService(NetworkConfigService networkConfigService) {
        if (this.configService == networkConfigService) {
            this.configService = null;
        }
    }

    private class VplsConfigListener
    implements NetworkConfigListener {
        private VplsConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            VplsNeighbourHandler.this.configNeighbourHandler();
        }
    }

    private class VplsInterfaceListener
    implements InterfaceListener {
        private VplsInterfaceListener() {
        }

        public void event(InterfaceEvent event) {
            VplsNeighbourHandler.this.configNeighbourHandler();
        }
    }

    private class VplsNeighbourMessageHandler
    implements NeighbourMessageHandler {
        private VplsNeighbourMessageHandler() {
        }

        public void handleMessage(NeighbourMessageContext context, HostService hostService) {
            switch (context.type()) {
                case REQUEST: {
                    VplsNeighbourHandler.this.handleRequest(context);
                    break;
                }
                case REPLY: {
                    VplsNeighbourHandler.this.handleReply(context, hostService);
                    break;
                }
                default: {
                    VplsNeighbourHandler.this.log.warn(VplsNeighbourHandler.UNKNOWN_CONTEXT, (Object)context.type());
                }
            }
        }
    }
}

