/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.config.Config;
import org.onosproject.vpls.config.VplsConfig;

public class VplsAppConfig
extends Config<ApplicationId> {
    private static final String VPLS = "vplsList";
    private static final String NAME = "name";
    private static final String INTERFACE = "interfaces";
    private static final String ENCAPSULATION = "encapsulation";

    public Set<VplsConfig> vplss() {
        HashSet vplss = Sets.newHashSet();
        JsonNode vplsNode = this.object.get(VPLS);
        if (vplsNode == null) {
            return vplss;
        }
        vplsNode.forEach(jsonNode -> {
            String name = jsonNode.get(NAME).asText();
            HashSet ifaces = Sets.newHashSet();
            JsonNode vplsIfaces = jsonNode.path(INTERFACE);
            if (vplsIfaces.toString().isEmpty()) {
                vplsIfaces = ((ObjectNode)jsonNode).putArray(INTERFACE);
            }
            vplsIfaces.forEach(ifacesNode -> ifaces.add(ifacesNode.asText()));
            String encap = null;
            if (jsonNode.hasNonNull(ENCAPSULATION)) {
                encap = jsonNode.get(ENCAPSULATION).asText();
            }
            vplss.add(new VplsConfig(name, ifaces, EncapsulationType.enumFromString((String)encap)));
        });
        return vplss;
    }

    public VplsConfig getVplsWithName(String name) {
        return this.vplss().stream().filter(vpls -> vpls.name().equals(name)).findFirst().orElse(null);
    }

    public void addVpls(VplsConfig vpls) {
        ObjectNode vplsNode = JsonNodeFactory.instance.objectNode();
        vplsNode.put(NAME, vpls.name());
        ArrayNode ifacesNode = vplsNode.putArray(INTERFACE);
        vpls.ifaces().forEach(arg_0 -> ((ArrayNode)ifacesNode).add(arg_0));
        vplsNode.put(ENCAPSULATION, vpls.encap().toString());
        ArrayNode vplsArray = this.vplss().isEmpty() ? this.initVplsConfiguration() : (ArrayNode)this.object.get(VPLS);
        vplsArray.add((JsonNode)vplsNode);
    }

    public void removeVpls(String vplsName) {
        ArrayNode configuredVpls = (ArrayNode)this.object.get(VPLS);
        for (int i = 0; i < configuredVpls.size(); ++i) {
            if (!configuredVpls.get(i).hasNonNull(NAME) || !configuredVpls.get(i).get(NAME).asText().equals(vplsName)) continue;
            configuredVpls.remove(i);
            return;
        }
    }

    public VplsConfig vplsFromIface(String iface) {
        for (VplsConfig vpls : this.vplss()) {
            if (!vpls.isAttached(iface)) continue;
            return vpls;
        }
        return null;
    }

    public void addIface(String vplsName, String iface) {
        JsonNode vplsNodes = this.object.get(VPLS);
        vplsNodes.forEach(vplsNode -> {
            if (this.hasNamedNode((JsonNode)vplsNode, vplsName)) {
                ArrayNode ifacesNode = (ArrayNode)vplsNode.get(INTERFACE);
                for (int i = 0; i < ifacesNode.size(); ++i) {
                    if (!ifacesNode.get(i).asText().equals(iface)) continue;
                    return;
                }
                ifacesNode.add(iface);
            }
        });
    }

    public void removeIface(VplsConfig name, String iface) {
        JsonNode vplsNodes = this.object.get(VPLS);
        vplsNodes.forEach(vplsNode -> {
            if (this.hasNamedNode((JsonNode)vplsNode, name.name())) {
                ArrayNode ifacesNode = (ArrayNode)vplsNode.get(INTERFACE);
                for (int i = 0; i < ifacesNode.size(); ++i) {
                    if (!ifacesNode.get(i).asText().equals(iface)) continue;
                    ifacesNode.remove(i);
                    return;
                }
            }
        });
    }

    public void setEncap(String vplsName, EncapsulationType encap) {
        JsonNode vplsNodes = this.object.get(VPLS);
        vplsNodes.forEach(vplsNode -> {
            if (this.hasNamedNode((JsonNode)vplsNode, vplsName)) {
                ((ObjectNode)vplsNode).put(ENCAPSULATION, encap.toString());
            }
        });
    }

    private boolean hasNamedNode(JsonNode jsonNode, String name) {
        return jsonNode.hasNonNull(NAME) && jsonNode.get(NAME).asText().equals(name);
    }

    private ArrayNode initVplsConfiguration() {
        return this.object.putArray(VPLS);
    }
}

