/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.config.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.vpls.config.VplsAppConfig;
import org.onosproject.vpls.config.VplsConfig;
import org.onosproject.vpls.config.VplsConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class VplsConfigImpl
implements VplsConfigService {
    private static final String VPLS_APP = "org.onosproject.vpls";
    private static final String VPLS = "vpls";
    private static final String EMPTY = "";
    private static final String CONFIG_NULL = "VPLS configuration not defined";
    private static final String APP_ID_NULL = "VPLS application ID is null";
    private static final String CONFIG_CHANGED = "VPLS configuration changed: {}";
    private static final String CHECK_CONFIG = "Checking the interface configuration";
    private static final String NET_CONF_EVENT = "Received NetworkConfigEvent {}";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry registry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService configService;
    private final Set<String> vplsAffectedByApi = new HashSet<String>();
    private VplsAppConfig vplsAppConfig = new VplsAppConfig();
    private SetMultimap<String, String> ifacesOfVpls = HashMultimap.create();
    private SetMultimap<String, String> oldIfacesOfVpls = HashMultimap.create();
    private SetMultimap<String, Interface> vplsIfaces = HashMultimap.create();
    private Map<String, EncapsulationType> vplsEncaps = Maps.newHashMap();
    private final InternalNetworkConfigListener configListener = new InternalNetworkConfigListener();
    private ConfigFactory<ApplicationId, VplsAppConfig> vplsConfigFactory = new ConfigFactory<ApplicationId, VplsAppConfig>(SubjectFactories.APP_SUBJECT_FACTORY, VplsAppConfig.class, "vpls"){

        public VplsAppConfig createConfig() {
            return new VplsAppConfig();
        }
    };
    private ApplicationId vplsAppId;

    @Activate
    protected void active() {
        this.configService.addListener((EventListener)this.configListener);
        this.registry.registerConfigFactory(this.vplsConfigFactory);
        this.loadConfiguration();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactive() {
        this.registry.unregisterConfigFactory(this.vplsConfigFactory);
        this.configService.removeListener((EventListener)this.configListener);
        this.log.info("Stopped");
    }

    @Override
    public void addVpls(String vplsName, Set<String> ifaces, String encap) {
        EncapsulationType encapType = EncapsulationType.enumFromString((String)encap);
        if (this.ifacesOfVpls.containsKey((Object)vplsName)) {
            if (ifaces.isEmpty()) {
                return;
            }
            ifaces.forEach(iface -> this.vplsAppConfig.addIface(vplsName, (String)iface));
            this.vplsAppConfig.setEncap(vplsName, encapType);
        } else {
            this.vplsAppConfig.addVpls(new VplsConfig(vplsName, ifaces, encapType));
        }
        this.vplsAffectedByApi.add(vplsName);
        this.applyConfig(this.vplsAppConfig);
    }

    @Override
    public void removeVpls(String vplsName) {
        if (this.ifacesOfVpls.containsKey((Object)vplsName)) {
            this.vplsAppConfig.removeVpls(vplsName);
            this.vplsAffectedByApi.add(vplsName);
            this.applyConfig(this.vplsAppConfig);
        }
    }

    @Override
    public void addIface(String vplsName, String iface) {
        if (this.ifacesOfVpls.containsKey((Object)vplsName)) {
            this.vplsAppConfig.addIface(vplsName, iface);
            this.vplsAffectedByApi.add(vplsName);
            this.applyConfig(this.vplsAppConfig);
        }
    }

    @Override
    public void setEncap(String vplsName, String encap) {
        EncapsulationType encapType = EncapsulationType.enumFromString((String)encap);
        if (this.ifacesOfVpls.containsKey((Object)vplsName)) {
            this.vplsAppConfig.setEncap(vplsName, encapType);
            this.vplsAffectedByApi.add(vplsName);
            this.applyConfig(this.vplsAppConfig);
        }
    }

    @Override
    public void removeIface(String iface) {
        if (this.ifacesOfVpls.containsValue((Object)iface)) {
            VplsConfig vpls = this.vplsAppConfig.vplsFromIface(iface);
            this.vplsAppConfig.removeIface(vpls, iface);
            this.vplsAffectedByApi.add(vpls.name());
            this.applyConfig(this.vplsAppConfig);
        }
    }

    @Override
    public void cleanVplsConfig() {
        this.ifacesOfVpls.entries().forEach(e -> {
            this.vplsAppConfig.removeVpls((String)e.getKey());
            this.vplsAffectedByApi.add((String)e.getKey());
        });
        this.applyConfig(this.vplsAppConfig);
    }

    @Override
    public EncapsulationType encap(String vplsName) {
        EncapsulationType encap = null;
        if (this.vplsEncaps.containsKey(vplsName)) {
            encap = this.vplsEncaps.get(vplsName);
        }
        return encap;
    }

    @Override
    public Set<String> vplsAffectedByApi() {
        ImmutableSet vplsNames = ImmutableSet.copyOf(this.vplsAffectedByApi);
        this.vplsAffectedByApi.clear();
        return vplsNames;
    }

    @Override
    public Set<Interface> allIfaces() {
        HashSet<Interface> interfaces = new HashSet<Interface>();
        this.interfaceService.getInterfaces().stream().filter(iface -> iface.ipAddressesList() == null || iface.ipAddressesList().isEmpty()).forEach(interfaces::add);
        return interfaces;
    }

    @Override
    public Set<Interface> ifaces() {
        HashSet<Interface> interfaces = new HashSet<Interface>();
        this.vplsIfaces.values().forEach(interfaces::add);
        return interfaces;
    }

    @Override
    public Set<Interface> ifaces(String vplsName) {
        HashSet<Interface> vplsInterfaces = new HashSet<Interface>();
        this.vplsIfaces.get((Object)vplsName).forEach(vplsInterfaces::add);
        return vplsInterfaces;
    }

    @Override
    public Set<String> vplsNames() {
        return this.ifacesOfVpls.keySet();
    }

    @Override
    public Set<String> vplsNamesOld() {
        return this.oldIfacesOfVpls.keySet();
    }

    @Override
    public SetMultimap<String, Interface> ifacesByVplsName() {
        return ImmutableSetMultimap.copyOf(this.vplsIfaces);
    }

    @Override
    public SetMultimap<String, Interface> ifacesByVplsName(VlanId vlan, ConnectPoint connectPoint) {
        String vplsName = this.vplsIfaces.entries().stream().filter(e -> ((Interface)e.getValue()).connectPoint().equals((Object)connectPoint)).filter(e -> ((Interface)e.getValue()).vlan().equals((Object)vlan)).map(Map.Entry::getKey).findFirst().orElse(null);
        HashMultimap result = HashMultimap.create();
        if (vplsName != null && this.vplsIfaces.containsKey((Object)vplsName)) {
            this.vplsIfaces.get((Object)vplsName).forEach(arg_0 -> VplsConfigImpl.lambda$ifacesByVplsName$5((SetMultimap)result, vplsName, arg_0));
            return result;
        }
        return null;
    }

    @Override
    public Map<String, EncapsulationType> encapByVplsName() {
        return ImmutableMap.copyOf(this.vplsEncaps);
    }

    private void loadConfiguration() {
        this.loadAppId();
        this.vplsAppConfig = (VplsAppConfig)this.configService.getConfig((Object)this.vplsAppId, VplsAppConfig.class);
        if (this.vplsAppConfig == null) {
            this.log.warn(CONFIG_NULL);
            this.configService.addConfig((Object)this.vplsAppId, VplsAppConfig.class);
            return;
        }
        this.oldIfacesOfVpls = this.ifacesOfVpls;
        this.ifacesOfVpls = this.getConfigInterfaces();
        this.vplsIfaces = this.getConfigCPointsFromIfaces();
        this.vplsEncaps = this.getConfigEncap();
        this.log.debug(CONFIG_CHANGED, this.ifacesOfVpls);
    }

    private void loadAppId() {
        this.vplsAppId = this.coreService.getAppId(VPLS_APP);
        if (this.vplsAppId == null) {
            this.log.warn(APP_ID_NULL);
        }
    }

    private void applyConfig(VplsAppConfig vplsAppConfig) {
        this.loadAppId();
        this.configService.applyConfig((Object)this.vplsAppId, VplsAppConfig.class, vplsAppConfig.node());
    }

    private Map<String, EncapsulationType> getConfigEncap() {
        HashMap<String, EncapsulationType> configEncap = new HashMap<String, EncapsulationType>();
        this.vplsAppConfig.vplss().forEach(vpls -> configEncap.put(vpls.name(), vpls.encap()));
        return configEncap;
    }

    private SetMultimap<String, String> getConfigInterfaces() {
        HashMultimap confIntfByVpls = HashMultimap.create();
        this.vplsAppConfig.vplss().forEach(arg_0 -> VplsConfigImpl.lambda$getConfigInterfaces$8((SetMultimap)confIntfByVpls, arg_0));
        return confIntfByVpls;
    }

    private SetMultimap<String, Interface> getConfigCPointsFromIfaces() {
        this.log.debug(CHECK_CONFIG);
        HashMultimap confCPointsByIntf = HashMultimap.create();
        this.ifacesOfVpls.entries().forEach(arg_0 -> this.lambda$getConfigCPointsFromIfaces$12((SetMultimap)confCPointsByIntf, arg_0));
        return confCPointsByIntf;
    }

    private /* synthetic */ void lambda$getConfigCPointsFromIfaces$12(SetMultimap confCPointsByIntf, Map.Entry vpls) {
        this.interfaceService.getInterfaces().stream().filter(intf -> intf.ipAddressesList().isEmpty()).filter(intf -> intf.name().equals(vpls.getValue())).forEach(intf -> confCPointsByIntf.put(vpls.getKey(), intf));
    }

    private static /* synthetic */ void lambda$getConfigInterfaces$8(SetMultimap confIntfByVpls, VplsConfig vpls) {
        if (vpls.ifaces().isEmpty()) {
            confIntfByVpls.put((Object)vpls.name(), (Object)EMPTY);
        } else {
            vpls.ifaces().forEach(iface -> confIntfByVpls.put((Object)vpls.name(), iface));
        }
    }

    private static /* synthetic */ void lambda$ifacesByVplsName$5(SetMultimap result, String vplsName, Interface intf) {
        result.put((Object)vplsName, (Object)intf);
    }

    protected void bindRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.registry = networkConfigRegistry;
    }

    protected void unbindRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.registry == networkConfigRegistry) {
            this.registry = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindConfigService(NetworkConfigService networkConfigService) {
        this.configService = networkConfigService;
    }

    protected void unbindConfigService(NetworkConfigService networkConfigService) {
        if (this.configService == networkConfigService) {
            this.configService = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass() == VplsConfigService.CONFIG_CLASS) {
                VplsConfigImpl.this.log.debug(VplsConfigImpl.NET_CONF_EVENT, (Object)event.configClass());
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: 
                    case CONFIG_UPDATED: 
                    case CONFIG_REMOVED: {
                        VplsConfigImpl.this.loadConfiguration();
                        break;
                    }
                }
            }
        }
    }
}

