/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.TestApplicationId;
import org.onosproject.app.ApplicationService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.HostServiceAdapter;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentServiceAdapter;
import org.onosproject.net.intent.IntentUtils;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;
import org.onosproject.net.intent.constraint.EncapsulationConstraint;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.routing.IntentSynchronizationAdminService;
import org.onosproject.routing.IntentSynchronizationService;
import org.onosproject.vpls.Vpls;
import org.onosproject.vpls.VplsConfigServiceAdapter;
import org.onosproject.vpls.config.VplsConfigService;

public class VplsTest {
    private static final String APP_NAME = "org.onosproject.vpls";
    private static final ApplicationId APPID = TestApplicationId.create((String)"org.onosproject.vpls");
    private static final String DASH = "-";
    private static final int PRIORITY_OFFSET = 1000;
    private static final String VPLS1 = "vpls1";
    private static final String VPLS2 = "vpls2";
    private static final String VPLS3 = "vpls3";
    private static final String VPLS4 = "vpls4";
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);
    private static final DeviceId DID1 = VplsTest.getDeviceId(1);
    private static final DeviceId DID2 = VplsTest.getDeviceId(2);
    private static final DeviceId DID3 = VplsTest.getDeviceId(3);
    private static final DeviceId DID4 = VplsTest.getDeviceId(4);
    private static final DeviceId DID5 = VplsTest.getDeviceId(5);
    private static final DeviceId DID6 = VplsTest.getDeviceId(6);
    private static final ConnectPoint CP1 = new ConnectPoint((ElementId)DID1, P1);
    private static final ConnectPoint CP2 = new ConnectPoint((ElementId)DID2, P1);
    private static final ConnectPoint CP3 = new ConnectPoint((ElementId)DID3, P1);
    private static final ConnectPoint CP4 = new ConnectPoint((ElementId)DID4, P1);
    private static final ConnectPoint CP5 = new ConnectPoint((ElementId)DID5, P1);
    private static final ConnectPoint CP6 = new ConnectPoint((ElementId)DID6, P1);
    private static final ConnectPoint CP7 = new ConnectPoint((ElementId)DID4, P2);
    private static final ConnectPoint CP8 = new ConnectPoint((ElementId)DID3, P2);
    private static final ConnectPoint CP9 = new ConnectPoint((ElementId)DID5, P1);
    private static final ConnectPoint CP10 = new ConnectPoint((ElementId)DID5, P2);
    private static final VlanId VLAN100 = VlanId.vlanId((short)100);
    private static final VlanId VLAN200 = VlanId.vlanId((short)200);
    private static final VlanId VLAN300 = VlanId.vlanId((short)300);
    private static final VlanId VLAN400 = VlanId.vlanId((short)400);
    private static final VlanId VLAN_NONE = VlanId.NONE;
    private static final MacAddress MAC1 = VplsTest.getMac(1);
    private static final MacAddress MAC2 = VplsTest.getMac(2);
    private static final MacAddress MAC3 = VplsTest.getMac(3);
    private static final MacAddress MAC4 = VplsTest.getMac(4);
    private static final MacAddress MAC5 = VplsTest.getMac(5);
    private static final MacAddress MAC6 = VplsTest.getMac(6);
    private static final MacAddress MAC7 = VplsTest.getMac(7);
    private static final MacAddress MAC8 = VplsTest.getMac(8);
    private static final MacAddress MAC9 = VplsTest.getMac(9);
    private static final MacAddress MAC10 = VplsTest.getMac(10);
    private static final MacAddress MAC11 = VplsTest.getMac(11);
    private static final Ip4Address IP1 = Ip4Address.valueOf((String)"192.168.1.1");
    private static final Ip4Address IP2 = Ip4Address.valueOf((String)"192.168.1.2");
    private static final HostId HID1 = HostId.hostId((MacAddress)MAC1, (VlanId)VLAN100);
    private static final HostId HID2 = HostId.hostId((MacAddress)MAC2, (VlanId)VLAN100);
    private static final HostId HID3 = HostId.hostId((MacAddress)MAC3, (VlanId)VLAN200);
    private static final HostId HID4 = HostId.hostId((MacAddress)MAC4, (VlanId)VLAN200);
    private static final HostId HID5 = HostId.hostId((MacAddress)MAC5, (VlanId)VLAN300);
    private static final HostId HID6 = HostId.hostId((MacAddress)MAC6, (VlanId)VLAN300);
    private static final HostId HID7 = HostId.hostId((MacAddress)MAC7, (VlanId)VLAN300);
    private static final HostId HID8 = HostId.hostId((MacAddress)MAC8, (VlanId)VLAN400);
    private static final HostId HID9 = HostId.hostId((MacAddress)MAC9);
    private static final HostId HID10 = HostId.hostId((MacAddress)MAC10);
    private static final HostId HID11 = HostId.hostId((MacAddress)MAC11);
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static IdGenerator idGenerator;
    private static final Interface V100H1;
    private static final Interface V100H2;
    private static final Interface V200H1;
    private static final Interface V200H2;
    private static final Interface V300H1;
    private static final Interface V300H2;
    private static final Interface V400H1;
    private static final Interface VNONEH1;
    private static final Interface VNONEH2;
    private static final Interface VNONEH3;
    private static final Host V100HOST1;
    private static final Host V100HOST2;
    private static final Host V200HOST1;
    private static final Host V200HOST2;
    private static final Host V300HOST1;
    private static final Host V300HOST2;
    private static final Host V300HOST3;
    private static final Host V400HOST1;
    private static final Host VNONEHOST1;
    private static final Host VNONEHOST2;
    private static final Host VNONEHOST3;
    private static final Set<Interface> AVAILABLE_INTERFACES;
    private static final Set<Host> AVAILABLE_HOSTS;
    private SetMultimap<String, Interface> interfacesByVpls = HashMultimap.create();
    private ApplicationService applicationService;
    private CoreService coreService;
    private HostListener hostListener;
    private NetworkConfigService configService;
    private Set<Host> hostsAvailable;
    private HostService hostService;
    private IntentService intentService;
    private InterfaceService interfaceService;
    private VplsConfigService vplsConfigService;
    private Vpls vpls;

    @Before
    public void setUp() throws Exception {
        idGenerator = new TestIdGenerator();
        Intent.bindIdGenerator((IdGenerator)idGenerator);
        this.applicationService = (ApplicationService)EasyMock.createMock(ApplicationService.class);
        this.configService = (NetworkConfigService)EasyMock.createMock(NetworkConfigService.class);
        this.coreService = (CoreService)EasyMock.createMock(CoreService.class);
        EasyMock.expect((Object)this.coreService.registerApplication(APP_NAME)).andReturn((Object)APPID);
        EasyMock.replay((Object[])new Object[]{this.coreService});
        this.hostsAvailable = Sets.newHashSet();
        this.hostService = new TestHostService(this.hostsAvailable);
        this.intentService = new TestIntentService();
        TestIntentSynchronizer intentSynchronizer = new TestIntentSynchronizer(this.intentService);
        this.interfaceService = (InterfaceService)EasyMock.createMock(InterfaceService.class);
        this.interfaceService.addListener((EventListener)EasyMock.anyObject(InterfaceListener.class));
        EasyMock.expectLastCall().anyTimes();
        this.addIfaceConfig();
        this.interfacesByVpls.put((Object)VPLS1, (Object)V100H1);
        this.interfacesByVpls.put((Object)VPLS1, (Object)V200H1);
        this.interfacesByVpls.put((Object)VPLS1, (Object)V300H1);
        this.interfacesByVpls.put((Object)VPLS2, (Object)V100H2);
        this.interfacesByVpls.put((Object)VPLS2, (Object)V200H2);
        this.interfacesByVpls.put((Object)VPLS2, (Object)V300H2);
        this.interfacesByVpls.put((Object)VPLS3, (Object)VNONEH1);
        this.interfacesByVpls.put((Object)VPLS3, (Object)VNONEH2);
        this.interfacesByVpls.put((Object)VPLS4, (Object)V400H1);
        this.interfacesByVpls.put((Object)VPLS4, (Object)VNONEH3);
        HashMap<String, EncapsulationType> encapByVpls = new HashMap<String, EncapsulationType>();
        encapByVpls.put(VPLS1, EncapsulationType.VLAN);
        encapByVpls.put(VPLS2, EncapsulationType.NONE);
        encapByVpls.put(VPLS3, EncapsulationType.NONE);
        encapByVpls.put(VPLS4, EncapsulationType.NONE);
        this.vplsConfigService = new TestVplsConfigService(this.interfacesByVpls, encapByVpls);
        this.vpls = new Vpls();
        this.vpls.applicationService = this.applicationService;
        this.vpls.coreService = this.coreService;
        this.vpls.hostService = this.hostService;
        this.vpls.vplsConfigService = this.vplsConfigService;
        this.vpls.intentService = this.intentService;
        this.vpls.interfaceService = this.interfaceService;
        this.vpls.configService = this.configService;
        this.vpls.intentSynchronizer = intentSynchronizer;
    }

    @After
    public void tearDown() {
        Intent.unbindIdGenerator((IdGenerator)idGenerator);
    }

    private void addIfaceConfig() {
        ImmutableSet interfaces = ImmutableSet.copyOf(AVAILABLE_INTERFACES);
        ImmutableSet vlanOneSet = ImmutableSet.of((Object)V100H1, (Object)V100H2);
        ImmutableSet vlanTwoSet = ImmutableSet.of((Object)V200H1, (Object)V200H2);
        ImmutableSet vlanThreeSet = ImmutableSet.of((Object)VNONEH1, (Object)VNONEH2);
        ImmutableSet vlanFourSet = ImmutableSet.of((Object)V400H1, (Object)VNONEH3);
        AVAILABLE_INTERFACES.forEach(intf -> EasyMock.expect((Object)this.interfaceService.getInterfacesByPort(intf.connectPoint())).andReturn((Object)Sets.newHashSet((Object[])new Interface[]{intf})).anyTimes());
        EasyMock.expect((Object)this.interfaceService.getInterfacesByVlan(VLAN100)).andReturn((Object)vlanOneSet).anyTimes();
        EasyMock.expect((Object)this.interfaceService.getInterfacesByVlan(VLAN200)).andReturn((Object)vlanTwoSet).anyTimes();
        EasyMock.expect((Object)this.interfaceService.getInterfacesByVlan(VLAN300)).andReturn((Object)vlanThreeSet).anyTimes();
        EasyMock.expect((Object)this.interfaceService.getInterfacesByVlan(VLAN400)).andReturn((Object)vlanFourSet).anyTimes();
        EasyMock.expect((Object)this.interfaceService.getInterfacesByVlan(VlanId.NONE)).andReturn((Object)vlanFourSet).anyTimes();
        EasyMock.expect((Object)this.interfaceService.getInterfaces()).andReturn((Object)interfaces).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.interfaceService});
    }

    @Test
    public void activateNoHosts() {
        this.vpls.activate();
        ArrayList expectedIntents = Lists.newArrayList();
        Set<FilteredConnectPoint> fcPoints = this.buildFCPoints((Collection<Interface>)ImmutableSet.of((Object)V100H1, (Object)V200H1, (Object)V300H1));
        expectedIntents.addAll(this.generateVplsBrc(fcPoints, VPLS1, EncapsulationType.VLAN));
        fcPoints = this.buildFCPoints((Collection<Interface>)ImmutableSet.of((Object)V100H2, (Object)V200H2, (Object)V300H2));
        expectedIntents.addAll(this.generateVplsBrc(fcPoints, VPLS2, EncapsulationType.NONE));
        fcPoints = this.buildFCPoints((Collection<Interface>)ImmutableSet.of((Object)VNONEH1, (Object)VNONEH2));
        expectedIntents.addAll(this.generateVplsBrc(fcPoints, VPLS3, EncapsulationType.NONE));
        fcPoints = this.buildFCPoints((Collection<Interface>)ImmutableSet.of((Object)V400H1, (Object)VNONEH3));
        expectedIntents.addAll(this.generateVplsBrc(fcPoints, VPLS4, EncapsulationType.NONE));
        this.checkIntents(expectedIntents);
    }

    @Test
    public void tenInterfacesConfiguredHostsPresent() {
        this.hostsAvailable.addAll(AVAILABLE_HOSTS);
        this.vpls.activate();
        ArrayList expectedIntents = Lists.newArrayList();
        Set<FilteredConnectPoint> fcPoints = this.buildFCPoints((Collection<Interface>)ImmutableSet.of((Object)V100H1, (Object)V200H1, (Object)V300H1));
        ImmutableSet hosts = ImmutableSet.of((Object)V100HOST1, (Object)V200HOST1, (Object)V300HOST1);
        expectedIntents.addAll(this.generateVplsBrc(fcPoints, VPLS1, EncapsulationType.VLAN));
        expectedIntents.addAll(this.generateVplsUni(fcPoints, (Set<Host>)hosts, VPLS1, EncapsulationType.VLAN));
        fcPoints = this.buildFCPoints((Collection<Interface>)ImmutableSet.of((Object)V100H2, (Object)V200H2, (Object)V300H2));
        hosts = ImmutableSet.of((Object)V100HOST2, (Object)V200HOST2, (Object)V300HOST2);
        expectedIntents.addAll(this.generateVplsBrc(fcPoints, VPLS2, EncapsulationType.NONE));
        expectedIntents.addAll(this.generateVplsUni(fcPoints, (Set<Host>)hosts, VPLS2, EncapsulationType.NONE));
        fcPoints = this.buildFCPoints((Collection<Interface>)ImmutableSet.of((Object)VNONEH1, (Object)VNONEH2));
        hosts = ImmutableSet.of((Object)VNONEHOST1, (Object)VNONEHOST2);
        expectedIntents.addAll(this.generateVplsBrc(fcPoints, VPLS3, EncapsulationType.NONE));
        expectedIntents.addAll(this.generateVplsUni(fcPoints, (Set<Host>)hosts, VPLS3, EncapsulationType.NONE));
        fcPoints = this.buildFCPoints((Collection<Interface>)ImmutableSet.of((Object)V400H1, (Object)VNONEH3));
        hosts = ImmutableSet.of((Object)V400HOST1, (Object)VNONEHOST3);
        expectedIntents.addAll(this.generateVplsBrc(fcPoints, VPLS4, EncapsulationType.NONE));
        expectedIntents.addAll(this.generateVplsUni(fcPoints, (Set<Host>)hosts, VPLS4, EncapsulationType.NONE));
        this.checkIntents(expectedIntents);
    }

    @Test
    public void tenInterfacesThreeHostEventsSameVpls() {
        this.vpls.activate();
        ArrayList expectedIntents = Lists.newArrayList();
        this.hostsAvailable.addAll(Sets.newHashSet((Object[])new Host[]{V100HOST1, V200HOST1, V300HOST1, V300HOST3, VNONEHOST1, VNONEHOST2, V400HOST1, VNONEHOST3}));
        this.hostsAvailable.forEach(host -> this.hostListener.event((Event)new HostEvent(HostEvent.Type.HOST_ADDED, host)));
        Set<FilteredConnectPoint> fcPoints = this.buildFCPoints((Collection<Interface>)ImmutableSet.of((Object)V100H1, (Object)V200H1, (Object)V300H1));
        ImmutableSet hosts = ImmutableSet.of((Object)V100HOST1, (Object)V200HOST1, (Object)V300HOST1);
        expectedIntents.addAll(this.generateVplsBrc(fcPoints, VPLS1, EncapsulationType.VLAN));
        expectedIntents.addAll(this.generateVplsUni(fcPoints, (Set<Host>)hosts, VPLS1, EncapsulationType.VLAN));
        fcPoints = this.buildFCPoints((Collection<Interface>)ImmutableSet.of((Object)V100H2, (Object)V200H2, (Object)V300H2));
        expectedIntents.addAll(this.generateVplsBrc(fcPoints, VPLS2, EncapsulationType.NONE));
        fcPoints = this.buildFCPoints((Collection<Interface>)ImmutableSet.of((Object)VNONEH1, (Object)VNONEH2));
        hosts = ImmutableSet.of((Object)VNONEHOST1, (Object)VNONEHOST2);
        expectedIntents.addAll(this.generateVplsBrc(fcPoints, VPLS3, EncapsulationType.NONE));
        expectedIntents.addAll(this.generateVplsUni(fcPoints, (Set<Host>)hosts, VPLS3, EncapsulationType.NONE));
        fcPoints = this.buildFCPoints((Collection<Interface>)ImmutableSet.of((Object)V400H1, (Object)VNONEH3));
        hosts = ImmutableSet.of((Object)V400HOST1, (Object)VNONEHOST3);
        expectedIntents.addAll(this.generateVplsBrc(fcPoints, VPLS4, EncapsulationType.NONE));
        expectedIntents.addAll(this.generateVplsUni(fcPoints, (Set<Host>)hosts, VPLS4, EncapsulationType.NONE));
        this.checkIntents(expectedIntents);
    }

    private List<SinglePointToMultiPointIntent> generateVplsBrc(Set<FilteredConnectPoint> fcPoints, String name, EncapsulationType encap) {
        ArrayList intents = Lists.newArrayList();
        fcPoints.forEach(point -> {
            Set<FilteredConnectPoint> otherPoints = fcPoints.stream().filter(fcp -> !fcp.equals(point)).collect(Collectors.toSet());
            Key brckey = this.buildKey("brc", point.connectPoint(), name, MacAddress.BROADCAST);
            intents.add(this.buildBrcIntent(brckey, (FilteredConnectPoint)point, otherPoints, encap));
        });
        return intents;
    }

    private List<MultiPointToSinglePointIntent> generateVplsUni(Set<FilteredConnectPoint> fcPoints, Set<Host> hosts, String name, EncapsulationType encap) {
        ArrayList intents = Lists.newArrayList();
        hosts.forEach(host -> {
            FilteredConnectPoint hostPoint = this.getHostPoint((Host)host, fcPoints);
            Set<FilteredConnectPoint> otherPoints = fcPoints.stream().filter(fcp -> !fcp.equals((Object)hostPoint)).collect(Collectors.toSet());
            Key uniKey = this.buildKey("uni", (ConnectPoint)host.location(), name, host.mac());
            intents.add(this.buildUniIntent(uniKey, otherPoints, hostPoint, (Host)host, encap));
        });
        return intents;
    }

    private void checkIntents(List<Intent> intents) {
        Assert.assertEquals((String)"The number of intents submitted differs from the number of intents expected. ", (long)intents.size(), (long)this.intentService.getIntentCount());
        for (Intent intentOne : intents) {
            boolean found = false;
            for (Intent intentTwo : this.intentService.getIntents()) {
                if (!intentOne.key().equals((Object)intentTwo.key())) continue;
                found = true;
                Assert.assertTrue((String)String.format("The intent submitted is different from the intent expected. %s %s", intentOne, intentTwo), (boolean)IntentUtils.intentsAreEqual((Intent)intentOne, (Intent)intentTwo));
                break;
            }
            Assert.assertTrue((String)"The intent submitted is not equal to any of the expected intents. ", (boolean)found);
        }
    }

    private SinglePointToMultiPointIntent buildBrcIntent(Key key, FilteredConnectPoint src, Set<FilteredConnectPoint> dsts, EncapsulationType encap) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthDst(MacAddress.BROADCAST).build();
        SinglePointToMultiPointIntent.Builder intentBuilder = SinglePointToMultiPointIntent.builder().appId(APPID).key(key).selector(selector).filteredIngressPoint(src).filteredEgressPoints(dsts).priority(1000);
        VplsTest.encap((ConnectivityIntent.Builder)intentBuilder, encap);
        return intentBuilder.build();
    }

    private MultiPointToSinglePointIntent buildUniIntent(Key key, Set<FilteredConnectPoint> srcs, FilteredConnectPoint dst, Host host, EncapsulationType encap) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthDst(host.mac()).build();
        MultiPointToSinglePointIntent.Builder intentBuilder = MultiPointToSinglePointIntent.builder().appId(APPID).key(key).selector(selector).filteredIngressPoints(srcs).filteredEgressPoint(dst).priority(1000);
        VplsTest.encap((ConnectivityIntent.Builder)intentBuilder, encap);
        return intentBuilder.build();
    }

    private FilteredConnectPoint getHostPoint(Host host, Set<FilteredConnectPoint> fcps) {
        return fcps.stream().filter(fcp -> fcp.connectPoint().equals((Object)host.location())).filter(fcp -> {
            VlanIdCriterion vlanCriterion = (VlanIdCriterion)fcp.trafficSelector().getCriterion(Criterion.Type.VLAN_VID);
            return vlanCriterion == null || vlanCriterion.vlanId().equals((Object)host.vlan());
        }).findFirst().orElse(null);
    }

    private Set<FilteredConnectPoint> buildFCPoints(Collection<Interface> interfaces) {
        return interfaces.stream().map(intf -> {
            TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
            if (!intf.vlan().equals((Object)VlanId.NONE)) {
                selectorBuilder.matchVlanId(intf.vlan());
            }
            return new FilteredConnectPoint(intf.connectPoint(), selectorBuilder.build());
        }).collect(Collectors.toSet());
    }

    private Key buildKey(String prefix, ConnectPoint cPoint, String vplsName, MacAddress hostMac) {
        String keyString = vplsName + DASH + prefix + DASH + cPoint.deviceId() + DASH + cPoint.port() + DASH + hostMac;
        return Key.of((String)keyString, (ApplicationId)APPID);
    }

    private static void encap(ConnectivityIntent.Builder builder, EncapsulationType encap) {
        if (!encap.equals((Object)EncapsulationType.NONE)) {
            builder.constraints((List)ImmutableList.of((Object)new EncapsulationConstraint(encap)));
        }
    }

    private static DeviceId getDeviceId(int i) {
        return DeviceId.deviceId((String)("" + i));
    }

    private static MacAddress getMac(int n) {
        return MacAddress.valueOf((String)String.format("00:00:00:00:00:%s", n));
    }

    private static HostLocation getLocation(int i) {
        return new HostLocation(new ConnectPoint((ElementId)VplsTest.getDeviceId(i), P1), 123L);
    }

    private static HostLocation getLocation(int d, int p) {
        return new HostLocation(new ConnectPoint((ElementId)VplsTest.getDeviceId(d), PortNumber.portNumber((long)p)), 123L);
    }

    static {
        V100H1 = new Interface("v100h1", CP1, null, null, VLAN100);
        V100H2 = new Interface("v100h2", CP2, null, null, VLAN100);
        V200H1 = new Interface("v200h1", CP3, null, null, VLAN200);
        V200H2 = new Interface("v200h2", CP4, null, null, VLAN200);
        V300H1 = new Interface("v300h1", CP5, null, null, VLAN300);
        V300H2 = new Interface("v300h2", CP6, null, null, VLAN300);
        V400H1 = new Interface("v400h1", CP7, null, null, VLAN400);
        VNONEH1 = new Interface("vNoneh1", CP8, null, null, VLAN_NONE);
        VNONEH2 = new Interface("vNoneh2", CP9, null, null, VLAN_NONE);
        VNONEH3 = new Interface("vNoneh3", CP10, null, null, VLAN_NONE);
        V100HOST1 = new DefaultHost(PID, HID1, MAC1, VLAN100, VplsTest.getLocation(1), Collections.singleton(IP1), new Annotations[0]);
        V100HOST2 = new DefaultHost(PID, HID2, MAC2, VLAN100, VplsTest.getLocation(2), (Set)Sets.newHashSet(), new Annotations[0]);
        V200HOST1 = new DefaultHost(PID, HID3, MAC3, VLAN200, VplsTest.getLocation(3), Collections.singleton(IP2), new Annotations[0]);
        V200HOST2 = new DefaultHost(PID, HID4, MAC4, VLAN200, VplsTest.getLocation(4), (Set)Sets.newHashSet(), new Annotations[0]);
        V300HOST1 = new DefaultHost(PID, HID5, MAC5, VLAN300, VplsTest.getLocation(5), (Set)Sets.newHashSet(), new Annotations[0]);
        V300HOST2 = new DefaultHost(PID, HID6, MAC6, VLAN300, VplsTest.getLocation(6), (Set)Sets.newHashSet(), new Annotations[0]);
        V300HOST3 = new DefaultHost(PID, HID7, MAC7, VLAN300, VplsTest.getLocation(7), (Set)Sets.newHashSet(), new Annotations[0]);
        V400HOST1 = new DefaultHost(PID, HID8, MAC8, VLAN400, VplsTest.getLocation(4, 2), (Set)Sets.newHashSet(), new Annotations[0]);
        VNONEHOST1 = new DefaultHost(PID, HID9, MAC9, VlanId.NONE, VplsTest.getLocation(3, 2), (Set)Sets.newHashSet(), new Annotations[0]);
        VNONEHOST2 = new DefaultHost(PID, HID10, MAC10, VlanId.NONE, VplsTest.getLocation(5, 1), (Set)Sets.newHashSet(), new Annotations[0]);
        VNONEHOST3 = new DefaultHost(PID, HID11, MAC11, VlanId.NONE, VplsTest.getLocation(5, 2), (Set)Sets.newHashSet(), new Annotations[0]);
        AVAILABLE_INTERFACES = ImmutableSet.of((Object)V100H1, (Object)V100H2, (Object)V200H1, (Object)V200H2, (Object)V300H1, (Object)V300H2, (Object[])new Interface[]{V400H1, VNONEH1, VNONEH2});
        AVAILABLE_HOSTS = ImmutableSet.of((Object)V100HOST1, (Object)V100HOST2, (Object)V200HOST1, (Object)V200HOST2, (Object)V300HOST1, (Object)V300HOST2, (Object[])new Host[]{V300HOST3, VNONEHOST1, VNONEHOST2, V400HOST1, VNONEHOST3});
    }

    private class TestVplsConfigService
    extends VplsConfigServiceAdapter {
        private final SetMultimap<String, Interface> ifacesByVplsName;
        private final Map<String, EncapsulationType> encapsByVplsName;
        private Set<String> vplsAffectByApi = new HashSet<String>();

        TestVplsConfigService(SetMultimap<String, Interface> ifacesByVplsName, Map<String, EncapsulationType> encapsByVplsName) {
            this.ifacesByVplsName = ifacesByVplsName;
            this.encapsByVplsName = encapsByVplsName;
        }

        @Override
        public void addVpls(String vplsName, Set<String> ifaceNames, String encap) {
            if (!this.ifacesByVplsName.containsKey((Object)vplsName)) {
                ifaceNames.forEach(ifaceName -> AVAILABLE_INTERFACES.forEach(iface -> {
                    if (iface.name().equals(ifaceName)) {
                        this.ifacesByVplsName.put((Object)vplsName, iface);
                    }
                }));
            }
            if (!this.ifacesByVplsName.containsKey((Object)vplsName)) {
                this.encapsByVplsName.put(vplsName, EncapsulationType.valueOf((String)encap));
            }
        }

        @Override
        public void removeVpls(String vplsName) {
            if (this.ifacesByVplsName.containsKey((Object)vplsName)) {
                this.ifacesByVplsName.removeAll((Object)vplsName);
            }
        }

        @Override
        public void addIface(String vplsName, String iface) {
            if (!this.ifacesByVplsName.containsKey((Object)vplsName)) {
                AVAILABLE_INTERFACES.forEach(intf -> {
                    if (intf.name().equals(iface)) {
                        this.ifacesByVplsName.put((Object)vplsName, intf);
                    }
                });
            }
        }

        @Override
        public void setEncap(String vplsName, String encap) {
            this.encapsByVplsName.put(vplsName, EncapsulationType.enumFromString((String)encap));
        }

        @Override
        public void removeIface(String iface) {
            HashMultimap search = HashMultimap.create(this.ifacesByVplsName);
            search.entries().forEach(e -> {
                if (((Interface)e.getValue()).name().equals(iface)) {
                    this.ifacesByVplsName.remove(e.getKey(), (Object)iface);
                }
            });
        }

        @Override
        public void cleanVplsConfig() {
            this.ifacesByVplsName.clear();
        }

        @Override
        public EncapsulationType encap(String vplsName) {
            EncapsulationType encap = null;
            if (this.encapsByVplsName.containsKey(vplsName)) {
                encap = this.encapsByVplsName.get(vplsName);
            }
            return encap;
        }

        @Override
        public Set<String> vplsAffectedByApi() {
            ImmutableSet vplsNames = ImmutableSet.copyOf(this.vplsAffectByApi);
            this.vplsAffectByApi.clear();
            return vplsNames;
        }

        @Override
        public Set<Interface> allIfaces() {
            return this.ifacesByVplsName.values().stream().collect(Collectors.toSet());
        }

        @Override
        public Set<Interface> ifaces(String name) {
            return this.ifacesByVplsName.get((Object)name).stream().collect(Collectors.toSet());
        }

        @Override
        public Set<String> vplsNames() {
            return this.ifacesByVplsName.keySet();
        }

        @Override
        public Set<String> vplsNamesOld() {
            return this.ifacesByVplsName.keySet();
        }

        @Override
        public SetMultimap<String, Interface> ifacesByVplsName() {
            return ImmutableSetMultimap.copyOf(this.ifacesByVplsName);
        }

        @Override
        public SetMultimap<String, Interface> ifacesByVplsName(VlanId vlan, ConnectPoint connectPoint) {
            String vplsName = this.ifacesByVplsName.entries().stream().filter(e -> ((Interface)e.getValue()).connectPoint().equals((Object)connectPoint)).filter(e -> ((Interface)e.getValue()).vlan().equals((Object)vlan)).map(Map.Entry::getKey).findFirst().orElse(null);
            HashMultimap result = HashMultimap.create();
            if (vplsName != null && this.ifacesByVplsName.containsKey((Object)vplsName)) {
                this.ifacesByVplsName.get((Object)vplsName).forEach(arg_0 -> TestVplsConfigService.lambda$ifacesByVplsName$6((SetMultimap)result, vplsName, arg_0));
                return result;
            }
            return null;
        }

        private static /* synthetic */ void lambda$ifacesByVplsName$6(SetMultimap result, String vplsName, Interface intf) {
            result.put((Object)vplsName, (Object)intf);
        }
    }

    private class TestIntentSynchronizer
    implements IntentSynchronizationService,
    IntentSynchronizationAdminService {
        private final IntentService intentService;

        public TestIntentSynchronizer(IntentService intentService) {
            this.intentService = intentService;
        }

        public void submit(Intent intent) {
            this.intentService.submit(intent);
        }

        public void withdraw(Intent intent) {
            this.intentService.withdraw(intent);
        }

        public void modifyPrimary(boolean isPrimary) {
        }

        public void removeIntents() {
        }

        public void removeIntentsByAppId(ApplicationId applicationId) {
        }
    }

    private static class TestIdGenerator
    implements IdGenerator {
        private final AtomicLong id = new AtomicLong(0L);

        private TestIdGenerator() {
        }

        public long getNewId() {
            return this.id.getAndIncrement();
        }
    }

    private class TestHostService
    extends HostServiceAdapter {
        private Set<Host> hosts;

        public TestHostService(Set<Host> hosts) {
            this.hosts = hosts;
        }

        public void addListener(HostListener listener) {
            VplsTest.this.hostListener = listener;
        }

        public Set<Host> getConnectedHosts(ConnectPoint connectPoint) {
            return this.hosts.stream().filter(h -> h.location().equals((Object)connectPoint)).collect(Collectors.toSet());
        }
    }

    private class TestIntentService
    extends IntentServiceAdapter {
        private Map<Key, Intent> intents = Maps.newHashMap();

        public void submit(Intent intent) {
            this.intents.put(intent.key(), intent);
        }

        public long getIntentCount() {
            return this.intents.size();
        }

        public Iterable<Intent> getIntents() {
            return this.intents.values();
        }

        public Intent getIntent(Key intentKey) {
            for (Intent intent : this.intents.values()) {
                if (!intent.key().equals((Object)intentKey)) continue;
                return intent;
            }
            return null;
        }
    }
}

