/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.incubator.net.neighbour.NeighbourHandlerRegistration;
import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.incubator.net.neighbour.NeighbourMessageHandler;
import org.onosproject.incubator.net.neighbour.NeighbourMessageType;
import org.onosproject.incubator.net.neighbour.NeighbourProtocol;
import org.onosproject.incubator.net.neighbour.NeighbourResolutionService;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.PortNumber;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.HostServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.vpls.VplsConfigServiceAdapter;
import org.onosproject.vpls.VplsNeighbourHandler;

public class VplsNeighbourHandlerTest {
    private static final String IFACES_NOT_EXPECTED = "The interfaces reached by the packet are not equal to the interfaces expected.";
    private static final DeviceId DID1 = VplsNeighbourHandlerTest.getDeviceId(1);
    private static final DeviceId DID2 = VplsNeighbourHandlerTest.getDeviceId(2);
    private static final DeviceId DID3 = VplsNeighbourHandlerTest.getDeviceId(3);
    private static final DeviceId DID4 = VplsNeighbourHandlerTest.getDeviceId(4);
    private static final DeviceId DID5 = VplsNeighbourHandlerTest.getDeviceId(5);
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);
    private static final PortNumber P3 = PortNumber.portNumber((long)3L);
    private static final ConnectPoint OF1P1 = new ConnectPoint((ElementId)DID1, P1);
    private static final ConnectPoint OF2P1 = new ConnectPoint((ElementId)DID2, P1);
    private static final ConnectPoint OF3P1 = new ConnectPoint((ElementId)DID3, P1);
    private static final ConnectPoint OF4P1 = new ConnectPoint((ElementId)DID4, P1);
    private static final ConnectPoint OF4P2 = new ConnectPoint((ElementId)DID4, P2);
    private static final ConnectPoint OF4P3 = new ConnectPoint((ElementId)DID4, P3);
    private static final ConnectPoint OF5P1 = new ConnectPoint((ElementId)DID5, P1);
    private static final ConnectPoint OF5P2 = new ConnectPoint((ElementId)DID5, P2);
    private static final ConnectPoint OF5P3 = new ConnectPoint((ElementId)DID5, P3);
    private static final String VPLS1 = "vpls1";
    private static final String VPLS2 = "vpls2";
    private static final String VPLS3 = "vpls3";
    private static final String VPLS4 = "vpls4";
    private static final VlanId VLAN100 = VlanId.vlanId((String)"100");
    private static final VlanId VLAN200 = VlanId.vlanId((String)"200");
    private static final VlanId VLAN300 = VlanId.vlanId((String)"300");
    private static final VlanId VLAN400 = VlanId.vlanId((String)"400");
    private static final VlanId VLAN_NONE = VlanId.NONE;
    private static final Interface V100H1 = new Interface("v100h1", OF1P1, null, null, VLAN100);
    private static final Interface V100H2 = new Interface("v100h2", OF4P1, null, null, VLAN100);
    private static final Interface V200H1 = new Interface("v200h1", OF4P2, null, null, VLAN200);
    private static final Interface V200H2 = new Interface("v200h2", OF2P1, null, null, VLAN200);
    private static final Interface V300H1 = new Interface("v300h1", OF3P1, null, null, VLAN300);
    private static final Interface V400H1 = new Interface("v400h1", OF5P1, null, null, VLAN400);
    private static final Interface VNONEH1 = new Interface("vNoneh1", OF5P2, null, null, VLAN_NONE);
    private static final Interface VNONEH2 = new Interface("vNoneh2", OF5P3, null, null, VLAN_NONE);
    private static final Interface VNONEH3 = new Interface("vNoneh3", OF4P3, null, null, VLAN_NONE);
    private static final MacAddress MAC1 = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private static final MacAddress MAC2 = MacAddress.valueOf((String)"00:00:00:00:00:02");
    private static final MacAddress MAC3 = MacAddress.valueOf((String)"00:00:00:00:00:03");
    private static final MacAddress MAC4 = MacAddress.valueOf((String)"00:00:00:00:00:04");
    private static final MacAddress MAC5 = MacAddress.valueOf((String)"00:00:00:00:00:05");
    private static final MacAddress MAC6 = MacAddress.valueOf((String)"00:00:00:00:00:06");
    private static final MacAddress MAC7 = MacAddress.valueOf((String)"00:00:00:00:00:07");
    private static final MacAddress MAC8 = MacAddress.valueOf((String)"00:00:00:00:00:08");
    private static final MacAddress MAC9 = MacAddress.valueOf((String)"00:00:00:00:00:09");
    private static final ProviderId PID = new ProviderId("of", "foo");
    private final Host v100Host1 = this.makeHost(MAC1, VLAN100, OF1P1);
    private final Host v100Host2 = this.makeHost(MAC2, VLAN100, OF4P1);
    private final Host v200Host1 = this.makeHost(MAC3, VLAN200, OF4P2);
    private final Host v200Host2 = this.makeHost(MAC5, VLAN200, OF2P1);
    private final Host v300Host1 = this.makeHost(MAC4, VLAN300, OF3P1);
    private final Host v400Host1 = this.makeHost(MAC6, VLAN400, OF5P1);
    private final Host vNoneHost1 = this.makeHost(MAC7, VLAN_NONE, OF5P2);
    private final Host vNoneHost2 = this.makeHost(MAC8, VLAN_NONE, OF5P3);
    private final Host vNoneHost3 = this.makeHost(MAC9, VLAN_NONE, OF4P3);
    private final Set<Host> availableHosts = ImmutableSet.of((Object)this.v100Host1, (Object)this.v100Host2, (Object)this.v200Host1, (Object)this.v300Host1, (Object)this.v200Host2, (Object)this.v400Host1, (Object[])new Host[]{this.vNoneHost1, this.vNoneHost2, this.vNoneHost3});
    private final Set<Interface> availableInterfaces = ImmutableSet.of((Object)V100H1, (Object)V100H2, (Object)V200H1, (Object)V200H2, (Object)V300H1, (Object)V400H1, (Object[])new Interface[]{VNONEH1, VNONEH2, VNONEH3});
    private VplsNeighbourHandler vplsNeighbourHandler;
    private HostService hostService;

    @Before
    public void setUp() {
        this.vplsNeighbourHandler = new VplsNeighbourHandler();
        HashMultimap ifacesByVpls = HashMultimap.create();
        ifacesByVpls.put((Object)VPLS1, (Object)V100H1);
        ifacesByVpls.put((Object)VPLS1, (Object)V200H1);
        ifacesByVpls.put((Object)VPLS1, (Object)V300H1);
        ifacesByVpls.put((Object)VPLS2, (Object)V100H2);
        ifacesByVpls.put((Object)VPLS2, (Object)V200H2);
        ifacesByVpls.put((Object)VPLS3, (Object)VNONEH1);
        ifacesByVpls.put((Object)VPLS3, (Object)VNONEH2);
        ifacesByVpls.put((Object)VPLS4, (Object)V400H1);
        ifacesByVpls.put((Object)VPLS4, (Object)VNONEH3);
        HashMap encap = Maps.newHashMap();
        this.vplsNeighbourHandler.vplsConfigService = new TestVplsConfigService((SetMultimap<String, Interface>)ifacesByVpls, encap);
        this.vplsNeighbourHandler.interfaceService = new TestInterfaceService();
        this.vplsNeighbourHandler.neighbourService = new TestNeighbourService();
        this.hostService = new TestHostService();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void vpls1RequestMessage() {
        TestMessageContext requestMessage = this.makeBroadcastRequestContext(this.v100Host1);
        ImmutableSet expectInterfaces = ImmutableSet.of((Object)V200H1, (Object)V300H1);
        this.vplsNeighbourHandler.handleRequest((NeighbourMessageContext)requestMessage);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, requestMessage.forwardResults);
        requestMessage = this.makeBroadcastRequestContext(this.v200Host1);
        expectInterfaces = ImmutableSet.of((Object)V100H1, (Object)V300H1);
        this.vplsNeighbourHandler.handleRequest((NeighbourMessageContext)requestMessage);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, requestMessage.forwardResults);
        requestMessage = this.makeBroadcastRequestContext(this.v300Host1);
        expectInterfaces = ImmutableSet.of((Object)V100H1, (Object)V200H1);
        this.vplsNeighbourHandler.handleRequest((NeighbourMessageContext)requestMessage);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, requestMessage.forwardResults);
    }

    @Test
    public void vpls2RequestMessage() {
        TestMessageContext requestMessage = this.makeBroadcastRequestContext(this.v100Host2);
        ImmutableSet expectInterfaces = ImmutableSet.of((Object)V200H2);
        this.vplsNeighbourHandler.handleRequest((NeighbourMessageContext)requestMessage);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, requestMessage.forwardResults);
        requestMessage = this.makeBroadcastRequestContext(this.v200Host2);
        expectInterfaces = ImmutableSet.of((Object)V100H2);
        this.vplsNeighbourHandler.handleRequest((NeighbourMessageContext)requestMessage);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, requestMessage.forwardResults);
    }

    @Test
    public void vpls3RequestMessage() {
        TestMessageContext requestMessage = this.makeBroadcastRequestContext(this.vNoneHost1);
        ImmutableSet expectInterfaces = ImmutableSet.of((Object)VNONEH2);
        this.vplsNeighbourHandler.handleRequest((NeighbourMessageContext)requestMessage);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, requestMessage.forwardResults);
        requestMessage = this.makeBroadcastRequestContext(this.vNoneHost2);
        expectInterfaces = ImmutableSet.of((Object)VNONEH1);
        this.vplsNeighbourHandler.handleRequest((NeighbourMessageContext)requestMessage);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, requestMessage.forwardResults);
    }

    @Test
    public void vpls4RequestMessage() {
        TestMessageContext requestMessage = this.makeBroadcastRequestContext(this.v400Host1);
        ImmutableSet expectInterfaces = ImmutableSet.of((Object)VNONEH3);
        this.vplsNeighbourHandler.handleRequest((NeighbourMessageContext)requestMessage);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, requestMessage.forwardResults);
        requestMessage = this.makeBroadcastRequestContext(this.vNoneHost3);
        expectInterfaces = ImmutableSet.of((Object)V400H1);
        this.vplsNeighbourHandler.handleRequest((NeighbourMessageContext)requestMessage);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, requestMessage.forwardResults);
    }

    @Test
    public void vpls1ReplyMessage() {
        TestMessageContext replyMessage = this.makeReplyContext(this.v100Host1, this.v200Host1);
        ImmutableSet expectInterfaces = ImmutableSet.of((Object)V200H1);
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
        replyMessage = this.makeReplyContext(this.v200Host1, this.v300Host1);
        expectInterfaces = ImmutableSet.of((Object)V300H1);
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
        replyMessage = this.makeReplyContext(this.v300Host1, this.v100Host1);
        expectInterfaces = ImmutableSet.of((Object)V100H1);
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
    }

    @Test
    public void vpls2ReplyMessage() {
        TestMessageContext replyMessage = this.makeReplyContext(this.v100Host2, this.v200Host2);
        ImmutableSet expectInterfaces = ImmutableSet.of((Object)V200H2);
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
        replyMessage = this.makeReplyContext(this.v200Host2, this.v100Host2);
        expectInterfaces = ImmutableSet.of((Object)V100H2);
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
    }

    @Test
    public void vpls3ReplyMessage() {
        TestMessageContext replyMessage = this.makeReplyContext(this.vNoneHost1, this.vNoneHost2);
        ImmutableSet expectInterfaces = ImmutableSet.of((Object)VNONEH2);
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
        replyMessage = this.makeReplyContext(this.vNoneHost2, this.vNoneHost1);
        expectInterfaces = ImmutableSet.of((Object)VNONEH1);
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
    }

    @Test
    public void vpls4ReplyMessage() {
        TestMessageContext replyMessage = this.makeReplyContext(this.v400Host1, this.vNoneHost3);
        ImmutableSet expectInterfaces = ImmutableSet.of((Object)VNONEH3);
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
        replyMessage = this.makeReplyContext(this.vNoneHost3, this.v400Host1);
        expectInterfaces = ImmutableSet.of((Object)V400H1);
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
    }

    @Test
    public void wrongReplyMessage() {
        TestMessageContext replyMessage = this.makeReplyContext(this.v100Host1, this.v100Host2);
        ImmutableSet expectInterfaces = ImmutableSet.of();
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
        replyMessage = this.makeReplyContext(this.v200Host2, this.v300Host1);
        expectInterfaces = ImmutableSet.of();
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
        replyMessage = this.makeReplyContext(this.vNoneHost1, this.v400Host1);
        expectInterfaces = ImmutableSet.of();
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
        replyMessage = this.makeReplyContext(this.vNoneHost3, this.vNoneHost2);
        expectInterfaces = ImmutableSet.of();
        this.vplsNeighbourHandler.handleReply((NeighbourMessageContext)replyMessage, this.hostService);
        TestCase.assertEquals((String)IFACES_NOT_EXPECTED, (Object)expectInterfaces, replyMessage.forwardResults);
    }

    private static DeviceId getDeviceId(int i) {
        return DeviceId.deviceId((String)("" + i));
    }

    private Host makeHost(MacAddress mac, VlanId vlan, ConnectPoint cp) {
        return new DefaultHost(PID, HostId.hostId((MacAddress)mac, (VlanId)vlan), mac, vlan, new HostLocation(cp, 0L), (Set)Sets.newHashSet(), new Annotations[0]);
    }

    private TestMessageContext makeBroadcastRequestContext(Host host) {
        return new TestMessageContext((ConnectPoint)host.location(), host.mac(), MacAddress.BROADCAST, host.vlan(), NeighbourMessageType.REQUEST);
    }

    private TestMessageContext makeReplyContext(Host src, Host dst) {
        return new TestMessageContext((ConnectPoint)src.location(), src.mac(), dst.mac(), src.vlan(), NeighbourMessageType.REPLY);
    }

    class TestInterfaceService
    implements InterfaceService {
        TestInterfaceService() {
        }

        public void addListener(InterfaceListener listener) {
        }

        public void removeListener(InterfaceListener listener) {
        }

        public Set<Interface> getInterfaces() {
            return VplsNeighbourHandlerTest.this.availableInterfaces;
        }

        public Interface getInterfaceByName(ConnectPoint connectPoint, String name) {
            return VplsNeighbourHandlerTest.this.availableInterfaces.stream().filter(intf -> intf.name().equals(name)).findFirst().orElse(null);
        }

        public Set<Interface> getInterfacesByPort(ConnectPoint port) {
            return VplsNeighbourHandlerTest.this.availableInterfaces.stream().filter(intf -> intf.connectPoint().equals((Object)port)).collect(Collectors.toSet());
        }

        public Set<Interface> getInterfacesByIp(IpAddress ip) {
            return VplsNeighbourHandlerTest.this.availableInterfaces.stream().filter(intf -> intf.ipAddressesList().contains(ip)).collect(Collectors.toSet());
        }

        public Set<Interface> getInterfacesByVlan(VlanId vlan) {
            return VplsNeighbourHandlerTest.this.availableInterfaces.stream().filter(intf -> intf.vlan().equals((Object)vlan)).collect(Collectors.toSet());
        }

        public Interface getMatchingInterface(IpAddress ip) {
            return VplsNeighbourHandlerTest.this.availableInterfaces.stream().filter(intf -> intf.ipAddressesList().contains(ip)).findFirst().orElse(null);
        }
    }

    private class TestNeighbourService
    implements NeighbourResolutionService {
        private SetMultimap<ConnectPoint, NeighbourHandlerRegistration> handlerRegs = HashMultimap.create();

        public void registerNeighbourHandler(ConnectPoint connectPoint, NeighbourMessageHandler handler, ApplicationId appId) {
            Interface intf = new Interface(null, connectPoint, null, null, null);
            HandlerRegistration reg = new HandlerRegistration(handler, intf, appId);
            this.handlerRegs.put((Object)connectPoint, (Object)reg);
        }

        public void registerNeighbourHandler(Interface intf, NeighbourMessageHandler handler, ApplicationId appId) {
            HandlerRegistration reg = new HandlerRegistration(handler, intf, appId);
            this.handlerRegs.put((Object)intf.connectPoint(), (Object)reg);
        }

        public void unregisterNeighbourHandler(ConnectPoint connectPoint, NeighbourMessageHandler handler, ApplicationId appId) {
            this.handlerRegs.removeAll((Object)connectPoint);
        }

        public void unregisterNeighbourHandler(Interface intf, NeighbourMessageHandler handler, ApplicationId appId) {
            this.handlerRegs.removeAll((Object)intf.connectPoint());
        }

        public void unregisterNeighbourHandlers(ApplicationId appId) {
            this.handlerRegs.clear();
        }

        public Map<ConnectPoint, Collection<NeighbourHandlerRegistration>> getHandlerRegistrations() {
            return this.handlerRegs.asMap();
        }

        private class HandlerRegistration
        implements NeighbourHandlerRegistration {
            private final Interface intf;
            private final NeighbourMessageHandler handler;
            private final ApplicationId appId;

            public HandlerRegistration(NeighbourMessageHandler handler, Interface intf, ApplicationId appId) {
                this.intf = intf;
                this.handler = handler;
                this.appId = appId;
            }

            public Interface intf() {
                return this.intf;
            }

            public NeighbourMessageHandler handler() {
                return this.handler;
            }

            public ApplicationId appId() {
                return this.appId;
            }
        }
    }

    class TestHostService
    extends HostServiceAdapter {
        TestHostService() {
        }

        public Set<Host> getHostsByMac(MacAddress mac) {
            return VplsNeighbourHandlerTest.this.availableHosts.stream().filter(host -> host.mac().equals((Object)mac)).collect(Collectors.toSet());
        }

        public Iterable<Host> getHosts() {
            return VplsNeighbourHandlerTest.this.availableHosts;
        }

        public Set<Host> getHostsByVlan(VlanId vlanId) {
            return VplsNeighbourHandlerTest.this.availableHosts.stream().filter(host -> host.vlan().equals((Object)vlanId)).collect(Collectors.toSet());
        }

        public int getHostCount() {
            return VplsNeighbourHandlerTest.this.availableHosts.size();
        }

        public Host getHost(HostId hostId) {
            return VplsNeighbourHandlerTest.this.availableHosts.stream().filter(host -> host.id().equals((Object)hostId)).findFirst().orElse(null);
        }
    }

    private class TestVplsConfigService
    extends VplsConfigServiceAdapter {
        private final SetMultimap<String, Interface> ifacesByVplsName;

        public TestVplsConfigService(SetMultimap<String, Interface> ifacesByVplsName, HashMap<String, EncapsulationType> encapByVplsName) {
            this.ifacesByVplsName = ifacesByVplsName;
        }

        @Override
        public void addVpls(String vplsName, Set<String> ifaceNames, String encap) {
            if (!this.ifacesByVplsName.containsKey((Object)vplsName)) {
                ifaceNames.forEach(ifaceName -> VplsNeighbourHandlerTest.this.availableInterfaces.forEach(iface -> {
                    if (iface.name().equals(ifaceName)) {
                        this.ifacesByVplsName.put((Object)vplsName, iface);
                    }
                }));
            }
        }

        @Override
        public void removeVpls(String vplsName) {
            if (this.ifacesByVplsName.containsKey((Object)vplsName)) {
                this.ifacesByVplsName.removeAll((Object)vplsName);
            }
        }

        @Override
        public void addIface(String vplsName, String ifaceName) {
            VplsNeighbourHandlerTest.this.availableInterfaces.forEach(intf -> {
                if (intf.name().equals(ifaceName)) {
                    this.ifacesByVplsName.put((Object)vplsName, intf);
                }
            });
        }

        @Override
        public void removeIface(String ifaceName) {
            HashMultimap toBeRemoved = HashMultimap.create();
            this.ifacesByVplsName.entries().forEach(arg_0 -> TestVplsConfigService.lambda$removeIface$3(ifaceName, (SetMultimap)toBeRemoved, arg_0));
            toBeRemoved.entries().forEach(e -> this.ifacesByVplsName.remove(e.getKey(), e.getValue()));
        }

        @Override
        public void cleanVplsConfig() {
            this.ifacesByVplsName.clear();
        }

        @Override
        public Set<Interface> allIfaces() {
            return ImmutableSet.copyOf((Collection)this.ifacesByVplsName.values());
        }

        @Override
        public Set<Interface> ifaces(String name) {
            return this.ifacesByVplsName.get((Object)name).stream().collect(Collectors.toSet());
        }

        @Override
        public Set<String> vplsNames() {
            return this.ifacesByVplsName.keySet();
        }

        @Override
        public SetMultimap<String, Interface> ifacesByVplsName() {
            return ImmutableSetMultimap.copyOf(this.ifacesByVplsName);
        }

        @Override
        public SetMultimap<String, Interface> ifacesByVplsName(VlanId vlan, ConnectPoint connectPoint) {
            String vplsName = this.ifacesByVplsName.entries().stream().filter(e -> ((Interface)e.getValue()).connectPoint().equals((Object)connectPoint)).filter(e -> ((Interface)e.getValue()).vlan().equals((Object)vlan)).map(Map.Entry::getKey).findFirst().orElse(null);
            HashMultimap result = HashMultimap.create();
            if (vplsName != null && this.ifacesByVplsName.containsKey((Object)vplsName)) {
                this.ifacesByVplsName.get((Object)vplsName).forEach(arg_0 -> TestVplsConfigService.lambda$ifacesByVplsName$7((SetMultimap)result, vplsName, arg_0));
                return result;
            }
            return null;
        }

        private static /* synthetic */ void lambda$ifacesByVplsName$7(SetMultimap result, String vplsName, Interface intf) {
            result.put((Object)vplsName, (Object)intf);
        }

        private static /* synthetic */ void lambda$removeIface$3(String ifaceName, SetMultimap toBeRemoved, Map.Entry e) {
            if (((Interface)e.getValue()).name().equals(ifaceName)) {
                toBeRemoved.put(e.getKey(), e.getValue());
            }
        }
    }

    private class TestMessageContext
    implements NeighbourMessageContext {
        private final NeighbourMessageType type;
        private final MacAddress srcMac;
        private final MacAddress dstMac;
        private final ConnectPoint inPort;
        private final VlanId vlanId;
        public Set<Interface> forwardResults;

        public TestMessageContext(ConnectPoint inPort, MacAddress srcMac, MacAddress dstMac, VlanId vlanId, NeighbourMessageType type) {
            this.inPort = inPort;
            this.srcMac = srcMac;
            this.dstMac = dstMac;
            this.vlanId = vlanId;
            this.type = type;
            this.forwardResults = Sets.newHashSet();
        }

        public ConnectPoint inPort() {
            return this.inPort;
        }

        public NeighbourMessageType type() {
            return this.type;
        }

        public VlanId vlan() {
            return this.vlanId;
        }

        public MacAddress srcMac() {
            return this.srcMac;
        }

        public MacAddress dstMac() {
            return this.dstMac;
        }

        public IpAddress target() {
            return null;
        }

        public IpAddress sender() {
            return null;
        }

        public void forward(ConnectPoint outPort) {
        }

        public void forward(Interface outIntf) {
            this.forwardResults.add(outIntf);
        }

        public void reply(MacAddress targetMac) {
        }

        public void flood() {
        }

        public void drop() {
        }

        public Ethernet packet() {
            return null;
        }

        public NeighbourProtocol protocol() {
            return null;
        }
    }
}

