/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.cli;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.EncapsulationType;
import org.onosproject.vpls.cli.VplsCommandEnum;
import org.onosproject.vpls.config.VplsConfigService;

@Command(scope="onos", name="vpls", description="Manages the VPLS application")
public class VplsCommand
extends AbstractShellCommand {
    private static final String BOLD = "\u001b[1m";
    private static final String COLOR_ERROR = "\u001b[31m";
    private static final String RESET = "\u001b[0m";
    private static final String ENCAP_NOT_FOUND = "\u001b[31mEncapsulation type \u001b[1m%s\u001b[0m\u001b[31m not found\u001b[0m";
    private static final String IFACE_NOT_FOUND = "\u001b[31mInterface \u001b[1m%s\u001b[0m\u001b[31m not found\u001b[0m";
    private static final String IFACE_ALREADY_ASSOCIATED = "\u001b[31mInterface \u001b[1m%s\u001b[0m\u001b[31m already associated to VPLS \u001b[1m%s\u001b[0m\u001b[31m\u001b[0m";
    private static final String SEPARATOR = "----------------";
    private static final String VPLS_ALREADY_EXISTS = "\u001b[31mVPLS \u001b[1m%s\u001b[0m\u001b[31m already exists\u001b[0m";
    private static final String VPLS_COMMAND_NOT_FOUND = "\u001b[31mVPLS command \u001b[1m%s\u001b[0m\u001b[31m not found\u001b[0m";
    private static final String VPLS_DISPLAY = "VPLS name: \u001b[1m%s\u001b[0m\nAssociated interfaces: %s\nEncapsulation: %s";
    private static final String VPLS_LIST_TITLE = "\u001b[1mConfigured VPLSs\u001b[0m";
    private static final String VPLS_NOT_FOUND = "\u001b[31mVPLS \u001b[1m%s\u001b[0m\u001b[31m not found\u001b[0m";
    private static final String IFACE_NOT_ASSOCIATED = "\u001b[31mInterface \u001b[1m%s\u001b[0m\u001b[31m cannot be removed from VPLS \u001b[1m%s\u001b[0m\u001b[31m. The interface is associated to anotherVPLS (\u001b[1m%s\u001b[0m\u001b[31m)\u001b[0m";
    private static VplsConfigService vplsConfigService = (VplsConfigService)VplsCommand.get(VplsConfigService.class);
    private static InterfaceService interfaceService = (InterfaceService)VplsCommand.get(InterfaceService.class);
    @Argument(index=0, name="command", description="Command name (add|clean|create|delete|list|removeIface|set-encap|show)", required=true, multiValued=false)
    String command = null;
    @Argument(index=1, name="vplsName", description="The name of the VPLS", required=false, multiValued=false)
    String vplsName = null;
    @Argument(index=2, name="optArg", description="The interface name forall commands; the encapsulation type for set-encap", required=false, multiValued=false)
    String optArg = null;

    protected void execute() {
        VplsCommandEnum enumCommand = VplsCommandEnum.enumFromString(this.command);
        if (enumCommand != null) {
            switch (enumCommand) {
                case ADD_IFACE: {
                    this.addIface(this.vplsName, this.optArg);
                    break;
                }
                case CLEAN: {
                    this.clean();
                    break;
                }
                case CREATE: {
                    this.create(this.vplsName);
                    break;
                }
                case DELETE: {
                    this.delete(this.vplsName);
                    break;
                }
                case LIST: {
                    this.list();
                    break;
                }
                case REMOVE_IFACE: {
                    this.removeIface(this.vplsName, this.optArg);
                    break;
                }
                case SET_ENCAP: {
                    this.setEncap(this.vplsName, this.optArg);
                    break;
                }
                case SHOW: {
                    this.show(this.vplsName);
                    break;
                }
                default: {
                    this.print(VPLS_COMMAND_NOT_FOUND, new Object[]{this.command});
                }
            }
        }
    }

    private void addIface(String vplsName, String ifaceName) {
        if (!VplsCommand.vplsExists(vplsName)) {
            this.print(VPLS_NOT_FOUND, new Object[]{vplsName});
            return;
        }
        if (!VplsCommand.ifaceExists(ifaceName)) {
            this.print(IFACE_NOT_FOUND, new Object[]{ifaceName});
            return;
        }
        if (VplsCommand.isIfaceAssociated(ifaceName)) {
            this.print(IFACE_ALREADY_ASSOCIATED, new Object[]{ifaceName, VplsCommand.vplsNameFromIfaceName(ifaceName)});
            return;
        }
        vplsConfigService.addIface(vplsName, ifaceName);
    }

    private void clean() {
        vplsConfigService.cleanVplsConfig();
    }

    private void create(String vplsName) {
        if (VplsCommand.vplsExists(vplsName)) {
            this.print(VPLS_ALREADY_EXISTS, new Object[]{vplsName});
            return;
        }
        vplsConfigService.addVpls(vplsName, Sets.newHashSet(), null);
    }

    private void delete(String vplsName) {
        if (!VplsCommand.vplsExists(vplsName)) {
            this.print(VPLS_NOT_FOUND, new Object[]{vplsName});
            return;
        }
        vplsConfigService.removeVpls(vplsName);
    }

    private void list() {
        ArrayList vplsNames = Lists.newArrayList(vplsConfigService.vplsNames());
        Collections.sort(vplsNames);
        this.print(VPLS_LIST_TITLE, new Object[0]);
        this.print(SEPARATOR, new Object[0]);
        vplsNames.forEach(vpls -> this.print((String)vpls, new Object[0]));
    }

    private void removeIface(String vplsName, String ifaceName) {
        if (!VplsCommand.vplsExists(vplsName)) {
            this.print(VPLS_NOT_FOUND, new Object[]{vplsName});
            return;
        }
        if (!VplsCommand.ifaceExists(ifaceName)) {
            this.print(IFACE_NOT_FOUND, new Object[]{ifaceName});
            return;
        }
        String vplsNameFromIfaceName = VplsCommand.vplsNameFromIfaceName(ifaceName);
        if (!vplsNameFromIfaceName.equals(vplsName)) {
            this.print(IFACE_NOT_ASSOCIATED, new Object[]{ifaceName, vplsName, vplsNameFromIfaceName});
            return;
        }
        vplsConfigService.removeIface(ifaceName);
    }

    private void setEncap(String vplsName, String encap) {
        if (!VplsCommand.vplsExists(vplsName)) {
            this.print(VPLS_NOT_FOUND, new Object[]{vplsName});
            return;
        }
        EncapsulationType encapType = EncapsulationType.enumFromString((String)encap);
        if (encapType.equals((Object)EncapsulationType.NONE) && !encapType.toString().equals(encap)) {
            this.print(ENCAP_NOT_FOUND, new Object[]{encap});
            return;
        }
        vplsConfigService.setEncap(vplsName, encap);
    }

    private void show(String vplsName) {
        ArrayList vplsNames = Lists.newArrayList(vplsConfigService.vplsNames());
        Collections.sort(vplsNames);
        Map<String, EncapsulationType> encapByVplsName = vplsConfigService.encapByVplsName();
        this.print(VPLS_LIST_TITLE, new Object[0]);
        this.print(SEPARATOR, new Object[0]);
        if (!Strings.isNullOrEmpty((String)vplsName)) {
            if (VplsCommand.vplsExists(vplsName)) {
                this.print(VPLS_DISPLAY, new Object[]{vplsName, VplsCommand.ifacesFromVplsName(vplsName).toString(), encapByVplsName.get(vplsName).toString()});
            } else {
                this.print(VPLS_NOT_FOUND, new Object[]{vplsName});
            }
        } else {
            vplsNames.forEach(v -> {
                this.print(VPLS_DISPLAY, new Object[]{v, VplsCommand.ifacesFromVplsName(v).toString(), ((EncapsulationType)encapByVplsName.get(v)).toString()});
                this.print(SEPARATOR, new Object[0]);
            });
        }
    }

    private static boolean vplsExists(String vplsName) {
        return vplsConfigService.vplsNames().contains(vplsName);
    }

    private static boolean ifaceExists(String ifaceName) {
        return vplsConfigService.allIfaces().stream().anyMatch(iface -> iface.name().equals(ifaceName));
    }

    private static boolean isIfaceAssociated(String ifaceName) {
        return vplsConfigService.ifaces().stream().anyMatch(iface -> iface.name().equals(ifaceName));
    }

    private static String vplsNameFromIfaceName(String ifaceName) {
        String vplsName = null;
        Optional<String> optVplsName = vplsConfigService.ifacesByVplsName().entries().stream().filter(entry -> ((Interface)entry.getValue()).name().equals(ifaceName)).map(Map.Entry::getKey).findFirst();
        if (optVplsName.isPresent()) {
            vplsName = optVplsName.get();
        }
        return vplsName;
    }

    private static Set<String> ifacesFromVplsName(String vplsName) {
        if (!VplsCommand.vplsExists(vplsName)) {
            return null;
        }
        SetMultimap<String, Interface> ifacesByVplsName = vplsConfigService.ifacesByVplsName();
        HashSet ifaceNames = Sets.newHashSet();
        ifacesByVplsName.get((Object)vplsName).forEach(iface -> ifaceNames.add(iface.name()));
        return ifaceNames;
    }
}

