/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.app.ApplicationService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.routing.IntentSynchronizationService;
import org.onosproject.vpls.IntentInstaller;
import org.onosproject.vpls.config.VplsConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class Vpls {
    static final String VPLS_APP = "org.onosproject.vpls";
    private static final String HOST_FCP_NOT_FOUND = "Filtered connected point for host {} not found";
    private static final String HOST_EVENT = "Received HostEvent {}";
    private static final String INTF_CONF_EVENT = "Received InterfaceConfigEvent {}";
    private static final String NET_CONF_EVENT = "Received NetworkConfigEvent {}";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationService applicationService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentSynchronizationService intentSynchronizer;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VplsConfigService vplsConfigService;
    private final HostListener hostListener = new InternalHostListener();
    private final InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private final InternalNetworkConfigListener configListener = new InternalNetworkConfigListener();
    private IntentInstaller intentInstaller;
    private ApplicationId appId;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(VPLS_APP);
        this.intentInstaller = new IntentInstaller(this.appId, this.intentService, this.intentSynchronizer);
        this.applicationService.registerDeactivateHook(this.appId, () -> this.intentSynchronizer.removeIntentsByAppId(this.appId));
        this.hostService.addListener((EventListener)this.hostListener);
        this.interfaceService.addListener((EventListener)this.interfaceListener);
        this.configService.addListener((EventListener)this.configListener);
        this.setupConnectivity(false);
        this.log.info("Activated");
    }

    @Deactivate
    public void deactivate() {
        this.configService.removeListener((EventListener)this.configListener);
        this.intentSynchronizer.removeIntentsByAppId(this.appId);
        this.log.info("Deactivated");
    }

    private void setupConnectivity(boolean isNetworkConfigEvent) {
        SetMultimap<String, Interface> networkInterfaces = this.vplsConfigService.ifacesByVplsName();
        HashSet<String> vplsAffectedByApi = new HashSet<String>(this.vplsConfigService.vplsAffectedByApi());
        if (isNetworkConfigEvent && vplsAffectedByApi.isEmpty()) {
            vplsAffectedByApi.addAll(this.vplsConfigService.vplsNamesOld());
        }
        networkInterfaces.asMap().forEach((vplsName, interfaces) -> {
            HashSet hosts = Sets.newHashSet();
            interfaces.forEach(intf -> this.hostService.getConnectedHosts(intf.connectPoint()).stream().filter(host -> host.vlan().equals((Object)intf.vlan())).forEach(hosts::add));
            EncapsulationType encap = this.vplsConfigService.encap((String)vplsName);
            this.setupConnectivity((String)vplsName, (Collection<Interface>)interfaces, hosts, encap, vplsAffectedByApi.contains(vplsName));
            vplsAffectedByApi.remove(vplsName);
        });
        if (!vplsAffectedByApi.isEmpty()) {
            for (String vplsName2 : vplsAffectedByApi) {
                this.withdrawIntents(vplsName2, Lists.newArrayList());
            }
        }
    }

    private void setupConnectivity(String vplsName, Collection<Interface> interfaces, Set<Host> hosts, EncapsulationType encap, boolean affectedByApi) {
        ArrayList intents = Lists.newArrayList();
        ArrayList keys = Lists.newArrayList();
        Set<FilteredConnectPoint> fcPoints = this.buildFCPoints(interfaces);
        intents.addAll(this.buildBroadcastIntents(vplsName, fcPoints, encap, affectedByApi));
        intents.addAll(this.buildUnicastIntents(vplsName, hosts, fcPoints, encap, affectedByApi));
        if (affectedByApi) {
            intents.forEach(intent -> keys.add(intent.key()));
            this.withdrawIntents(vplsName, keys);
        }
        this.intentInstaller.submitIntents(intents);
    }

    private void withdrawIntents(String vplsName, List<Key> keys) {
        ArrayList intents = Lists.newArrayList();
        this.intentInstaller.getIntentsFromVpls(vplsName).forEach(intent -> {
            if (!keys.contains(intent.key())) {
                intents.add(intent);
            }
        });
        this.intentInstaller.withdrawIntents(intents);
    }

    private Set<Intent> buildBroadcastIntents(String vplsName, Set<FilteredConnectPoint> fcPoints, EncapsulationType encap, boolean affectedByApi) {
        HashSet intents = Sets.newHashSet();
        fcPoints.forEach(point -> {
            Set<FilteredConnectPoint> otherPoints = fcPoints.stream().filter(fcp -> !fcp.equals(point)).collect(Collectors.toSet());
            Key brcKey = this.intentInstaller.buildKey("brc", point.connectPoint(), vplsName, MacAddress.BROADCAST);
            if (!(this.intentInstaller.intentExists(brcKey) && !affectedByApi || otherPoints.isEmpty())) {
                intents.add(this.intentInstaller.buildBrcIntent(brcKey, (FilteredConnectPoint)point, otherPoints, encap));
            }
        });
        return ImmutableSet.copyOf((Collection)intents);
    }

    private Set<Intent> buildUnicastIntents(String vplsName, Set<Host> hosts, Set<FilteredConnectPoint> fcPoints, EncapsulationType encap, boolean affectedByApi) {
        HashSet intents = Sets.newHashSet();
        hosts.forEach(host -> {
            FilteredConnectPoint hostPoint = this.getHostPoint((Host)host, fcPoints);
            if (hostPoint == null) {
                this.log.warn(HOST_FCP_NOT_FOUND, host);
                return;
            }
            Set<FilteredConnectPoint> otherPoints = fcPoints.stream().filter(fcp -> !fcp.equals((Object)hostPoint)).collect(Collectors.toSet());
            Key uniKey = this.intentInstaller.buildKey("uni", (ConnectPoint)host.location(), vplsName, host.mac());
            if (!(this.intentInstaller.intentExists(uniKey) && !affectedByApi || otherPoints.isEmpty())) {
                intents.add(this.intentInstaller.buildUniIntent(uniKey, otherPoints, hostPoint, (Host)host, encap));
            }
        });
        return ImmutableSet.copyOf((Collection)intents);
    }

    private FilteredConnectPoint getHostPoint(Host host, Set<FilteredConnectPoint> fcps) {
        return fcps.stream().filter(fcp -> fcp.connectPoint().equals((Object)host.location())).filter(fcp -> {
            VlanIdCriterion vlanCriterion = (VlanIdCriterion)fcp.trafficSelector().getCriterion(Criterion.Type.VLAN_VID);
            return vlanCriterion == null || vlanCriterion.vlanId().equals((Object)host.vlan());
        }).findFirst().orElse(null);
    }

    private Set<FilteredConnectPoint> buildFCPoints(Collection<Interface> interfaces) {
        return interfaces.stream().map(intf -> {
            TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
            if (!intf.vlan().equals((Object)VlanId.NONE)) {
                selectorBuilder.matchVlanId(intf.vlan());
            }
            return new FilteredConnectPoint(intf.connectPoint(), selectorBuilder.build());
        }).collect(Collectors.toSet());
    }

    protected void bindApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    protected void unbindApplicationService(ApplicationService applicationService) {
        if (this.applicationService == applicationService) {
            this.applicationService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindIntentSynchronizer(IntentSynchronizationService intentSynchronizationService) {
        this.intentSynchronizer = intentSynchronizationService;
    }

    protected void unbindIntentSynchronizer(IntentSynchronizationService intentSynchronizationService) {
        if (this.intentSynchronizer == intentSynchronizationService) {
            this.intentSynchronizer = null;
        }
    }

    protected void bindConfigService(NetworkConfigService networkConfigService) {
        this.configService = networkConfigService;
    }

    protected void unbindConfigService(NetworkConfigService networkConfigService) {
        if (this.configService == networkConfigService) {
            this.configService = null;
        }
    }

    protected void bindVplsConfigService(VplsConfigService vplsConfigService) {
        this.vplsConfigService = vplsConfigService;
    }

    protected void unbindVplsConfigService(VplsConfigService vplsConfigService) {
        if (this.vplsConfigService == vplsConfigService) {
            this.vplsConfigService = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass() == VplsConfigService.CONFIG_CLASS) {
                Vpls.this.log.debug(Vpls.NET_CONF_EVENT, (Object)event.configClass());
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: 
                    case CONFIG_UPDATED: 
                    case CONFIG_REMOVED: {
                        Vpls.this.setupConnectivity(true);
                        break;
                    }
                }
            }
        }
    }

    private class InternalInterfaceListener
    implements InterfaceListener {
        private InternalInterfaceListener() {
        }

        public void event(InterfaceEvent event) {
            Vpls.this.log.debug(Vpls.INTF_CONF_EVENT, (Object)event);
            switch ((InterfaceEvent.Type)event.type()) {
                case INTERFACE_ADDED: 
                case INTERFACE_UPDATED: 
                case INTERFACE_REMOVED: {
                    Vpls.this.setupConnectivity(false);
                    break;
                }
            }
        }
    }

    private class InternalHostListener
    implements HostListener {
        private InternalHostListener() {
        }

        public void event(HostEvent event) {
            Vpls.this.log.debug(Vpls.HOST_EVENT, (Object)event);
            switch ((HostEvent.Type)event.type()) {
                case HOST_ADDED: 
                case HOST_UPDATED: 
                case HOST_REMOVED: {
                    Vpls.this.setupConnectivity(false);
                    break;
                }
            }
        }
    }
}

