/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;
import org.onosproject.net.intent.constraint.EncapsulationConstraint;
import org.onosproject.routing.IntentSynchronizationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntentInstaller {
    private static final String SUBMIT = "Submitting intents to the Intent Synchronizer";
    private static final String WITHDRAW = "Withdrawing intents to the Intent Synchronizer";
    private static final String SP2MP = "Building sp2mp intent from {}";
    private static final String MP2SP = "Building mp2sp intent to {}";
    private static final Logger log = LoggerFactory.getLogger(IntentInstaller.class);
    private static final int PRIORITY_OFFSET = 1000;
    private static final Set<IntentState> WITHDRAWN_INTENT_STATES = ImmutableSet.of((Object)IntentState.WITHDRAWN, (Object)IntentState.WITHDRAW_REQ, (Object)IntentState.WITHDRAWING);
    static final String PREFIX_BROADCAST = "brc";
    static final String PREFIX_UNICAST = "uni";
    static final String SEPARATOR = "-";
    private final ApplicationId appId;
    private final IntentSynchronizationService intentSynchronizer;
    private final IntentService intentService;

    public IntentInstaller(ApplicationId appId, IntentService intentService, IntentSynchronizationService intentSynchronizer) {
        this.appId = appId;
        this.intentService = intentService;
        this.intentSynchronizer = intentSynchronizer;
    }

    protected void submitIntents(Collection<Intent> intents) {
        log.debug(SUBMIT);
        intents.forEach(arg_0 -> ((IntentSynchronizationService)this.intentSynchronizer).submit(arg_0));
    }

    protected void withdrawIntents(Collection<Intent> intents) {
        log.debug(WITHDRAW);
        intents.forEach(arg_0 -> ((IntentSynchronizationService)this.intentSynchronizer).withdraw(arg_0));
    }

    protected List<Intent> getIntentsFromVpls(String name) {
        ArrayList intents = Lists.newArrayList();
        this.intentService.getIntents().forEach(intent -> {
            if (intent.key().toString().startsWith(name)) {
                intents.add(intent);
            }
        });
        return intents;
    }

    protected SinglePointToMultiPointIntent buildBrcIntent(Key key, FilteredConnectPoint src, Set<FilteredConnectPoint> dsts, EncapsulationType encap) {
        log.debug("Building broadcast intent {} for source {}", (Object)SP2MP, (Object)src);
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthDst(MacAddress.BROADCAST).build();
        SinglePointToMultiPointIntent.Builder intentBuilder = SinglePointToMultiPointIntent.builder().appId(this.appId).key(key).selector(selector).filteredIngressPoint(src).filteredEgressPoints(dsts).priority(1000);
        IntentInstaller.encap((ConnectivityIntent.Builder)intentBuilder, encap);
        return intentBuilder.build();
    }

    protected MultiPointToSinglePointIntent buildUniIntent(Key key, Set<FilteredConnectPoint> srcs, FilteredConnectPoint dst, Host host, EncapsulationType encap) {
        log.debug("Building unicast intent {} for destination {}", (Object)MP2SP, (Object)dst);
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthDst(host.mac()).build();
        MultiPointToSinglePointIntent.Builder intentBuilder = MultiPointToSinglePointIntent.builder().appId(this.appId).key(key).selector(selector).filteredIngressPoints(srcs).filteredEgressPoint(dst).priority(1000);
        IntentInstaller.encap((ConnectivityIntent.Builder)intentBuilder, encap);
        return intentBuilder.build();
    }

    protected Key buildKey(String prefix, ConnectPoint cPoint, String vplsName, MacAddress hostMac) {
        String keyString = vplsName + SEPARATOR + prefix + SEPARATOR + cPoint.deviceId() + SEPARATOR + cPoint.port() + SEPARATOR + hostMac;
        return Key.of((String)keyString, (ApplicationId)this.appId);
    }

    protected boolean intentExists(Key intentKey) {
        if (this.intentService.getIntent(intentKey) == null) {
            return false;
        }
        IntentState currentIntentState = this.intentService.getIntentState(intentKey);
        return !WITHDRAWN_INTENT_STATES.contains(currentIntentState);
    }

    private static void encap(ConnectivityIntent.Builder builder, EncapsulationType encap) {
        if (!encap.equals((Object)EncapsulationType.NONE)) {
            builder.constraints((List)ImmutableList.of((Object)new EncapsulationConstraint(encap)));
        }
    }
}

