/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.TestApplicationId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.vpls.config.VplsAppConfig;
import org.onosproject.vpls.config.VplsConfig;

public class VplsAppConfigTest {
    private static final String APP_NAME = "org.onosproject.vpls";
    private static final ApplicationId APP_ID = new TestApplicationId("org.onosproject.vpls");
    private static final String VPLS = "vplsList";
    private static final String NAME = "name";
    private static final String INTERFACE = "interfaces";
    private static final String ENCAPSULATION = "encapsulation";
    private static final String VPLS1 = "vpls1";
    private static final String VPLS2 = "vpls2";
    private static final String NEWVPLS = "newvpls";
    private static final String IF1 = "sw5-4-100";
    private static final String IF2 = "sw5-4-200";
    private static final String IF3 = "sw5-5-100";
    private static final String IF4 = "sw6-5-100";
    private static final String IF5 = "sw6-5-400";
    private static final String IF_NON_EXIST = "sw7-5-100";
    private static final String JSON_TREE = "{\"vplsList\" : [{\"name\" : \"vpls1\",\"interfaces\" : [\"sw5-4-100\",\"sw5-4-200\",\"sw5-5-100\"],\"encapsulation\" : \"none\"}]}";
    private static final String EMPTY_JSON_TREE = "{}";
    private final ObjectMapper mapper = new ObjectMapper();
    private final ConfigApplyDelegate delegate = new MockCfgDelegate();
    private final VplsConfig initialVpls = this.createInitialVpls();
    private Set<VplsConfig> vplss = new HashSet<VplsConfig>();
    private VplsAppConfig vplsAppConfig = new VplsAppConfig();
    private VplsAppConfig emptyVplsAppConfig = new VplsAppConfig();

    @Before
    public void setUp() throws Exception {
        JsonNode tree = new ObjectMapper().readTree(JSON_TREE);
        this.vplsAppConfig.init((Object)APP_ID, APP_NAME, tree, this.mapper, this.delegate);
        JsonNode emptyTree = new ObjectMapper().readTree(EMPTY_JSON_TREE);
        this.emptyVplsAppConfig.init((Object)APP_ID, APP_NAME, emptyTree, this.mapper, this.delegate);
        this.vplss.add(this.initialVpls);
    }

    @Test
    public void vplss() {
        Assert.assertEquals((String)"Cannot load VPLS configuration or unexpected configurationloaded", this.vplss, (Object)this.vplsAppConfig.vplss());
    }

    @Test
    public void emptyVplss() {
        Assert.assertTrue((String)"Configuration retrieved from JSON was not empty", (boolean)this.emptyVplsAppConfig.vplss().isEmpty());
    }

    @Test
    public void getVplsWithName() {
        Assert.assertNotNull((String)"Configuration for VPLS not found", (Object)this.vplsAppConfig.getVplsWithName(VPLS1));
        Assert.assertNull((String)"Unexpected configuration for VPLS found", (Object)this.vplsAppConfig.getVplsWithName(VPLS2));
    }

    @Test
    public void addVpls() {
        int initialSize = this.vplsAppConfig.vplss().size();
        VplsConfig newVpls = this.createNewVpls();
        this.vplsAppConfig.addVpls(newVpls);
        Assert.assertEquals((String)"The new VPLS has not been added correctly to the list ofexisting VPLSs", (long)(initialSize + 1), (long)this.vplsAppConfig.vplss().size());
        this.vplss.add(newVpls);
    }

    @Test
    public void addVplsToEmpty() {
        VplsConfig newVpls = this.createNewVpls();
        this.emptyVplsAppConfig.addVpls(newVpls);
        Assert.assertFalse((String)"The new VPLS has not been added correctly", (boolean)this.emptyVplsAppConfig.vplss().isEmpty());
    }

    @Test
    public void removeExistingVpls() {
        int initialSize = this.vplsAppConfig.vplss().size();
        this.vplsAppConfig.removeVpls(VPLS1);
        Assert.assertEquals((String)"The VPLS has not been removed correctly", (long)(initialSize - 1), (long)this.vplsAppConfig.vplss().size());
    }

    @Test
    public void removeInexistingVpls() {
        int initialSize = this.vplsAppConfig.vplss().size();
        this.vplsAppConfig.removeVpls(VPLS2);
        Assert.assertEquals((String)"Non-configured VPLS has been unexpectedly removed", (long)initialSize, (long)this.vplsAppConfig.vplss().size());
    }

    @Test
    public void addInterfaceToVpls() {
        int initialSize = this.vplsAppConfig.getVplsWithName(VPLS1).ifaces().size();
        this.vplsAppConfig.addIface(VPLS1, IF4);
        Assert.assertEquals((String)"The interface has not been added to the VPLS", (long)(initialSize + 1), (long)this.vplsAppConfig.getVplsWithName(VPLS1).ifaces().size());
    }

    @Test
    public void addExistingInterfaceToVpls() {
        int initialSize = this.vplsAppConfig.getVplsWithName(VPLS1).ifaces().size();
        this.vplsAppConfig.addIface(VPLS1, IF1);
        Assert.assertEquals((String)"The interface has been unexpectedly added twice to thesame VPLS", (long)initialSize, (long)this.vplsAppConfig.getVplsWithName(VPLS1).ifaces().size());
    }

    @Test
    public void getVplsFromInterface() {
        Assert.assertNotNull((String)"VPLS not found", (Object)this.vplsAppConfig.vplsFromIface(IF1));
        Assert.assertNull((String)"VPLS unexpectedly found", (Object)this.vplsAppConfig.vplsFromIface(IF_NON_EXIST));
    }

    @Test
    public void removeExistingInterfaceFromVpls() {
        int initialSize = this.vplsAppConfig.getVplsWithName(VPLS1).ifaces().size();
        this.vplsAppConfig.removeIface(this.initialVpls, IF1);
        Assert.assertEquals((String)"Interface has not been removed correctly from the VPLS", (long)(initialSize - 1), (long)this.vplsAppConfig.getVplsWithName(VPLS1).ifaces().size());
    }

    @Test
    public void removeNonExistingInterfaceFromVpls() {
        int initialSize = this.vplsAppConfig.getVplsWithName(VPLS1).ifaces().size();
        this.vplsAppConfig.removeIface(this.initialVpls, IF_NON_EXIST);
        Assert.assertEquals((String)"Interface unexpectedly removed from the VPLS", (long)initialSize, (long)this.vplsAppConfig.getVplsWithName(VPLS1).ifaces().size());
    }

    @Test
    public void isAttached() {
        VplsConfig vpls = this.createNewVpls();
        Assert.assertTrue((String)"Interface not correctly attached to the VPLS", (boolean)vpls.isAttached(IF4));
        Assert.assertTrue((String)"Interface not correctly attached to the VPLS", (boolean)vpls.isAttached(IF4));
        Assert.assertFalse((String)"Unexpected interface attached to the VPLS", (boolean)vpls.isAttached(IF_NON_EXIST));
    }

    @Test
    public void encap() {
        this.vplsAppConfig.setEncap(VPLS1, EncapsulationType.VLAN);
        Assert.assertEquals((String)"Wrong encapsulation type found", (Object)EncapsulationType.VLAN, (Object)this.vplsAppConfig.getVplsWithName(VPLS1).encap());
    }

    private VplsConfig createInitialVpls() {
        HashSet<String> ifaces = new HashSet<String>(Arrays.asList(IF1, IF2, IF3));
        return new VplsConfig(VPLS1, ifaces, EncapsulationType.NONE);
    }

    private VplsConfig createNewVpls() {
        HashSet<String> ifaces = new HashSet<String>(Arrays.asList(IF4, IF5));
        return new VplsConfig(NEWVPLS, ifaces, EncapsulationType.NONE);
    }

    private class MockCfgDelegate
    implements ConfigApplyDelegate {
        private MockCfgDelegate() {
        }

        public void onApply(Config config) {
            config.apply();
        }
    }
}

