/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.onlab.util.BoundedThreadPool;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.Host;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentException;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentUtils;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;
import org.onosproject.net.intf.Interface;
import org.onosproject.vpls.api.VplsData;
import org.onosproject.vpls.api.VplsOperation;
import org.onosproject.vpls.api.VplsOperationException;
import org.onosproject.vpls.api.VplsOperationService;
import org.onosproject.vpls.api.VplsStore;
import org.onosproject.vpls.intent.VplsIntentUtility;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={VplsOperationService.class})
public class VplsOperationManager
implements VplsOperationService {
    private static final int NUM_THREADS = 4;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected VplsStore vplsStore;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Map<String, Deque<VplsOperation>> pendingVplsOperations;
    protected final Map<String, VplsOperation> runningOperations = Maps.newHashMap();
    protected ScheduledExecutorService schedulerExecutor;
    protected ExecutorService workerExecutor;
    protected ApplicationId appId;
    protected boolean isLeader;
    protected NodeId localNodeId;
    protected LeadershipEventListener leadershipEventListener;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.vpls");
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leadershipEventListener = new InternalLeadershipListener();
        this.leadershipService.addListener((EventListener)this.leadershipEventListener);
        this.leadershipService.runForLeadership(this.appId.name());
        this.pendingVplsOperations = Maps.newConcurrentMap();
        this.workerExecutor = BoundedThreadPool.newFixedThreadPool((int)4, (ThreadFactory)Tools.groupedThreads((String)"onos/apps/vpls", (String)"worker-%d", (Logger)this.log));
        this.schedulerExecutor = Executors.newScheduledThreadPool(1, Tools.groupedThreads((String)"onos/apps/vpls", (String)"scheduler-%d", (Logger)this.log));
        this.schedulerExecutor.scheduleAtFixedRate(new VplsOperationScheduler(), 0L, 500L, TimeUnit.MILLISECONDS);
    }

    @Deactivate
    public void deactivate() {
        this.pendingVplsOperations.clear();
        this.runningOperations.clear();
        this.leadershipService.removeListener((EventListener)this.leadershipEventListener);
        this.schedulerExecutor.shutdown();
        this.workerExecutor.shutdown();
        Tools.stream((Iterable)this.intentService.getIntents()).filter(intent -> intent.appId().equals(this.appId)).forEach(arg_0 -> ((IntentService)this.intentService).withdraw(arg_0));
    }

    @Override
    public void submit(VplsOperation vplsOperation) {
        if (this.isLeader) {
            this.addVplsOperation(vplsOperation);
        }
    }

    private void addVplsOperation(VplsOperation vplsOperation) {
        VplsData vplsData = vplsOperation.vpls();
        this.pendingVplsOperations.compute(vplsData.name(), (name, opQueue) -> {
            Deque deque = opQueue = opQueue == null ? Queues.newArrayDeque() : opQueue;
            if (opQueue.contains(vplsOperation)) {
                return opQueue;
            }
            opQueue.add(vplsOperation);
            return opQueue;
        });
    }

    protected static VplsOperation getOptimizedVplsOperation(Deque<VplsOperation> operations) {
        if (operations.isEmpty()) {
            return null;
        }
        if (operations.size() == 1) {
            return operations.getFirst();
        }
        VplsOperation firstOperation = operations.peekFirst();
        VplsOperation lastOperation = operations.peekLast();
        VplsOperation.Operation firstOp = firstOperation.op();
        VplsOperation.Operation lastOp = lastOperation.op();
        if (firstOp.equals((Object)VplsOperation.Operation.REMOVE)) {
            if (lastOp.equals((Object)VplsOperation.Operation.REMOVE)) {
                return firstOperation;
            }
            if (lastOp.equals((Object)VplsOperation.Operation.ADD)) {
                return VplsOperation.of(lastOperation.vpls(), VplsOperation.Operation.UPDATE);
            }
            return lastOperation;
        }
        if (firstOp.equals((Object)VplsOperation.Operation.ADD)) {
            if (lastOp.equals((Object)VplsOperation.Operation.REMOVE)) {
                return null;
            }
            if (lastOp.equals((Object)VplsOperation.Operation.ADD)) {
                return VplsOperation.of(lastOperation.vpls(), VplsOperation.Operation.ADD);
            }
            return VplsOperation.of(lastOperation.vpls(), VplsOperation.Operation.ADD);
        }
        if (lastOp.equals((Object)VplsOperation.Operation.REMOVE)) {
            return lastOperation;
        }
        if (lastOp.equals((Object)VplsOperation.Operation.ADD)) {
            return VplsOperation.of(lastOperation.vpls(), VplsOperation.Operation.UPDATE);
        }
        return VplsOperation.of(lastOperation.vpls(), VplsOperation.Operation.UPDATE);
    }

    private class InternalLeadershipListener
    implements LeadershipEventListener {
        private static final String LEADER_CHANGE = "Change leader to {}";

        private InternalLeadershipListener() {
        }

        public void event(LeadershipEvent event) {
            switch ((LeadershipEvent.Type)event.type()) {
                case LEADER_CHANGED: 
                case LEADER_AND_CANDIDATES_CHANGED: {
                    VplsOperationManager.this.isLeader = VplsOperationManager.this.localNodeId.equals((Object)((Leadership)event.subject()).leaderNodeId());
                    if (!VplsOperationManager.this.isLeader) break;
                    VplsOperationManager.this.log.debug(LEADER_CHANGE, (Object)VplsOperationManager.this.localNodeId);
                    break;
                }
            }
        }

        public boolean isRelevant(LeadershipEvent event) {
            return ((Leadership)event.subject()).topic().equals(VplsOperationManager.this.appId.name());
        }
    }

    class VplsOperationExecutor
    implements Runnable {
        private static final String UNKNOWN_OP = "Unknown operation.";
        private static final String UNKNOWN_INTENT_DIR = "Unknown Intent install direction.";
        private static final int OPERATION_TIMEOUT = 10;
        private VplsOperation vplsOperation;
        private Consumer<VplsOperation> successConsumer;
        private Consumer<VplsOperationException> errorConsumer;
        private VplsOperationException error;

        public VplsOperationExecutor(VplsOperation vplsOperation) {
            this.vplsOperation = vplsOperation;
            this.error = null;
        }

        public void setConsumers(Consumer<VplsOperation> successConsumer, Consumer<VplsOperationException> errorConsumer) {
            this.successConsumer = successConsumer;
            this.errorConsumer = errorConsumer;
        }

        @Override
        public void run() {
            switch (this.vplsOperation.op()) {
                case ADD: {
                    this.installVplsIntents();
                    break;
                }
                case REMOVE: {
                    this.removeVplsIntents();
                    break;
                }
                case UPDATE: {
                    this.updateVplsIntents();
                    break;
                }
                default: {
                    this.error = new VplsOperationException(this.vplsOperation, UNKNOWN_OP);
                }
            }
            if (this.error != null) {
                this.errorConsumer.accept(this.error);
            } else {
                this.successConsumer.accept(this.vplsOperation);
            }
        }

        private void updateVplsIntents() {
            Set<Intent> targetBrcIntents;
            HashSet intentsToInstall = Sets.newHashSet();
            HashSet intentsToUninstall = Sets.newHashSet();
            VplsData vplsData = this.vplsOperation.vpls();
            Set<Intent> currentIntents = this.getCurrentIntents();
            Set<Intent> currentBrcIntents = currentIntents.stream().filter(intent -> intent instanceof SinglePointToMultiPointIntent).collect(Collectors.toSet());
            if (!this.intentSetEquals(currentBrcIntents, targetBrcIntents = VplsIntentUtility.buildBrcIntents(vplsData, VplsOperationManager.this.appId))) {
                this.removeVplsIntents();
                this.installVplsIntents();
                return;
            }
            Set<Intent> currentUniIntents = currentIntents.stream().filter(intent -> intent instanceof MultiPointToSinglePointIntent).collect(Collectors.toSet());
            Set<Intent> targetUniIntents = VplsIntentUtility.buildUniIntents(vplsData, this.hostsFromVpls(), VplsOperationManager.this.appId);
            targetUniIntents.forEach(intent -> {
                if (!currentUniIntents.contains(intent)) {
                    intentsToInstall.add(intent);
                }
            });
            currentUniIntents.forEach(intent -> {
                if (!targetUniIntents.contains(intent)) {
                    intentsToUninstall.add(intent);
                }
            });
            this.applyIntentsSync(intentsToUninstall, Direction.REMOVE);
            this.applyIntentsSync(intentsToInstall, Direction.ADD);
        }

        private Set<Host> hostsFromVpls() {
            VplsData vplsData = this.vplsOperation.vpls();
            Set<Interface> interfaces = vplsData.interfaces();
            return interfaces.stream().map(this::hostsFromInterface).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        private Set<Host> hostsFromInterface(Interface iface) {
            return VplsOperationManager.this.hostService.getConnectedHosts(iface.connectPoint()).stream().filter(host -> host.vlan().equals((Object)iface.vlan())).collect(Collectors.toSet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyIntentsSync(Set<Intent> intents, Direction direction) {
            IntentCompleter completer;
            Set<Key> pendingIntentKeys = intents.stream().map(Intent::key).collect(Collectors.toSet());
            switch (direction) {
                case ADD: {
                    completer = new IntentCompleter(pendingIntentKeys, IntentEvent.Type.INSTALLED);
                    VplsOperationManager.this.intentService.addListener((EventListener)completer);
                    intents.forEach(arg_0 -> ((IntentService)VplsOperationManager.this.intentService).submit(arg_0));
                    break;
                }
                case REMOVE: {
                    completer = new IntentCompleter(pendingIntentKeys, IntentEvent.Type.WITHDRAWN);
                    VplsOperationManager.this.intentService.addListener((EventListener)completer);
                    intents.forEach(arg_0 -> ((IntentService)VplsOperationManager.this.intentService).withdraw(arg_0));
                    break;
                }
                default: {
                    this.error = new VplsOperationException(this.vplsOperation, UNKNOWN_INTENT_DIR);
                    return;
                }
            }
            try {
                completer.complete();
            }
            catch (VplsOperationException e) {
                this.error = e;
            }
            finally {
                VplsOperationManager.this.intentService.removeListener((EventListener)completer);
            }
        }

        private boolean intentSetEquals(Set<Intent> intentSet1, Set<Intent> intentSet2) {
            if (intentSet1.size() != intentSet2.size()) {
                return false;
            }
            for (Intent intent1 : intentSet1) {
                if (!intentSet2.stream().noneMatch(intent2 -> IntentUtils.intentsAreEqual((Intent)intent1, (Intent)intent2))) continue;
                return false;
            }
            return true;
        }

        private Set<Intent> getCurrentIntents() {
            VplsData vplsData = this.vplsOperation.vpls();
            String vplsName = vplsData.name();
            return Tools.stream((Iterable)VplsOperationManager.this.intentService.getIntents()).filter(intent -> intent.key().toString().startsWith(vplsName)).collect(Collectors.toSet());
        }

        private Set<Intent> generateVplsIntents() {
            VplsData vplsData = this.vplsOperation.vpls();
            Set<Intent> brcIntents = VplsIntentUtility.buildBrcIntents(vplsData, VplsOperationManager.this.appId);
            Set<Intent> uniIntent = VplsIntentUtility.buildUniIntents(vplsData, this.hostsFromVpls(), VplsOperationManager.this.appId);
            return Stream.concat(brcIntents.stream(), uniIntent.stream()).collect(Collectors.toSet());
        }

        private void removeVplsIntents() {
            Set<Intent> intentsToWithdraw = this.getCurrentIntents();
            this.applyIntentsSync(intentsToWithdraw, Direction.REMOVE);
            intentsToWithdraw.forEach(arg_0 -> ((IntentService)VplsOperationManager.this.intentService).purge(arg_0));
        }

        private void installVplsIntents() {
            Set<Intent> intentsToInstall = this.generateVplsIntents();
            this.applyIntentsSync(intentsToInstall, Direction.ADD);
        }

        class IntentCompleter
        implements IntentListener {
            private static final String INTENT_COMPILE_ERR = "Got {} from intent completer";
            private CompletableFuture<Void> completableFuture = new CompletableFuture();
            private Set<Key> pendingIntentKeys;
            private IntentEvent.Type expectedEventType;

            public IntentCompleter(Set<Key> pendingIntentKeys, IntentEvent.Type expectedEventType) {
                this.pendingIntentKeys = Sets.newConcurrentHashSet(pendingIntentKeys);
                this.expectedEventType = expectedEventType;
            }

            public void event(IntentEvent event) {
                Intent intent = (Intent)event.subject();
                Key key = intent.key();
                if (!this.pendingIntentKeys.contains(key)) {
                    return;
                }
                if (event.type() == IntentEvent.Type.CORRUPT || event.type() == IntentEvent.Type.FAILED) {
                    this.completableFuture.completeExceptionally(new IntentException(intent.toString()));
                    return;
                }
                if (event.type() == this.expectedEventType) {
                    this.pendingIntentKeys.remove(key);
                }
                if (this.pendingIntentKeys.isEmpty()) {
                    this.completableFuture.complete(null);
                }
            }

            public void complete() {
                if (this.pendingIntentKeys.isEmpty()) {
                    return;
                }
                try {
                    this.completableFuture.get(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException | IntentException e) {
                    VplsOperationManager.this.log.warn(INTENT_COMPILE_ERR, (Object)e.toString());
                    throw new VplsOperationException(VplsOperationExecutor.this.vplsOperation, e.toString());
                }
            }
        }
    }

    private static enum Direction {
        ADD,
        REMOVE;

    }

    class VplsOperationScheduler
    implements Runnable {
        private static final String UNKNOWN_STATE = "Unknown state {} for success consumer";
        private static final String OP_EXEC_ERR = "Error when executing VPLS operation {}, error: {}";

        VplsOperationScheduler() {
        }

        @Override
        public void run() {
            Set<String> vplsNames = VplsOperationManager.this.pendingVplsOperations.keySet();
            vplsNames.forEach(vplsName -> {
                VplsOperation operation;
                Map<String, VplsOperation> map = VplsOperationManager.this.runningOperations;
                synchronized (map) {
                    if (VplsOperationManager.this.runningOperations.containsKey(vplsName)) {
                        return;
                    }
                    Deque<VplsOperation> operations = VplsOperationManager.this.pendingVplsOperations.remove(vplsName);
                    operation = VplsOperationManager.getOptimizedVplsOperation(operations);
                    if (operation == null) {
                        return;
                    }
                    VplsOperationManager.this.runningOperations.put((String)vplsName, operation);
                }
                VplsOperationExecutor operationExecutor = new VplsOperationExecutor(operation);
                operationExecutor.setConsumers(vplsOperation -> {
                    VplsData vplsData = vplsOperation.vpls();
                    VplsOperationManager.this.log.debug("VPLS operation success: {}", vplsOperation);
                    switch (vplsData.state()) {
                        case ADDING: 
                        case UPDATING: {
                            vplsData.state(VplsData.VplsState.ADDED);
                            VplsOperationManager.this.vplsStore.updateVpls(vplsData);
                            break;
                        }
                        case REMOVING: {
                            break;
                        }
                        default: {
                            VplsOperationManager.this.log.warn(UNKNOWN_STATE, (Object)vplsData.state());
                            vplsData.state(VplsData.VplsState.FAILED);
                            VplsOperationManager.this.vplsStore.updateVpls(vplsData);
                        }
                    }
                    VplsOperationManager.this.runningOperations.remove(vplsName);
                }, vplsOperationException -> {
                    VplsOperation vplsOperation = vplsOperationException.vplsOperation();
                    VplsOperationManager.this.log.warn(OP_EXEC_ERR, (Object)vplsOperation.toString(), (Object)vplsOperationException.getMessage());
                    VplsData vplsData = vplsOperation.vpls();
                    vplsData.state(VplsData.VplsState.FAILED);
                    VplsOperationManager.this.vplsStore.updateVpls(vplsData);
                    VplsOperationManager.this.runningOperations.remove(vplsName);
                });
                VplsOperationManager.this.log.debug("Applying operation: {}", (Object)operation);
                VplsOperationManager.this.workerExecutor.execute(operationExecutor);
            });
        }
    }
}

