/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.onosproject.event.EventListener;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.Host;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intf.Interface;
import org.onosproject.net.intf.InterfaceService;
import org.onosproject.store.StoreDelegate;
import org.onosproject.vpls.api.Vpls;
import org.onosproject.vpls.api.VplsData;
import org.onosproject.vpls.api.VplsOperation;
import org.onosproject.vpls.api.VplsOperationService;
import org.onosproject.vpls.api.VplsStore;
import org.onosproject.vpls.store.VplsStoreEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Vpls.class})
public class VplsManager
implements Vpls {
    public static final String VPLS_APP = "org.onosproject.vpls";
    private static final String UNSUPPORTED_STORE_EVENT_TYPE = "Unsupported store event type {}.";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected VplsStore vplsStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected VplsOperationService operationService;
    private StoreDelegate<VplsStoreEvent> vplsStoreDelegate;
    private HostListener vplsHostListener;

    @Activate
    public void activate() {
        this.vplsStoreDelegate = new VplsStoreDelegate();
        this.vplsHostListener = new VplsHostListener();
        this.vplsStore.setDelegate(this.vplsStoreDelegate);
        this.hostService.addListener((EventListener)this.vplsHostListener);
    }

    @Deactivate
    public void deactivate() {
        this.vplsStore.unsetDelegate(this.vplsStoreDelegate);
        this.hostService.removeListener((EventListener)this.vplsHostListener);
    }

    @Override
    public VplsData createVpls(String vplsName, EncapsulationType encapsulationType) {
        Objects.requireNonNull(vplsName);
        Objects.requireNonNull(encapsulationType);
        if (this.vplsStore.getVpls(vplsName) != null) {
            return null;
        }
        VplsData vplsData = VplsData.of(vplsName, encapsulationType);
        this.vplsStore.addVpls(vplsData);
        return vplsData;
    }

    @Override
    public VplsData removeVpls(VplsData vplsData) {
        Objects.requireNonNull(vplsData);
        VplsData newData = VplsData.of(vplsData);
        newData.state(VplsData.VplsState.REMOVING);
        this.vplsStore.removeVpls(vplsData);
        return vplsData;
    }

    @Override
    public void addInterfaces(VplsData vplsData, Collection<Interface> interfaces) {
        Objects.requireNonNull(vplsData);
        Objects.requireNonNull(interfaces);
        VplsData newData = VplsData.of(vplsData);
        newData.addInterfaces(interfaces);
        this.updateVplsStatus(newData, VplsData.VplsState.UPDATING);
    }

    @Override
    public void addInterface(VplsData vplsData, Interface iface) {
        Objects.requireNonNull(vplsData);
        Objects.requireNonNull(iface);
        VplsData newData = VplsData.of(vplsData);
        newData.addInterface(iface);
        this.updateVplsStatus(newData, VplsData.VplsState.UPDATING);
    }

    @Override
    public void setEncapsulationType(VplsData vplsData, EncapsulationType encapsulationType) {
        Objects.requireNonNull(vplsData);
        Objects.requireNonNull(encapsulationType);
        VplsData newData = VplsData.of(vplsData);
        if (newData.encapsulationType().equals((Object)encapsulationType)) {
            return;
        }
        newData.encapsulationType(encapsulationType);
        this.updateVplsStatus(newData, VplsData.VplsState.UPDATING);
    }

    @Override
    public VplsData getVpls(String vplsName) {
        Objects.requireNonNull(vplsName);
        return this.vplsStore.getVpls(vplsName);
    }

    @Override
    public Collection<Interface> removeInterfaces(VplsData vplsData, Collection<Interface> interfaces) {
        Objects.requireNonNull(vplsData);
        Objects.requireNonNull(interfaces);
        VplsData newData = VplsData.of(vplsData);
        newData.removeInterfaces(interfaces);
        this.updateVplsStatus(newData, VplsData.VplsState.UPDATING);
        return interfaces;
    }

    @Override
    public Interface removeInterface(VplsData vplsData, Interface iface) {
        Objects.requireNonNull(vplsData);
        Objects.requireNonNull(iface);
        VplsData newData = VplsData.of(vplsData);
        newData.removeInterface(iface);
        this.updateVplsStatus(newData, VplsData.VplsState.UPDATING);
        return iface;
    }

    @Override
    public void removeAllVpls() {
        ImmutableSet allVplses = ImmutableSet.copyOf(this.vplsStore.getAllVpls());
        allVplses.forEach(this::removeVpls);
    }

    @Override
    public Collection<VplsData> getAllVpls() {
        return ImmutableSet.copyOf(this.vplsStore.getAllVpls());
    }

    private void updateVplsStatus(VplsData vplsData, VplsData.VplsState vplsState) {
        vplsData.state(vplsState);
        this.vplsStore.updateVpls(vplsData);
    }

    class VplsStoreDelegate
    implements StoreDelegate<VplsStoreEvent> {
        VplsStoreDelegate() {
        }

        public void notify(VplsStoreEvent event) {
            VplsOperation.Operation op;
            VplsData vplsData = (VplsData)event.subject();
            switch ((VplsStoreEvent.Type)event.type()) {
                case ADD: {
                    op = VplsOperation.Operation.ADD;
                    break;
                }
                case REMOVE: {
                    op = VplsOperation.Operation.REMOVE;
                    break;
                }
                case UPDATE: {
                    if (vplsData.state() == VplsData.VplsState.FAILED || vplsData.state() == VplsData.VplsState.ADDED || vplsData.state() == VplsData.VplsState.REMOVED) {
                        op = null;
                        break;
                    }
                    op = VplsOperation.Operation.UPDATE;
                    break;
                }
                default: {
                    VplsManager.this.log.warn(VplsManager.UNSUPPORTED_STORE_EVENT_TYPE, (Object)event.type());
                    return;
                }
            }
            if (op != null) {
                VplsOperation vplsOperation = VplsOperation.of(vplsData, op);
                VplsManager.this.operationService.submit(vplsOperation);
            }
        }
    }

    class VplsHostListener
    implements HostListener {
        VplsHostListener() {
        }

        public void event(HostEvent event) {
            Host host = (Host)event.subject();
            Interface iface = this.getHostInterface(host);
            if (iface == null) {
                return;
            }
            VplsData vplsData = VplsManager.this.vplsStore.getAllVpls().stream().filter(v -> v.interfaces().contains(iface)).findFirst().orElse(null);
            if (vplsData == null) {
                return;
            }
            VplsManager.this.updateVplsStatus(vplsData, VplsData.VplsState.UPDATING);
        }

        private Interface getHostInterface(Host host) {
            Set interfaces = VplsManager.this.interfaceService.getInterfaces();
            return interfaces.stream().filter(iface -> iface.connectPoint().equals((Object)host.location()) && iface.vlan().equals((Object)host.vlan())).findFirst().orElse(null);
        }
    }
}

