/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.cli.completer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractChoicesCompleter;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.intf.Interface;
import org.onosproject.net.intf.InterfaceService;
import org.onosproject.vpls.api.Vpls;
import org.onosproject.vpls.api.VplsData;
import org.onosproject.vpls.cli.VplsCommandEnum;

@Service
public class VplsOptArgCompleter
extends AbstractChoicesCompleter {
    protected Vpls vpls;
    protected InterfaceService interfaceService;

    public List<String> choices() {
        String[] argList;
        if (this.vpls == null) {
            this.vpls = (Vpls)AbstractShellCommand.get(Vpls.class);
        }
        if ((argList = this.commandLine.getArguments()) == null) {
            return Collections.emptyList();
        }
        String argOne = argList[1];
        VplsCommandEnum vplsCommandEnum = VplsCommandEnum.enumFromString(argOne);
        if (vplsCommandEnum != null) {
            switch (vplsCommandEnum) {
                case ADD_IFACE: {
                    return this.availableIfaces();
                }
                case SET_ENCAP: {
                    return this.encap();
                }
                case REMOVE_IFACE: {
                    return this.vplsIfaces();
                }
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private List<String> availableIfaces() {
        if (this.interfaceService == null) {
            this.interfaceService = (InterfaceService)AbstractShellCommand.get(InterfaceService.class);
        }
        Set allIfaces = this.interfaceService.getInterfaces();
        Set usedIfaces = this.vpls.getAllVpls().stream().map(VplsData::interfaces).flatMap(Collection::stream).collect(Collectors.toSet());
        return allIfaces.stream().filter(iface -> !usedIfaces.contains(iface)).map(Interface::name).collect(Collectors.toList());
    }

    private List<String> encap() {
        return Arrays.stream(EncapsulationType.values()).map(Enum::toString).collect(Collectors.toList());
    }

    private List<String> vplsIfaces() {
        String vplsName = this.commandLine.getArguments()[2];
        VplsData vplsData = this.vpls.getVpls(vplsName);
        return vplsData.interfaces().stream().map(Interface::name).collect(Collectors.toList());
    }
}

