/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.intent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;
import org.onosproject.net.intent.constraint.EncapsulationConstraint;
import org.onosproject.net.intent.constraint.PartialFailureConstraint;
import org.onosproject.net.intf.Interface;
import org.onosproject.vpls.api.VplsData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VplsIntentUtility {
    private static final String SP2MP = "Building sp2mp intent from {}";
    private static final String MP2SP = "Building mp2sp intent to {}";
    private static final Logger log = LoggerFactory.getLogger(VplsIntentUtility.class);
    private static final int PRIORITY_OFFSET = 1000;
    private static final int PRIORITY_UNI = 200;
    private static final int PRIORITY_BRC = 100;
    public static final String PREFIX_BROADCAST = "brc";
    public static final String PREFIX_UNICAST = "uni";
    private static final String SEPARATOR = "-";
    public static final ImmutableList<Constraint> PARTIAL_FAILURE_CONSTRAINT = ImmutableList.of((Object)new PartialFailureConstraint());

    private VplsIntentUtility() {
    }

    public static Set<Intent> buildBrcIntents(VplsData vplsData, ApplicationId appId) {
        Set<Interface> interfaces = vplsData.interfaces();
        if (interfaces.size() < 2) {
            return ImmutableSet.of();
        }
        HashSet brcIntents = Sets.newHashSet();
        ResourceGroup resourceGroup = ResourceGroup.of((String)vplsData.name());
        interfaces.forEach(src -> {
            FilteredConnectPoint srcFcp = VplsIntentUtility.buildFilteredConnectedPoint(src);
            Set<FilteredConnectPoint> dstFcps = interfaces.stream().filter(iface -> !iface.equals(src)).map(VplsIntentUtility::buildFilteredConnectedPoint).collect(Collectors.toSet());
            Key key = VplsIntentUtility.buildKey(PREFIX_BROADCAST, srcFcp.connectPoint(), vplsData.name(), MacAddress.BROADCAST, appId);
            SinglePointToMultiPointIntent brcIntent = VplsIntentUtility.buildBrcIntent(key, appId, srcFcp, dstFcps, vplsData.encapsulationType(), resourceGroup);
            brcIntents.add(brcIntent);
        });
        return brcIntents;
    }

    static SinglePointToMultiPointIntent buildBrcIntent(Key key, ApplicationId appId, FilteredConnectPoint src, Set<FilteredConnectPoint> dsts, EncapsulationType encap, ResourceGroup resourceGroup) {
        log.debug("Building broadcast intent {} for source {}", (Object)SP2MP, (Object)src);
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthDst(MacAddress.BROADCAST).build();
        SinglePointToMultiPointIntent.Builder intentBuilder = SinglePointToMultiPointIntent.builder().appId(appId).key(key).selector(selector).filteredIngressPoint(src).filteredEgressPoints(dsts).constraints(PARTIAL_FAILURE_CONSTRAINT).priority(1100).resourceGroup(resourceGroup);
        VplsIntentUtility.setEncap((ConnectivityIntent.Builder)intentBuilder, PARTIAL_FAILURE_CONSTRAINT, encap);
        return intentBuilder.build();
    }

    public static Set<Intent> buildUniIntents(VplsData vplsData, Set<Host> hosts, ApplicationId appId) {
        Set<Interface> interfaces = vplsData.interfaces();
        if (interfaces.size() < 2) {
            return ImmutableSet.of();
        }
        HashSet uniIntents = Sets.newHashSet();
        ResourceGroup resourceGroup = ResourceGroup.of((String)vplsData.name());
        hosts.forEach(host -> {
            FilteredConnectPoint hostFcp = VplsIntentUtility.buildFilteredConnectedPoint(host);
            Set<FilteredConnectPoint> srcFcps = interfaces.stream().map(VplsIntentUtility::buildFilteredConnectedPoint).filter(fcp -> !fcp.equals((Object)hostFcp)).collect(Collectors.toSet());
            Key key = VplsIntentUtility.buildKey(PREFIX_UNICAST, hostFcp.connectPoint(), vplsData.name(), host.mac(), appId);
            MultiPointToSinglePointIntent uniIntent = VplsIntentUtility.buildUniIntent(key, appId, srcFcps, hostFcp, host, vplsData.encapsulationType(), resourceGroup);
            uniIntents.add(uniIntent);
        });
        return uniIntents;
    }

    static MultiPointToSinglePointIntent buildUniIntent(Key key, ApplicationId appId, Set<FilteredConnectPoint> srcs, FilteredConnectPoint dst, Host host, EncapsulationType encap, ResourceGroup resourceGroup) {
        log.debug("Building unicast intent {} for destination {}", (Object)MP2SP, (Object)dst);
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthDst(host.mac()).build();
        MultiPointToSinglePointIntent.Builder intentBuilder = MultiPointToSinglePointIntent.builder().appId(appId).key(key).selector(selector).filteredIngressPoints(srcs).filteredEgressPoint(dst).constraints(PARTIAL_FAILURE_CONSTRAINT).priority(1200).resourceGroup(resourceGroup);
        VplsIntentUtility.setEncap((ConnectivityIntent.Builder)intentBuilder, PARTIAL_FAILURE_CONSTRAINT, encap);
        return intentBuilder.build();
    }

    static Key buildKey(String prefix, ConnectPoint cPoint, String vplsName, MacAddress hostMac, ApplicationId appId) {
        String keyString = vplsName + SEPARATOR + prefix + SEPARATOR + cPoint.deviceId() + SEPARATOR + cPoint.port() + SEPARATOR + hostMac;
        return Key.of((String)keyString, (ApplicationId)appId);
    }

    public static void setEncap(ConnectivityIntent.Builder builder, List<Constraint> constraints, EncapsulationType encap) {
        ArrayList<Constraint> newConstraints = new ArrayList<Constraint>(constraints);
        constraints.stream().filter(c -> c instanceof EncapsulationConstraint).forEach(newConstraints::remove);
        if (!encap.equals((Object)EncapsulationType.NONE)) {
            newConstraints.add((Constraint)new EncapsulationConstraint(encap));
        }
        builder.constraints((List)ImmutableList.copyOf(newConstraints));
    }

    static FilteredConnectPoint buildFilteredConnectedPoint(Interface iface) {
        Objects.requireNonNull(iface);
        TrafficSelector.Builder trafficSelector = DefaultTrafficSelector.builder();
        if (iface.vlan() != null && !iface.vlan().equals((Object)VlanId.NONE)) {
            trafficSelector.matchVlanId(iface.vlan());
        }
        return new FilteredConnectPoint(iface.connectPoint(), trafficSelector.build());
    }

    static FilteredConnectPoint buildFilteredConnectedPoint(Host host) {
        Objects.requireNonNull(host);
        TrafficSelector.Builder trafficSelector = DefaultTrafficSelector.builder();
        if (host.vlan() != null && !host.vlan().equals((Object)VlanId.NONE)) {
            trafficSelector.matchVlanId(host.vlan());
        }
        return new FilteredConnectPoint((ConnectPoint)host.location(), trafficSelector.build());
    }
}

