/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.config;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.onlab.util.Tools;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.intf.Interface;
import org.onosproject.net.intf.InterfaceService;
import org.onosproject.vpls.api.Vpls;
import org.onosproject.vpls.api.VplsData;
import org.onosproject.vpls.config.VplsAppConfig;
import org.onosproject.vpls.config.VplsConfigManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class VplsConfigManager {
    private static final Class<VplsAppConfig> CONFIG_CLASS = VplsAppConfig.class;
    private static final String NET_CONF_EVENT = "Received NetworkConfigEvent {}";
    private static final String CONFIG_NULL = "VPLS configuration not defined";
    private static final int INITIAL_RELOAD_CONFIG_DELAY = 0;
    private static final int INITIAL_RELOAD_CONFIG_PERIOD = 1000;
    private static final int NUM_THREADS = 1;
    private static final String VPLS = "vpls";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NetworkConfigListener configListener = new InternalNetworkConfigListener(this);
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected NetworkConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected NetworkConfigRegistry registry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected Vpls vpls;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected LeadershipService leadershipService;
    private ScheduledExecutorService reloadExecutor = Executors.newScheduledThreadPool(1, Tools.groupedThreads((String)"onos/apps/vpls", (String)"config-reloader-%d", (Logger)this.log));
    private ConfigFactory<ApplicationId, VplsAppConfig> vplsConfigFactory = new /* Unavailable Anonymous Inner Class!! */;
    protected ApplicationId appId;

    @Activate
    void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.vpls");
        this.configService.addListener((EventListener)this.configListener);
        this.reloadExecutor.scheduleAtFixedRate(() -> {
            NodeId vplsLeaderNode = this.leadershipService.getLeader(this.appId.name());
            if (this.vpls == null || vplsLeaderNode == null) {
                return;
            }
            this.reloadConfiguration();
            this.reloadExecutor.shutdown();
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
        this.registry.registerConfigFactory(this.vplsConfigFactory);
    }

    @Deactivate
    void deactivate() {
        this.configService.removeListener((EventListener)this.configListener);
        this.registry.unregisterConfigFactory(this.vplsConfigFactory);
    }

    private synchronized void reloadConfiguration() {
        VplsAppConfig vplsAppConfig = (VplsAppConfig)this.configService.getConfig((Object)this.appId, VplsAppConfig.class);
        if (vplsAppConfig == null) {
            this.log.warn(CONFIG_NULL);
            this.vpls.removeAllVpls();
            return;
        }
        long updateTime = vplsAppConfig.updateTime();
        if (updateTime != -1L) {
            return;
        }
        Collection oldVplses = this.vpls.getAllVpls();
        Collection newVplses = vplsAppConfig.vplss().stream().map(vplsConfig -> {
            Set interfaces = vplsConfig.ifaces().stream().map(arg_0 -> this.getInterfaceByName(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
            VplsData vplsData = VplsData.of((String)vplsConfig.name(), (EncapsulationType)vplsConfig.encap());
            vplsData.addInterfaces(interfaces);
            return vplsData;
        }).collect(Collectors.toSet());
        if (newVplses.containsAll(oldVplses) && oldVplses.containsAll(newVplses)) {
            return;
        }
        newVplses.forEach(newVplsData -> {
            boolean vplsExists = false;
            for (VplsData oldVplsData : oldVplses) {
                if (!oldVplsData.name().equals(newVplsData.name())) continue;
                vplsExists = true;
                if (oldVplsData.equals(newVplsData)) continue;
                Set newInterfaces = newVplsData.interfaces();
                Set oldInterfaces = oldVplsData.interfaces();
                Set ifaceToAdd = newInterfaces.stream().filter(iface -> !oldInterfaces.contains(iface)).collect(Collectors.toSet());
                Set ifaceToRem = oldInterfaces.stream().filter(iface -> !newInterfaces.contains(iface)).collect(Collectors.toSet());
                this.vpls.addInterfaces(oldVplsData, ifaceToAdd);
                this.vpls.removeInterfaces(oldVplsData, ifaceToRem);
                this.vpls.setEncapsulationType(oldVplsData, newVplsData.encapsulationType());
            }
            if (!vplsExists) {
                this.vpls.createVpls(newVplsData.name(), newVplsData.encapsulationType());
                this.vpls.addInterfaces(newVplsData, (Collection)newVplsData.interfaces());
            }
        });
        HashSet vplsToRemove = Sets.newHashSet();
        oldVplses.forEach(oldVpls -> {
            Set newVplsNames = newVplses.stream().map(VplsData::name).collect(Collectors.toSet());
            if (!newVplsNames.contains(oldVpls.name())) {
                vplsToRemove.add(oldVpls);
            }
        });
        vplsToRemove.forEach(arg_0 -> ((Vpls)this.vpls).removeVpls(arg_0));
    }

    private Interface getInterfaceByName(String interfaceName) {
        return this.interfaceService.getInterfaces().stream().filter(iface -> iface.name().equals(interfaceName)).findFirst().orElse(null);
    }
}

