/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.store;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.intf.Interface;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.onosproject.vpls.api.VplsData;
import org.onosproject.vpls.api.VplsOperation;
import org.onosproject.vpls.api.VplsStore;
import org.onosproject.vpls.config.VplsAppConfig;
import org.onosproject.vpls.config.VplsConfig;
import org.onosproject.vpls.store.DistributedVplsStore;
import org.onosproject.vpls.store.VplsStoreEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={VplsStore.class})
public class DistributedVplsStore
extends AbstractStore<VplsStoreEvent, StoreDelegate<VplsStoreEvent>>
implements VplsStore {
    private static final KryoNamespace APP_KRYO = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{Interface.class}).register(new Class[]{VplsData.class}).register(new Class[]{VplsData.VplsState.class}).register(new Class[]{VplsOperation.class}).build();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected NetworkConfigService networkConfigService;
    private EventuallyConsistentMap<String, VplsData> vplsDataStore;
    private EventuallyConsistentMapListener<String, VplsData> vplsDataListener;
    private ApplicationId appId;

    @Activate
    protected void active() {
        this.appId = this.coreService.registerApplication("org.onosproject.vpls");
        this.vplsDataStore = this.storageService.eventuallyConsistentMapBuilder().withName("VPLS-Data").withTimestampProvider((name, vpls) -> new WallClockTimestamp()).withSerializer(APP_KRYO).build();
        this.vplsDataListener = new InternalVplsDataListener(this);
        this.vplsDataStore.addListener(this.vplsDataListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactive() {
        this.vplsDataStore.removeListener(this.vplsDataListener);
        this.networkConfigService.removeConfig((Object)this.appId);
        this.log.info("Stopped");
    }

    public void addVpls(VplsData vplsData) {
        Objects.requireNonNull(vplsData);
        if (vplsData.name().isEmpty()) {
            throw new IllegalArgumentException("VPLS name is empty.");
        }
        vplsData.state(VplsData.VplsState.ADDING);
        this.vplsDataStore.put((Object)vplsData.name(), (Object)vplsData);
    }

    public void removeVpls(VplsData vplsData) {
        Objects.requireNonNull(vplsData);
        if (vplsData.name().isEmpty()) {
            throw new IllegalArgumentException("VPLS name is empty.");
        }
        vplsData.state(VplsData.VplsState.REMOVING);
        if (!this.vplsDataStore.containsKey((Object)vplsData.name())) {
            CompletableFuture.runAsync(() -> {
                VplsStoreEvent event = new VplsStoreEvent(VplsStoreEvent.Type.REMOVE, vplsData);
                this.notifyDelegate((Event)event);
            });
            return;
        }
        this.vplsDataStore.remove((Object)vplsData.name());
    }

    public void updateVpls(VplsData vplsData) {
        switch (1.$SwitchMap$org$onosproject$vpls$api$VplsData$VplsState[vplsData.state().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.vplsDataStore.put((Object)vplsData.name(), (Object)vplsData);
                break;
            }
            default: {
                vplsData.state(VplsData.VplsState.UPDATING);
                this.vplsDataStore.put((Object)vplsData.name(), (Object)vplsData);
            }
        }
    }

    public VplsData getVpls(String vplsName) {
        return (VplsData)this.vplsDataStore.get((Object)vplsName);
    }

    public Collection<VplsData> getAllVpls() {
        return this.vplsDataStore.values();
    }

    public void writeVplsToNetConfig(Collection<VplsData> vplsDataCollection) {
        VplsAppConfig config = (VplsAppConfig)this.networkConfigService.addConfig((Object)this.appId, VplsAppConfig.class);
        if (config == null) {
            this.log.debug("VPLS config is not available now");
            return;
        }
        config.clearVplsConfig();
        WallClockTimestamp ts = new WallClockTimestamp();
        config.updateTime(ts.unixTimestamp());
        vplsDataCollection.forEach(vplsData -> {
            Set interfaceNames = vplsData.interfaces().stream().map(Interface::name).collect(Collectors.toSet());
            VplsConfig vplsConfig = new VplsConfig(vplsData.name(), interfaceNames, vplsData.encapsulationType());
            config.addVpls(vplsConfig);
        });
        this.networkConfigService.applyConfig((Object)this.appId, VplsAppConfig.class, config.node());
    }

    static /* synthetic */ void access$000(DistributedVplsStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$100(DistributedVplsStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }

    static /* synthetic */ void access$200(DistributedVplsStore x0, Event x1) {
        x0.notifyDelegate(x1);
    }
}

