/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.onlab.util.BoundedThreadPool;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.IntentService;
import org.onosproject.vpls.VplsOperationManager;
import org.onosproject.vpls.api.VplsData;
import org.onosproject.vpls.api.VplsOperation;
import org.onosproject.vpls.api.VplsOperationService;
import org.onosproject.vpls.api.VplsStore;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={VplsOperationService.class})
public class VplsOperationManager
implements VplsOperationService {
    private static final int NUM_THREADS = 4;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected VplsStore vplsStore;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Map<String, Deque<VplsOperation>> pendingVplsOperations;
    protected final Map<String, VplsOperation> runningOperations = Maps.newHashMap();
    protected ScheduledExecutorService schedulerExecutor;
    protected ExecutorService workerExecutor;
    protected ApplicationId appId;
    protected boolean isLeader;
    protected NodeId localNodeId;
    protected LeadershipEventListener leadershipEventListener;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.vpls");
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leadershipEventListener = new InternalLeadershipListener(this);
        this.leadershipService.addListener((EventListener)this.leadershipEventListener);
        this.leadershipService.runForLeadership(this.appId.name());
        this.pendingVplsOperations = Maps.newConcurrentMap();
        this.workerExecutor = BoundedThreadPool.newFixedThreadPool((int)4, (ThreadFactory)Tools.groupedThreads((String)"onos/apps/vpls", (String)"worker-%d", (Logger)this.log));
        this.schedulerExecutor = Executors.newScheduledThreadPool(1, Tools.groupedThreads((String)"onos/apps/vpls", (String)"scheduler-%d", (Logger)this.log));
        this.schedulerExecutor.scheduleAtFixedRate((Runnable)new VplsOperationScheduler(this), 0L, 500L, TimeUnit.MILLISECONDS);
    }

    @Deactivate
    public void deactivate() {
        this.pendingVplsOperations.clear();
        this.runningOperations.clear();
        this.leadershipService.removeListener((EventListener)this.leadershipEventListener);
        this.schedulerExecutor.shutdown();
        this.workerExecutor.shutdown();
        Tools.stream((Iterable)this.intentService.getIntents()).filter(intent -> intent.appId().equals(this.appId)).forEach(arg_0 -> ((IntentService)this.intentService).withdraw(arg_0));
    }

    public void submit(VplsOperation vplsOperation) {
        if (this.isLeader) {
            this.addVplsOperation(vplsOperation);
        }
    }

    private void addVplsOperation(VplsOperation vplsOperation) {
        VplsData vplsData = vplsOperation.vpls();
        this.pendingVplsOperations.compute(vplsData.name(), (name, opQueue) -> {
            Deque deque = opQueue = opQueue == null ? Queues.newArrayDeque() : opQueue;
            if (opQueue.contains(vplsOperation)) {
                return opQueue;
            }
            opQueue.add(vplsOperation);
            return opQueue;
        });
    }

    protected static VplsOperation getOptimizedVplsOperation(Deque<VplsOperation> operations) {
        if (operations.isEmpty()) {
            return null;
        }
        if (operations.size() == 1) {
            return operations.getFirst();
        }
        VplsOperation firstOperation = operations.peekFirst();
        VplsOperation lastOperation = operations.peekLast();
        VplsOperation.Operation firstOp = firstOperation.op();
        VplsOperation.Operation lastOp = lastOperation.op();
        if (firstOp.equals((Object)VplsOperation.Operation.REMOVE)) {
            if (lastOp.equals((Object)VplsOperation.Operation.REMOVE)) {
                return firstOperation;
            }
            if (lastOp.equals((Object)VplsOperation.Operation.ADD)) {
                return VplsOperation.of((VplsData)lastOperation.vpls(), (VplsOperation.Operation)VplsOperation.Operation.UPDATE);
            }
            return lastOperation;
        }
        if (firstOp.equals((Object)VplsOperation.Operation.ADD)) {
            if (lastOp.equals((Object)VplsOperation.Operation.REMOVE)) {
                return null;
            }
            if (lastOp.equals((Object)VplsOperation.Operation.ADD)) {
                return VplsOperation.of((VplsData)lastOperation.vpls(), (VplsOperation.Operation)VplsOperation.Operation.ADD);
            }
            return VplsOperation.of((VplsData)lastOperation.vpls(), (VplsOperation.Operation)VplsOperation.Operation.ADD);
        }
        if (lastOp.equals((Object)VplsOperation.Operation.REMOVE)) {
            return lastOperation;
        }
        if (lastOp.equals((Object)VplsOperation.Operation.ADD)) {
            return VplsOperation.of((VplsData)lastOperation.vpls(), (VplsOperation.Operation)VplsOperation.Operation.UPDATE);
        }
        return VplsOperation.of((VplsData)lastOperation.vpls(), (VplsOperation.Operation)VplsOperation.Operation.UPDATE);
    }
}

