/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.intf.Interface;
import org.onosproject.vpls.api.VplsData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class VplsCodec
extends JsonCodec<VplsData> {
    private static final String NAME = "name";
    private static final String ENCAPSULATION_TYPE = "encapsulation";
    private static final String INTERFACES = "interfaces";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ObjectNode encode(VplsData vplsData, CodecContext context) {
        Preconditions.checkNotNull((Object)vplsData, (Object)"Vpls cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put("name", vplsData.name()).put("encapsulation", vplsData.encapsulationType().toString());
        ArrayNode interfaces = context.mapper().createArrayNode();
        vplsData.interfaces().forEach(interf -> {
            ObjectNode bandJson = context.codec(Interface.class).encode(interf, context);
            interfaces.add((JsonNode)bandJson);
        });
        result.set("interfaces", (JsonNode)interfaces);
        return result;
    }

    public VplsData decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        ArrayList names = new ArrayList();
        json.findValues("name").forEach(jsonNode -> names.add(jsonNode.asText()));
        ArrayList interfaceList = new ArrayList();
        JsonNode interfacesJeson = json.findValue("interfaces");
        JsonCodec interfaceCodec = context.codec(Interface.class);
        if (interfacesJeson != null) {
            IntStream.range(0, interfacesJeson.size()).forEach(i -> interfaceList.add((Interface)interfaceCodec.decode(VplsCodec.get((JsonNode)interfacesJeson, (int)i), context)));
        }
        interfaceList.forEach(interf -> names.remove(interf.name()));
        String vplsName = (String)names.get(0);
        EncapsulationType encap = json.findValue("encapsulation") == null ? null : EncapsulationType.enumFromString((String)json.findValue("encapsulation").asText());
        VplsData vplsData = VplsData.of((String)vplsName, (EncapsulationType)encap);
        vplsData.addInterfaces(interfaceList);
        return vplsData;
    }
}

