/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.JsonCodec;
import org.onosproject.event.EventListener;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intf.Interface;
import org.onosproject.net.intf.InterfaceService;
import org.onosproject.store.StoreDelegate;
import org.onosproject.vpls.VplsManager;
import org.onosproject.vpls.api.Vpls;
import org.onosproject.vpls.api.VplsData;
import org.onosproject.vpls.api.VplsOperationService;
import org.onosproject.vpls.api.VplsStore;
import org.onosproject.vpls.rest.VplsCodec;
import org.onosproject.vpls.store.VplsStoreEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Vpls.class})
public class VplsManager
implements Vpls {
    public static final String VPLS_APP = "org.onosproject.vpls";
    private static final String UNSUPPORTED_STORE_EVENT_TYPE = "Unsupported store event type {}.";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected VplsStore vplsStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected VplsOperationService operationService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected CodecService codecService;
    private StoreDelegate<VplsStoreEvent> vplsStoreDelegate;
    private HostListener vplsHostListener;

    @Activate
    public void activate() {
        this.vplsStoreDelegate = new VplsStoreDelegate(this);
        this.vplsHostListener = new VplsHostListener(this);
        this.vplsStore.setDelegate(this.vplsStoreDelegate);
        this.hostService.addListener((EventListener)this.vplsHostListener);
        this.codecService.registerCodec(VplsData.class, (JsonCodec)new VplsCodec());
    }

    @Deactivate
    public void deactivate() {
        this.vplsStore.unsetDelegate(this.vplsStoreDelegate);
        this.hostService.removeListener((EventListener)this.vplsHostListener);
        this.codecService.unregisterCodec(VplsData.class);
    }

    public VplsData createVpls(String vplsName, EncapsulationType encapsulationType) {
        Objects.requireNonNull(vplsName);
        Objects.requireNonNull(encapsulationType);
        if (this.vplsStore.getVpls(vplsName) != null) {
            return null;
        }
        VplsData vplsData = VplsData.of((String)vplsName, (EncapsulationType)encapsulationType);
        this.vplsStore.addVpls(vplsData);
        return vplsData;
    }

    public VplsData removeVpls(VplsData vplsData) {
        Objects.requireNonNull(vplsData);
        VplsData newData = VplsData.of((VplsData)vplsData);
        newData.state(VplsData.VplsState.REMOVING);
        this.vplsStore.removeVpls(vplsData);
        return vplsData;
    }

    public void addInterfaces(VplsData vplsData, Collection<Interface> interfaces) {
        Objects.requireNonNull(vplsData);
        Objects.requireNonNull(interfaces);
        VplsData newData = VplsData.of((VplsData)vplsData);
        newData.addInterfaces(interfaces);
        this.updateVplsStatus(newData, VplsData.VplsState.UPDATING);
    }

    public void addInterface(VplsData vplsData, Interface iface) {
        Objects.requireNonNull(vplsData);
        Objects.requireNonNull(iface);
        VplsData newData = VplsData.of((VplsData)vplsData);
        newData.addInterface(iface);
        this.updateVplsStatus(newData, VplsData.VplsState.UPDATING);
    }

    public void setEncapsulationType(VplsData vplsData, EncapsulationType encapsulationType) {
        Objects.requireNonNull(vplsData);
        Objects.requireNonNull(encapsulationType);
        VplsData newData = VplsData.of((VplsData)vplsData);
        if (newData.encapsulationType().equals((Object)encapsulationType)) {
            return;
        }
        newData.encapsulationType(encapsulationType);
        this.updateVplsStatus(newData, VplsData.VplsState.UPDATING);
    }

    public VplsData getVpls(String vplsName) {
        Objects.requireNonNull(vplsName);
        return this.vplsStore.getVpls(vplsName);
    }

    public Collection<Interface> removeInterfaces(VplsData vplsData, Collection<Interface> interfaces) {
        Objects.requireNonNull(vplsData);
        Objects.requireNonNull(interfaces);
        VplsData newData = VplsData.of((VplsData)vplsData);
        newData.removeInterfaces(interfaces);
        this.updateVplsStatus(newData, VplsData.VplsState.UPDATING);
        return interfaces;
    }

    public Interface removeInterface(VplsData vplsData, Interface iface) {
        Objects.requireNonNull(vplsData);
        Objects.requireNonNull(iface);
        VplsData newData = VplsData.of((VplsData)vplsData);
        newData.removeInterface(iface);
        this.updateVplsStatus(newData, VplsData.VplsState.UPDATING);
        return iface;
    }

    public void removeAllVpls() {
        ImmutableSet allVplses = ImmutableSet.copyOf((Collection)this.vplsStore.getAllVpls());
        allVplses.forEach(arg_0 -> this.removeVpls(arg_0));
    }

    public Collection<VplsData> getAllVpls() {
        return ImmutableSet.copyOf((Collection)this.vplsStore.getAllVpls());
    }

    private void updateVplsStatus(VplsData vplsData, VplsData.VplsState vplsState) {
        vplsData.state(vplsState);
        this.vplsStore.updateVpls(vplsData);
    }
}

