/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intf.Interface;
import org.onosproject.net.intf.InterfaceService;
import org.onosproject.net.neighbour.NeighbourMessageContext;
import org.onosproject.net.neighbour.NeighbourMessageHandler;
import org.onosproject.net.neighbour.NeighbourResolutionService;
import org.onosproject.vpls.VplsNeighbourHandler;
import org.onosproject.vpls.api.VplsData;
import org.onosproject.vpls.api.VplsStore;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class VplsNeighbourHandler {
    private static final String UNKNOWN_CONTEXT = "Unknown context type: {}";
    private static final String CAN_NOT_FIND_VPLS = "Cannot find VPLS for port {} with VLAN Id {}.";
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected NeighbourResolutionService neighbourService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected VplsStore vplsStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected NetworkConfigService configService;
    private VplsInterfaceListener interfaceListener = new VplsInterfaceListener(this);
    protected VplsNeighbourMessageHandler neighbourHandler = new VplsNeighbourMessageHandler(this);
    protected VplsConfigListener configListener = new VplsConfigListener(this);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationId appId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.vpls");
        this.interfaceService.addListener((EventListener)this.interfaceListener);
        this.configService.addListener((EventListener)this.configListener);
        this.configNeighbourHandler();
    }

    @Deactivate
    protected void deactivate() {
        this.interfaceService.removeListener((EventListener)this.interfaceListener);
        this.configService.removeListener((EventListener)this.configListener);
        this.neighbourService.unregisterNeighbourHandlers(this.appId);
    }

    protected void configNeighbourHandler() {
        this.neighbourService.unregisterNeighbourHandlers(this.appId);
        this.interfaceService.getInterfaces().forEach(intf -> this.neighbourService.registerNeighbourHandler(intf, (NeighbourMessageHandler)this.neighbourHandler, this.appId));
    }

    protected void handleRequest(NeighbourMessageContext context) {
        VplsData vplsData = this.findVpls(context);
        if (vplsData != null) {
            vplsData.interfaces().stream().filter(intf -> !context.inPort().equals((Object)intf.connectPoint())).forEach(arg_0 -> ((NeighbourMessageContext)context).forward(arg_0));
        } else {
            this.log.warn(CAN_NOT_FIND_VPLS, (Object)context.inPort(), (Object)context.vlan());
            context.drop();
        }
    }

    protected void handleReply(NeighbourMessageContext context, HostService hostService) {
        VplsData vplsData = this.findVpls(context);
        if (vplsData != null) {
            MacAddress dstMac = context.dstMac();
            Set hosts = hostService.getHostsByMac(dstMac);
            hosts = hosts.stream().filter(host -> vplsData.interfaces().contains(this.getHostInterface(host))).collect(Collectors.toSet());
            hosts.stream().map(arg_0 -> this.getHostInterface(arg_0)).filter(Objects::nonNull).forEach(arg_0 -> ((NeighbourMessageContext)context).forward(arg_0));
        } else {
            this.log.warn(CAN_NOT_FIND_VPLS, (Object)context.inPort(), (Object)context.vlan());
            context.drop();
        }
    }

    private VplsData findVpls(NeighbourMessageContext context) {
        Collection vplses = this.vplsStore.getAllVpls();
        for (VplsData vplsData : vplses) {
            Set interfaces = vplsData.interfaces();
            ConnectPoint port = context.inPort();
            VlanId vlanId = context.vlan();
            boolean match = interfaces.stream().anyMatch(iface -> iface.connectPoint().equals((Object)port) && iface.vlan().equals((Object)vlanId));
            if (!match) continue;
            return vplsData;
        }
        return null;
    }

    private Interface getHostInterface(Host host) {
        Set interfaces = this.interfaceService.getInterfaces();
        return interfaces.stream().filter(iface -> iface.connectPoint().equals((Object)host.location()) && iface.vlan().equals((Object)host.vlan())).findFirst().orElse(null);
    }
}

