/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.onosproject.net.EncapsulationType;

public class VplsConfig {
    private final String name;
    private final Set<String> ifaces;
    private final EncapsulationType encap;

    public VplsConfig(String name, Set<String> ifaces, EncapsulationType encap) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.ifaces = (Set)Preconditions.checkNotNull((Object)ImmutableSet.copyOf(ifaces));
        this.encap = (EncapsulationType)Preconditions.checkNotNull((Object)encap);
    }

    public String name() {
        return this.name;
    }

    public Set<String> ifaces() {
        return ImmutableSet.copyOf((Collection)this.ifaces);
    }

    public EncapsulationType encap() {
        return this.encap;
    }

    protected boolean isAttached(String iface) {
        return this.ifaces.stream().anyMatch(iface::equals);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VplsConfig) {
            VplsConfig that = (VplsConfig)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.ifaces, that.ifaces) && Objects.equals(this.encap, that.encap);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ifaces, this.encap);
    }
}

