/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intf.Interface;
import org.onosproject.net.intf.InterfaceAdminService;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.vpls.api.Vpls;
import org.onosproject.vpls.api.VplsData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="vpls")
public class VplsWebResource
extends AbstractWebResource {
    @Context
    private UriInfo uriInfo;
    private static final String VPLS_NOT_FOUND = "Vpls is not found for ";
    private static final String DEVICE_NOT_FOUND = "Device is not found for ";
    private static final String PORT_NOT_FOUND = "Port is not found for ";
    private static final String VPLSS = "vplss";
    private static final String VPLS = "vpls";
    private static final String INTERFACES = "interfaces";
    private static final String INTERFACES_KEY_ERROR = "No interfaces";
    private final ObjectNode root = this.mapper().createObjectNode();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @GET
    @Produces(value={"application/json"})
    public Response getVplss() {
        ArrayNode vplssNode = this.root.putArray("vplss");
        Vpls service = (Vpls)this.get(Vpls.class);
        Collection vplsDatas = service.getAllVpls();
        if (!vplsDatas.isEmpty()) {
            for (VplsData entry : vplsDatas) {
                vplssNode.add((JsonNode)this.codec(VplsData.class).encode((Object)entry, (CodecContext)this));
            }
        }
        return VplsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{vplsName}")
    public Response getVpls(@PathParam(value="vplsName") String vplsName) {
        ArrayNode vplsNode = this.root.putArray("vpls");
        Vpls service = (Vpls)this.get(Vpls.class);
        VplsData vplsData = (VplsData)Tools.nullIsNotFound((Object)service.getVpls(vplsName), (String)("Vpls is not found for " + vplsName));
        vplsNode.add((JsonNode)this.codec(VplsData.class).encode((Object)vplsData, (CodecContext)this));
        return VplsWebResource.ok((Object)this.root).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createVpls(InputStream stream) {
        Vpls service = (Vpls)this.get(Vpls.class);
        DeviceService deviceService = (DeviceService)this.get(DeviceService.class);
        InterfaceAdminService interfaceService = (InterfaceAdminService)this.get(InterfaceAdminService.class);
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            VplsData vplsData = (VplsData)this.codec(VplsData.class).decode(jsonTree, (CodecContext)this);
            vplsData.interfaces().forEach(interf -> {
                Tools.nullIsNotFound((Object)deviceService.getDevice(interf.connectPoint().deviceId()), (String)("Device is not found for " + interf.connectPoint().deviceId()));
                Tools.nullIsNotFound((Object)deviceService.getPort(interf.connectPoint()), (String)("Port is not found for " + interf.connectPoint().port()));
                interfaceService.add(interf);
            });
            service.addInterfaces(vplsData, (Collection)vplsData.interfaces());
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("vpls");
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @POST
    @Path(value="interfaces/{vplsName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addInterfaces(@PathParam(value="vplsName") String vplsName, InputStream stream) {
        Vpls service = (Vpls)this.get(Vpls.class);
        DeviceService deviceService = (DeviceService)this.get(DeviceService.class);
        InterfaceAdminService interfaceService = (InterfaceAdminService)this.get(InterfaceAdminService.class);
        VplsData vplsData = (VplsData)Tools.nullIsNotFound((Object)service.getVpls(vplsName), (String)("Vpls is not found for " + vplsName));
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            ArrayNode routesArray = (ArrayNode)Tools.nullIsIllegal((Object)((ArrayNode)jsonTree.get("interfaces")), (String)"No interfaces");
            ArrayList interfaceList = new ArrayList();
            routesArray.forEach(interfJson -> {
                Interface inter = (Interface)this.codec(Interface.class).decode((ObjectNode)interfJson, (CodecContext)this);
                Tools.nullIsNotFound((Object)deviceService.getDevice(inter.connectPoint().deviceId()), (String)("Device is not found for " + inter.connectPoint().deviceId()));
                Tools.nullIsNotFound((Object)deviceService.getPort(inter.connectPoint()), (String)("Port is not found for " + inter.connectPoint().port()));
                interfaceList.add(inter);
                interfaceService.add(inter);
            });
            service.addInterfaces(vplsData, interfaceList);
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("interfaces").path(vplsName);
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @DELETE
    @Path(value="{vplsName}")
    public Response deleteVpls(@PathParam(value="vplsName") String vplsName) {
        Vpls service = (Vpls)this.get(Vpls.class);
        VplsData vplsData = (VplsData)Tools.nullIsNotFound((Object)service.getVpls(vplsName), (String)("Vpls is not found for " + vplsName));
        service.removeVpls(vplsData);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="interface/{vplsName}/{interfaceName}")
    public Response deleteInterface(@PathParam(value="vplsName") String vplsName, @PathParam(value="interfaceName") String interfaceName) {
        Vpls service = (Vpls)this.get(Vpls.class);
        InterfaceAdminService interfaceService = (InterfaceAdminService)this.get(InterfaceAdminService.class);
        VplsData vplsData = (VplsData)Tools.nullIsNotFound((Object)service.getVpls(vplsName), (String)("Vpls is not found for " + vplsName));
        vplsData.interfaces().forEach(anInterface -> {
            if (anInterface.name().equals(interfaceName)) {
                interfaceService.remove(anInterface.connectPoint(), anInterface.name());
                service.removeInterface(vplsData, anInterface);
            }
        });
        return Response.noContent().build();
    }
}

