/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.sfc.installer.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.HostLocation;
import org.onosproject.net.NshServicePathId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.FlowObjectiveServiceAdapter;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.HostServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.sfc.installer.impl.SfcFlowRuleInstallerImpl;
import org.onosproject.sfc.util.FlowClassifierAdapter;
import org.onosproject.sfc.util.MockDriverHandler;
import org.onosproject.sfc.util.PortPairAdapter;
import org.onosproject.sfc.util.PortPairGroupAdapter;
import org.onosproject.sfc.util.TenantNetworkAdapter;
import org.onosproject.sfc.util.VirtualPortAdapter;
import org.onosproject.sfc.util.VtnRscAdapter;
import org.onosproject.vtnrsc.AllowedAddressPair;
import org.onosproject.vtnrsc.BindingHostId;
import org.onosproject.vtnrsc.DefaultFiveTuple;
import org.onosproject.vtnrsc.DefaultFlowClassifier;
import org.onosproject.vtnrsc.DefaultPortChain;
import org.onosproject.vtnrsc.DefaultPortPair;
import org.onosproject.vtnrsc.DefaultPortPairGroup;
import org.onosproject.vtnrsc.DefaultTenantNetwork;
import org.onosproject.vtnrsc.DefaultVirtualPort;
import org.onosproject.vtnrsc.FiveTuple;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.LoadBalanceId;
import org.onosproject.vtnrsc.PhysicalNetwork;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.SegmentationId;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetwork;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierService;
import org.onosproject.vtnrsc.portpair.PortPairService;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupService;
import org.onosproject.vtnrsc.service.VtnRscService;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;

public class SfcFlowRuleInstallerImplTest {
    FlowObjectiveService flowObjectiveService = new FlowObjectiveServiceAdapter();
    DeviceService deviceService = new DeviceServiceAdapter(this.createPortList());
    HostService hostService = new HostServiceAdapter();
    VirtualPortService virtualPortService = new VirtualPortAdapter();
    VtnRscService vtnRscService = new VtnRscAdapter();
    PortPairService portPairService = new PortPairAdapter();
    PortPairGroupService portPairGroupService = new PortPairGroupAdapter();
    FlowClassifierService flowClassifierService = new FlowClassifierAdapter();
    TenantNetworkService tenantNetworkService = new TenantNetworkAdapter();
    final DriverService driverService = (DriverService)EasyMock.createMock(DriverService.class);
    private final String networkIdStr = "123";
    final PortChainId portChainId = PortChainId.of((String)"78888888-fc23-aeb6-f44b-56dc5e2fb3ae");
    final TenantId tenantId = TenantId.tenantId((String)"1");
    final String name = "PortChain";
    final String description = "PortChain";
    final List<PortPairGroupId> portPairGroups = new LinkedList<PortPairGroupId>();
    final List<FlowClassifierId> flowClassifiers = new LinkedList<FlowClassifierId>();
    PortPairGroupId portPairGroupId1 = PortPairGroupId.of((String)"73333333-fc23-aeb6-f44b-56dc5e2fb3ae");
    PortPairGroupId portPairGroupId2 = PortPairGroupId.of((String)"73343531-fc23-aeb6-f44b-56dc5e2fb3af");
    PortPairId portPairId1 = PortPairId.of((String)"73333333-fc23-aeb6-f44b-56dc5e2fb3ae");
    PortPairId portPairId2 = PortPairId.of((String)"74444444-fc23-aeb6-f44b-56dc5e2fb3ae");
    FlowClassifierId flowClassifierId1 = FlowClassifierId.of((String)"74444444-fc23-aeb6-f44b-56dc5e2fb3ae");
    FlowClassifierId flowClassifierId2 = FlowClassifierId.of((String)"74444444-fc23-aeb6-f44b-56dc5e2fb3af");
    final String ppName = "PortPair";
    final String ppDescription = "PortPair";
    final String ingress = "d3333333-24fc-4fae-af4b-321c5e2eb3d1";
    final String egress = "a4444444-4a56-2a6e-cd3a-9dee4e2ec345";
    final String ppgName = "PortPairGroup";
    final String ppgDescription = "PortPairGroup";
    final List<PortPairId> portPairList = new LinkedList<PortPairId>();
    VirtualPortId id1 = VirtualPortId.portId((String)"d3333333-24fc-4fae-af4b-321c5e2eb3d1");
    VirtualPortId id2 = VirtualPortId.portId((String)"3414");
    DeviceId deviceId = DeviceId.deviceId((String)"of:000000000000001");
    final DriverHandler driverHandler = new MockDriverHandler();

    private List<Port> createPortList() {
        ArrayList portList = Lists.newArrayList();
        long sp1 = 1000000L;
        ProviderId pid = new ProviderId("of", "foo");
        ChassisId cid = new ChassisId();
        DefaultDevice device = new DefaultDevice(pid, this.deviceId, Device.Type.SWITCH, "whitebox", "1.1.x", "3.9.1", "43311-12345", cid, new Annotations[0]);
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("portName", "vxlan-0.0.0.0").build();
        DefaultPort p1 = new DefaultPort((Element)device, PortNumber.ANY, true, Port.Type.COPPER, sp1, new Annotations[]{annotations});
        portList.add(p1);
        return portList;
    }

    private PortPair createPortPair(PortPairId ppId) {
        DefaultPortPair.Builder portPairBuilder = new DefaultPortPair.Builder();
        PortPair portPair = portPairBuilder.setId(ppId).setName("PortPair").setTenantId(this.tenantId).setDescription("PortPair").setIngress("d3333333-24fc-4fae-af4b-321c5e2eb3d1").setEgress("a4444444-4a56-2a6e-cd3a-9dee4e2ec345").build();
        return portPair;
    }

    private PortPairGroup createPortPairGroup(PortPairGroupId ppgId) {
        this.portPairList.clear();
        this.portPairList.add(this.portPairId1);
        this.portPairList.add(this.portPairId2);
        DefaultPortPairGroup.Builder portPairGroupBuilder = new DefaultPortPairGroup.Builder();
        PortPairGroup portPairGroup = portPairGroupBuilder.setId(ppgId).setTenantId(this.tenantId).setName("PortPairGroup").setDescription("PortPairGroup").setPortPairs(this.portPairList).build();
        return portPairGroup;
    }

    private PortChain createPortChain() {
        this.portPairGroups.clear();
        this.flowClassifiers.clear();
        this.portPairGroups.add(this.portPairGroupId1);
        this.portPairGroups.add(this.portPairGroupId2);
        this.flowClassifiers.add(this.flowClassifierId1);
        this.flowClassifiers.add(this.flowClassifierId2);
        DefaultPortChain.Builder portChainBuilder = new DefaultPortChain.Builder();
        PortChain portChain = portChainBuilder.setId(this.portChainId).setTenantId(this.tenantId).setName("PortChain").setDescription("PortChain").setPortPairGroups(this.portPairGroups).setFlowClassifiers(this.flowClassifiers).build();
        return portChain;
    }

    private FlowClassifier createFlowClassifier(FlowClassifierId id) {
        String name = "FlowClassifier1";
        String description = "FlowClassifier1";
        String ethType = "IPv4";
        String protocol = "tcp";
        int minSrcPortRange = 5;
        int maxSrcPortRange = 10;
        int minDstPortRange = 5;
        int maxDstPortRange = 10;
        TenantId tenantId = TenantId.tenantId((String)"1");
        IpPrefix srcIpPrefix = IpPrefix.valueOf((String)"0.0.0.0/0");
        IpPrefix dstIpPrefix = IpPrefix.valueOf((String)"10.10.10.10/0");
        VirtualPortId virtualSrcPort = this.id1;
        VirtualPortId virtualDstPort = this.id2;
        DefaultFlowClassifier.Builder flowClassifierBuilder = new DefaultFlowClassifier.Builder();
        FlowClassifier flowClassifier = flowClassifierBuilder.setFlowClassifierId(id).setTenantId(tenantId).setName("FlowClassifier1").setDescription("FlowClassifier1").setEtherType("IPv4").setProtocol("tcp").setMinSrcPortRange(5).setMaxSrcPortRange(10).setMinDstPortRange(5).setMaxDstPortRange(10).setSrcIpPrefix(srcIpPrefix).setDstIpPrefix(dstIpPrefix).setSrcPort(virtualSrcPort).setDstPort(virtualDstPort).build();
        return flowClassifier;
    }

    private VirtualPort createVirtualPort(VirtualPortId id) {
        HashSet securityGroups = Sets.newHashSet();
        String macAddressStr = "fa:12:3e:56:ee:a2";
        String ipAddress = "10.1.1.1";
        String subnet = "1212";
        String hostIdStr = "fa:e2:3e:56:ee:a2";
        String deviceOwner = "james";
        HashMap propertyMap = Maps.newHashMap();
        propertyMap.putIfAbsent("deviceOwner", deviceOwner);
        TenantNetworkId networkId = TenantNetworkId.networkId((String)"123");
        MacAddress macAddress = MacAddress.valueOf((String)macAddressStr);
        BindingHostId bindingHostId = BindingHostId.bindingHostId((String)hostIdStr);
        FixedIp fixedIp = FixedIp.fixedIp((SubnetId)SubnetId.subnetId((String)subnet), (IpAddress)IpAddress.valueOf((String)ipAddress));
        HashSet fixedIps = Sets.newHashSet();
        fixedIps.add(fixedIp);
        HashSet allowedAddressPairs = Sets.newHashSet();
        AllowedAddressPair allowedAddressPair = AllowedAddressPair.allowedAddressPair((IpAddress)IpAddress.valueOf((String)ipAddress), (MacAddress)MacAddress.valueOf((String)macAddressStr));
        allowedAddressPairs.add(allowedAddressPair);
        DefaultVirtualPort d1 = new DefaultVirtualPort(id, networkId, Boolean.valueOf(true), (Map)propertyMap, VirtualPort.State.ACTIVE, macAddress, this.tenantId, this.deviceId, (Set)fixedIps, bindingHostId, (Set)allowedAddressPairs, (Set)securityGroups);
        return d1;
    }

    @Test
    public void testInstallFlowClassifier() {
        DefaultApplicationId appId = new DefaultApplicationId(1, "test");
        SfcFlowRuleInstallerImpl flowClassifierInstaller = new SfcFlowRuleInstallerImpl();
        flowClassifierInstaller.virtualPortService = this.virtualPortService;
        flowClassifierInstaller.vtnRscService = this.vtnRscService;
        flowClassifierInstaller.portPairService = this.portPairService;
        flowClassifierInstaller.portPairGroupService = this.portPairGroupService;
        flowClassifierInstaller.flowClassifierService = this.flowClassifierService;
        flowClassifierInstaller.driverService = this.driverService;
        flowClassifierInstaller.deviceService = this.deviceService;
        flowClassifierInstaller.hostService = this.hostService;
        flowClassifierInstaller.flowObjectiveService = this.flowObjectiveService;
        flowClassifierInstaller.appId = appId;
        PortChain portChain = this.createPortChain();
        NshServicePathId nshSpiId = NshServicePathId.of((int)10);
        this.portPairGroupService.createPortPairGroup(this.createPortPairGroup(this.portPairGroupId1));
        this.portPairGroupService.createPortPairGroup(this.createPortPairGroup(this.portPairGroupId2));
        this.portPairService.createPortPair(this.createPortPair(this.portPairId1));
        this.portPairService.createPortPair(this.createPortPair(this.portPairId2));
        FlowClassifier fc1 = this.createFlowClassifier(this.flowClassifierId1);
        FlowClassifier fc2 = this.createFlowClassifier(this.flowClassifierId2);
        this.flowClassifierService.createFlowClassifier(fc1);
        this.flowClassifierService.createFlowClassifier(fc2);
        ArrayList virtualPortList = Lists.newArrayList();
        virtualPortList.add(this.createVirtualPort(VirtualPortId.portId((String)"d3333333-24fc-4fae-af4b-321c5e2eb3d1")));
        this.virtualPortService.createPorts((Iterable)virtualPortList);
        EasyMock.expect((Object)this.driverService.createHandler(this.deviceId, new String[0])).andReturn((Object)this.driverHandler).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.driverService});
        ConnectPoint connectPoint = flowClassifierInstaller.installFlowClassifier(portChain, nshSpiId);
        Assert.assertThat((Object)connectPoint, (Matcher)Matchers.is((Object)HostLocation.NONE));
    }

    @Test
    public void testInstallLoadBalancedFlowRules() {
        DefaultApplicationId appId = new DefaultApplicationId(1, "test");
        SfcFlowRuleInstallerImpl flowRuleInstaller = new SfcFlowRuleInstallerImpl();
        flowRuleInstaller.virtualPortService = this.virtualPortService;
        flowRuleInstaller.vtnRscService = this.vtnRscService;
        flowRuleInstaller.portPairService = this.portPairService;
        flowRuleInstaller.portPairGroupService = this.portPairGroupService;
        flowRuleInstaller.flowClassifierService = this.flowClassifierService;
        flowRuleInstaller.driverService = this.driverService;
        flowRuleInstaller.deviceService = this.deviceService;
        flowRuleInstaller.hostService = this.hostService;
        flowRuleInstaller.flowObjectiveService = this.flowObjectiveService;
        flowRuleInstaller.tenantNetworkService = this.tenantNetworkService;
        flowRuleInstaller.appId = appId;
        PortChain portChain = this.createPortChain();
        String ppName1 = "PortPair1";
        String ppDescription1 = "PortPair1";
        String ingress1 = "d3333333-24fc-4fae-af4b-321c5e2eb3d1";
        String egress1 = "a4444444-4a56-2a6e-cd3a-9dee4e2ec345";
        DefaultPortPair.Builder portPairBuilder = new DefaultPortPair.Builder();
        PortPair portPair1 = portPairBuilder.setId(this.portPairId1).setName("PortPair1").setTenantId(this.tenantId).setDescription("PortPair1").setIngress("d3333333-24fc-4fae-af4b-321c5e2eb3d1").setEgress("a4444444-4a56-2a6e-cd3a-9dee4e2ec345").build();
        String ppName2 = "PortPair2";
        String ppDescription2 = "PortPair2";
        String ingress2 = "d5555555-24fc-4fae-af4b-321c5e2eb3d1";
        String egress2 = "a6666666-4a56-2a6e-cd3a-9dee4e2ec345";
        PortPair portPair2 = portPairBuilder.setId(this.portPairId2).setName("PortPair2").setTenantId(this.tenantId).setDescription("PortPair2").setIngress("d5555555-24fc-4fae-af4b-321c5e2eb3d1").setEgress("a6666666-4a56-2a6e-cd3a-9dee4e2ec345").build();
        this.portPairService.createPortPair(portPair1);
        this.portPairService.createPortPair(portPair2);
        FlowClassifier fc1 = this.createFlowClassifier(this.flowClassifierId1);
        FlowClassifier fc2 = this.createFlowClassifier(this.flowClassifierId2);
        this.flowClassifierService.createFlowClassifier(fc1);
        this.flowClassifierService.createFlowClassifier(fc2);
        NshServicePathId nshSpiId = NshServicePathId.of((int)10);
        FiveTuple fiveTuple = DefaultFiveTuple.builder().setIpSrc(IpAddress.valueOf((String)"3.3.3.3")).setIpDst(IpAddress.valueOf((String)"4.4.4.4")).setPortSrc(PortNumber.portNumber((long)1500L)).setPortDst(PortNumber.portNumber((long)2000L)).setProtocol((byte)17).setTenantId(TenantId.tenantId((String)"bbb")).build();
        LoadBalanceId id = LoadBalanceId.of((byte)1);
        ArrayList path = Lists.newArrayList();
        path.add(this.portPairId1);
        path.add(this.portPairId2);
        ArrayList virtualPortList = Lists.newArrayList();
        virtualPortList.add(this.createVirtualPort(VirtualPortId.portId((String)"d3333333-24fc-4fae-af4b-321c5e2eb3d1")));
        virtualPortList.add(this.createVirtualPort(VirtualPortId.portId((String)"a4444444-4a56-2a6e-cd3a-9dee4e2ec345")));
        virtualPortList.add(this.createVirtualPort(VirtualPortId.portId((String)"d5555555-24fc-4fae-af4b-321c5e2eb3d1")));
        virtualPortList.add(this.createVirtualPort(VirtualPortId.portId((String)"a6666666-4a56-2a6e-cd3a-9dee4e2ec345")));
        this.virtualPortService.createPorts((Iterable)virtualPortList);
        portChain.addLoadBalancePath(fiveTuple, id, (List)path);
        String physicalNetworkStr = "1234";
        String segmentationIdStr = "1";
        SegmentationId segmentationID = SegmentationId.segmentationId((String)segmentationIdStr);
        TenantNetworkId networkid1 = TenantNetworkId.networkId((String)"123");
        PhysicalNetwork physicalNetwork = PhysicalNetwork.physicalNetwork((String)physicalNetworkStr);
        DefaultTenantNetwork p1 = new DefaultTenantNetwork(networkid1, "PortChain", false, TenantNetwork.State.ACTIVE, false, this.tenantId, false, TenantNetwork.Type.LOCAL, physicalNetwork, segmentationID);
        this.tenantNetworkService.createNetworks(Collections.singletonList(p1));
        EasyMock.expect((Object)this.driverService.createHandler(this.deviceId, new String[0])).andReturn((Object)this.driverHandler).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.driverService});
        flowRuleInstaller.installLoadBalancedFlowRules(portChain, fiveTuple, nshSpiId);
        ForwardingObjective forObj = ((FlowObjectiveServiceAdapter)this.flowObjectiveService).forwardingObjective();
        Assert.assertThat((Object)forObj.selector().getCriterion(Criterion.Type.IN_PORT), (Matcher)Matchers.instanceOf(PortCriterion.class));
        List instructions = forObj.treatment().allInstructions();
        for (Instruction instruction : instructions) {
            if (instruction.type() != Instruction.Type.OUTPUT) continue;
            Assert.assertThat((Object)((Instructions.OutputInstruction)instruction).port(), (Matcher)Matchers.is((Object)PortNumber.P0));
        }
    }
}

