/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.sfc.util;

import com.google.common.collect.ImmutableList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierListener;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierService;

public class FlowClassifierAdapter
implements FlowClassifierService {
    private final ConcurrentMap<FlowClassifierId, FlowClassifier> flowClassifierStore = new ConcurrentHashMap<FlowClassifierId, FlowClassifier>();

    public boolean exists(FlowClassifierId id) {
        return this.flowClassifierStore.containsKey(id);
    }

    public int getFlowClassifierCount() {
        return this.flowClassifierStore.size();
    }

    public Iterable<FlowClassifier> getFlowClassifiers() {
        return ImmutableList.copyOf(this.flowClassifierStore.values());
    }

    public FlowClassifier getFlowClassifier(FlowClassifierId id) {
        return (FlowClassifier)this.flowClassifierStore.get(id);
    }

    public boolean createFlowClassifier(FlowClassifier flowClassifier) {
        FlowClassifierId id = flowClassifier.flowClassifierId();
        this.flowClassifierStore.put(id, flowClassifier);
        return this.flowClassifierStore.containsKey(id);
    }

    public boolean updateFlowClassifier(FlowClassifier flowClassifier) {
        if (!this.flowClassifierStore.containsKey(flowClassifier.flowClassifierId())) {
            return false;
        }
        this.flowClassifierStore.put(flowClassifier.flowClassifierId(), flowClassifier);
        return flowClassifier.equals(this.flowClassifierStore.get(flowClassifier.flowClassifierId()));
    }

    public boolean removeFlowClassifier(FlowClassifierId id) {
        return true;
    }

    public void addListener(FlowClassifierListener listener) {
    }

    public void removeListener(FlowClassifierListener listener) {
    }
}

