/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.sfc.util;

import com.google.common.collect.ImmutableList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.onosproject.vtnrsc.TenantNetwork;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;

public class TenantNetworkAdapter
implements TenantNetworkService {
    private final ConcurrentMap<TenantNetworkId, TenantNetwork> tenantNetworkStore = new ConcurrentHashMap<TenantNetworkId, TenantNetwork>();

    public boolean exists(TenantNetworkId networkId) {
        return this.tenantNetworkStore.containsKey(networkId);
    }

    public int getNetworkCount() {
        return this.tenantNetworkStore.size();
    }

    public Iterable<TenantNetwork> getNetworks() {
        return ImmutableList.copyOf(this.tenantNetworkStore.values());
    }

    public TenantNetwork getNetwork(TenantNetworkId networkId) {
        return (TenantNetwork)this.tenantNetworkStore.get(networkId);
    }

    public boolean createNetworks(Iterable<TenantNetwork> networks) {
        for (TenantNetwork network : networks) {
            this.tenantNetworkStore.put(network.id(), network);
            if (this.tenantNetworkStore.containsKey(network.id())) continue;
            return false;
        }
        return true;
    }

    public boolean updateNetworks(Iterable<TenantNetwork> networks) {
        return false;
    }

    public boolean removeNetworks(Iterable<TenantNetworkId> networksIds) {
        return false;
    }
}

