/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.sfc.manager.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.UUID;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPv4;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TCP;
import org.onlab.packet.UDP;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.NshServicePathId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.sfc.installer.impl.SfcFlowRuleInstallerImpl;
import org.onosproject.sfc.manager.SfcService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.onosproject.vtnrsc.DefaultFiveTuple;
import org.onosproject.vtnrsc.FiveTuple;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.LoadBalanceId;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.event.VtnRscEvent;
import org.onosproject.vtnrsc.event.VtnRscEventFeedback;
import org.onosproject.vtnrsc.event.VtnRscListener;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierService;
import org.onosproject.vtnrsc.portchain.PortChainService;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupService;
import org.onosproject.vtnrsc.service.VtnRscService;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SfcManager
implements SfcService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String nshSpiIdTopic = "nsh-spi-id";
    private static final String APP_ID = "org.onosproject.app.vtn";
    private static final int SFC_PRIORITY = 1000;
    private static final int MAX_NSH_SPI_ID = 524287;
    private static final int MAX_LOAD_BALANCE_ID = 32;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VtnRscService vtnRscService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PortChainService portChainService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PortPairGroupService portPairGroupService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowClassifierService flowClassifierService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualPortService virtualPortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    protected SfcPacketProcessor processor = new SfcPacketProcessor();
    protected ApplicationId appId;
    protected IdGenerator nshSpiIdGenerator;
    protected EventuallyConsistentMap<PortChainId, Integer> nshSpiPortChainMap;
    protected EventuallyConsistentMap<PortChainId, List<FiveTuple>> portChainFiveTupleMap;
    protected DistributedSet<Integer> nshSpiIdFreeList;
    private final VtnRscListener vtnRscListener = new InnerVtnRscListener();

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_ID);
        this.nshSpiIdGenerator = this.coreService.getIdGenerator(this.nshSpiIdTopic);
        this.vtnRscService.addListener((EventListener)this.vtnRscListener);
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(new Class[]{PortChainId.class, UUID.class, FiveTuple.class, IpAddress.class, PortNumber.class, DefaultFiveTuple.class, IpAddress.Version.class, TenantId.class});
        this.nshSpiPortChainMap = this.storageService.eventuallyConsistentMapBuilder().withName("nshSpiPortChainMap").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.portChainFiveTupleMap = this.storageService.eventuallyConsistentMapBuilder().withName("portChainFiveTupleMap").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.nshSpiIdFreeList = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("nshSpiIdDeletedList")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).build()).asDistributedSet();
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)1000));
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.vtnRscService.removeListener((EventListener)this.vtnRscListener);
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.log.info("Stopped");
    }

    @Override
    public void onPortPairCreated(PortPair portPair) {
        this.log.debug("onPortPairCreated");
    }

    @Override
    public void onPortPairDeleted(PortPair portPair) {
        this.log.debug("onPortPairDeleted");
    }

    @Override
    public void onPortPairGroupCreated(PortPairGroup portPairGroup) {
        this.log.debug("onPortPairGroupCreated");
    }

    @Override
    public void onPortPairGroupDeleted(PortPairGroup portPairGroup) {
        this.log.debug("onPortPairGroupDeleted");
    }

    @Override
    public void onFlowClassifierCreated(FlowClassifier flowClassifier) {
        this.log.debug("onFlowClassifierCreated");
    }

    @Override
    public void onFlowClassifierDeleted(FlowClassifier flowClassifier) {
        this.log.debug("onFlowClassifierDeleted");
    }

    @Override
    public void onPortChainCreated(PortChain portChain) {
        this.log.info("On port chain created");
        int spi = this.getNextNshSpi();
        if (spi > 524287) {
            this.log.error("Reached max limit of service path index.Failed to install SFC for port chain {}", (Object)portChain.portChainId().toString());
            return;
        }
        NshServicePathId nshSpi = NshServicePathId.of((int)spi);
        this.nshSpiPortChainMap.put((Object)portChain.portChainId(), (Object)new Integer(spi));
        if (!this.portChainFiveTupleMap.containsKey((Object)portChain.portChainId())) {
            this.portChainFiveTupleMap.put((Object)portChain.portChainId(), (Object)Lists.newArrayList());
        }
        SfcFlowRuleInstallerImpl flowRuleInstaller = new SfcFlowRuleInstallerImpl(this.appId);
        flowRuleInstaller.installFlowClassifier(portChain, nshSpi);
        List list = (List)this.portChainFiveTupleMap.get((Object)portChain.portChainId());
        for (FiveTuple fiveTuple : list) {
            LoadBalanceId id = this.loadBalanceSfc(portChain.portChainId(), fiveTuple);
            nshSpi = NshServicePathId.of((int)this.getNshServicePathId(id, spi));
            flowRuleInstaller.installLoadBalancedFlowRules(portChain, fiveTuple, nshSpi);
        }
    }

    @Override
    public void onPortChainDeleted(PortChain portChain) {
        this.log.info("onPortChainDeleted");
        if (!this.nshSpiPortChainMap.containsKey((Object)portChain.portChainId())) {
            throw new ItemNotFoundException("Unable to find NSH SPI");
        }
        int nshSpiId = (Integer)this.nshSpiPortChainMap.get((Object)portChain.portChainId());
        SfcFlowRuleInstallerImpl flowRuleInstaller = new SfcFlowRuleInstallerImpl(this.appId);
        flowRuleInstaller.unInstallFlowClassifier(portChain, NshServicePathId.of((int)nshSpiId));
        this.nshSpiPortChainMap.remove((Object)portChain.portChainId());
        this.nshSpiIdFreeList.add((Object)nshSpiId);
        ArrayList processedIdList = Lists.newArrayList();
        Set fiveTupleSet = portChain.getLoadBalanceIdMapKeys();
        for (FiveTuple fiveTuple : fiveTupleSet) {
            LoadBalanceId id = portChain.getLoadBalanceId(fiveTuple);
            NshServicePathId nshSpi = NshServicePathId.of((int)this.getNshServicePathId(id, nshSpiId));
            if (processedIdList.contains(id)) {
                flowRuleInstaller.unInstallLoadBalancedClassifierRules(portChain, fiveTuple, nshSpi);
                continue;
            }
            processedIdList.add(id);
            flowRuleInstaller.unInstallLoadBalancedFlowRules(portChain, fiveTuple, nshSpi);
        }
        List ppgIdlist = portChain.portPairGroups();
        ListIterator ppgIdListIterator = ppgIdlist.listIterator();
        while (ppgIdListIterator.hasNext()) {
            PortPairGroupId portPairGroupId = (PortPairGroupId)ppgIdListIterator.next();
            PortPairGroup ppg = this.portPairGroupService.getPortPairGroup(portPairGroupId);
            ppg.resetLoad();
        }
    }

    int getNextNshSpi() {
        if (this.nshSpiIdFreeList.isEmpty()) {
            return (int)this.nshSpiIdGenerator.getNewId();
        }
        Iterator it = this.nshSpiIdFreeList.iterator();
        Integer value = (Integer)it.next();
        this.nshSpiIdFreeList.remove((Object)value);
        return value;
    }

    protected int getNshServicePathId(LoadBalanceId id, int nshSpiId) {
        int nshSpiNew = nshSpiId << 5;
        return nshSpiNew |= id.loadBalanceId();
    }

    private void addToPortChainIdFiveTupleMap(PortChainId portChainId, FiveTuple fiveTuple) {
        List list = (List)this.portChainFiveTupleMap.get((Object)portChainId);
        list.add(fiveTuple);
        this.portChainFiveTupleMap.put((Object)portChainId, (Object)list);
    }

    private LoadBalanceId loadBalanceSfc(PortChainId portChainId, FiveTuple fiveTuple) {
        LoadBalanceId id;
        PortChain portChain = this.portChainService.getPortChain(portChainId);
        ArrayList loadBalancePath = Lists.newArrayList();
        int paths = portChain.getLoadBalancePathSize();
        if (paths >= 32) {
            this.log.info("Max limit reached for load balance paths. Reusing the created path for port chain {} with five tuple {}", (Object)portChainId, (Object)fiveTuple);
            id = LoadBalanceId.of((byte)((byte)((paths + 1) % 32)));
            portChain.addLoadBalancePath(fiveTuple, id, portChain.getLoadBalancePath(id));
        }
        List portPairGroups = portChain.portPairGroups();
        for (PortPairGroupId portPairGroupId : portPairGroups) {
            PortPairGroup portPairGroup = this.portPairGroupService.getPortPairGroup(portPairGroupId);
            List portPairs = portPairGroup.portPairs();
            int minLoad = 4095;
            PortPairId minLoadPortPairId = null;
            for (PortPairId portPairId : portPairs) {
                int load = portPairGroup.getLoad(portPairId);
                if (load == 0) {
                    minLoadPortPairId = portPairId;
                    break;
                }
                if (load >= minLoad) continue;
                minLoad = load;
                minLoadPortPairId = portPairId;
            }
            if (minLoadPortPairId == null) continue;
            loadBalancePath.add(minLoadPortPairId);
            portPairGroup.addLoad(minLoadPortPairId);
        }
        id = portChain.matchPath((List)loadBalancePath);
        if (id == null) {
            id = LoadBalanceId.of((byte)((byte)(paths + 1)));
        }
        portChain.addLoadBalancePath(fiveTuple, id, (List)loadBalancePath);
        return id;
    }

    protected void bindVtnRscService(VtnRscService vtnRscService) {
        this.vtnRscService = vtnRscService;
    }

    protected void unbindVtnRscService(VtnRscService vtnRscService) {
        if (this.vtnRscService == vtnRscService) {
            this.vtnRscService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindPortChainService(PortChainService portChainService) {
        this.portChainService = portChainService;
    }

    protected void unbindPortChainService(PortChainService portChainService) {
        if (this.portChainService == portChainService) {
            this.portChainService = null;
        }
    }

    protected void bindPortPairGroupService(PortPairGroupService portPairGroupService) {
        this.portPairGroupService = portPairGroupService;
    }

    protected void unbindPortPairGroupService(PortPairGroupService portPairGroupService) {
        if (this.portPairGroupService == portPairGroupService) {
            this.portPairGroupService = null;
        }
    }

    protected void bindFlowClassifierService(FlowClassifierService flowClassifierService) {
        this.flowClassifierService = flowClassifierService;
    }

    protected void unbindFlowClassifierService(FlowClassifierService flowClassifierService) {
        if (this.flowClassifierService == flowClassifierService) {
            this.flowClassifierService = null;
        }
    }

    protected void bindVirtualPortService(VirtualPortService virtualPortService) {
        this.virtualPortService = virtualPortService;
    }

    protected void unbindVirtualPortService(VirtualPortService virtualPortService) {
        if (this.virtualPortService == virtualPortService) {
            this.virtualPortService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class SfcPacketProcessor
    implements PacketProcessor {
        private SfcPacketProcessor() {
        }

        private boolean checkIpInVirtualPort(VirtualPortId vPortId, IpAddress ip) {
            boolean found = false;
            Set ips = SfcManager.this.virtualPortService.getPort(vPortId).fixedIps();
            for (FixedIp fixedIp : ips) {
                if (!fixedIp.ip().equals((Object)ip)) continue;
                found = true;
                break;
            }
            return found;
        }

        private PortChainId findPortChainFromFiveTuple(FiveTuple fiveTuple) {
            PortChainId portChainId = null;
            Iterable portChains = SfcManager.this.portChainService.getPortChains();
            if (portChains == null) {
                SfcManager.this.log.error("Could not retrive port chain list");
            }
            block0: for (PortChain portChain : portChains) {
                if (!portChain.tenantId().equals((Object)fiveTuple.tenantId())) continue;
                List flowClassifiers = portChain.flowClassifiers();
                for (FlowClassifierId flowClassifierId : flowClassifiers) {
                    FlowClassifier flowClassifier = SfcManager.this.flowClassifierService.getFlowClassifier(flowClassifierId);
                    boolean match = false;
                    if (flowClassifier.protocol() != null) {
                        if (!(flowClassifier.protocol().equalsIgnoreCase("TCP") && fiveTuple.protocol() == 6 || flowClassifier.protocol().equalsIgnoreCase("UDP") && fiveTuple.protocol() == 17) && (!flowClassifier.protocol().equalsIgnoreCase("ICMP") || fiveTuple.protocol() != 1)) continue;
                        match = true;
                    }
                    if (flowClassifier.srcIpPrefix() != null) {
                        if (!flowClassifier.srcIpPrefix().contains(fiveTuple.ipSrc())) continue;
                        match = true;
                    }
                    if (flowClassifier.dstIpPrefix() != null) {
                        if (!flowClassifier.dstIpPrefix().contains(fiveTuple.ipDst())) continue;
                        match = true;
                    }
                    if (fiveTuple.portSrc().toLong() < (long)flowClassifier.minSrcPortRange() && fiveTuple.portSrc().toLong() > (long)flowClassifier.maxSrcPortRange()) continue;
                    match = true;
                    if (fiveTuple.portDst().toLong() < (long)flowClassifier.minSrcPortRange() && fiveTuple.portDst().toLong() > (long)flowClassifier.maxSrcPortRange()) continue;
                    match = true;
                    if (flowClassifier.srcPort() != null && !flowClassifier.srcPort().portId().isEmpty() && !(match = this.checkIpInVirtualPort(VirtualPortId.portId((String)flowClassifier.srcPort().portId()), fiveTuple.ipSrc())) || flowClassifier.dstPort() != null && !flowClassifier.dstPort().portId().isEmpty() && !(match = this.checkIpInVirtualPort(VirtualPortId.portId((String)flowClassifier.dstPort().portId()), fiveTuple.ipDst())) || !match) continue;
                    portChainId = portChain.portChainId();
                    continue block0;
                }
            }
            return portChainId;
        }

        private TenantId getTenantId(MacAddress mac) {
            Collection virtualPorts = SfcManager.this.virtualPortService.getPorts();
            for (VirtualPort virtualPort : virtualPorts) {
                if (!virtualPort.macAddress().equals((Object)mac)) continue;
                return virtualPort.tenantId();
            }
            return null;
        }

        public void process(PacketContext context) {
            NshServicePathId nshSpi;
            int nshSpiId;
            Ethernet packet = context.inPacket().parsed();
            if (packet == null || SfcManager.this.portChainService.getPortChainCount() == 0) {
                return;
            }
            short ethType = packet.getEtherType();
            IpAddress ipSrc = null;
            IpAddress ipDst = null;
            int portSrc = 0;
            int portDst = 0;
            byte protocol = 0;
            MacAddress macSrc = packet.getSourceMAC();
            MacAddress macDst = packet.getDestinationMAC();
            TenantId tenantId = this.getTenantId(macSrc);
            if (ethType == Ethernet.TYPE_IPV4) {
                IPv4 ipv4Packet = (IPv4)packet.getPayload();
                ipSrc = IpAddress.valueOf((int)ipv4Packet.getSourceAddress());
                ipDst = IpAddress.valueOf((int)ipv4Packet.getDestinationAddress());
                protocol = ipv4Packet.getProtocol();
                if (protocol == 6) {
                    TCP tcpPacket = (TCP)ipv4Packet.getPayload();
                    portSrc = tcpPacket.getSourcePort();
                    portDst = tcpPacket.getDestinationPort();
                } else if (protocol == 17) {
                    UDP udpPacket = (UDP)ipv4Packet.getPayload();
                    portSrc = udpPacket.getSourcePort();
                    portDst = udpPacket.getDestinationPort();
                } else if (protocol != 1) {
                    return;
                }
            } else {
                return;
            }
            FiveTuple fiveTuple = DefaultFiveTuple.builder().setIpSrc(ipSrc).setIpDst(ipDst).setPortSrc(PortNumber.portNumber((long)portSrc)).setPortDst(PortNumber.portNumber((long)portDst)).setProtocol(protocol).setTenantId(tenantId).setMacSrc(macSrc).setMacDst(macDst).build();
            PortChainId portChainId = this.findPortChainFromFiveTuple(fiveTuple);
            if (portChainId == null) {
                return;
            }
            SfcManager.this.addToPortChainIdFiveTupleMap(portChainId, fiveTuple);
            LoadBalanceId id = SfcManager.this.loadBalanceSfc(portChainId, fiveTuple);
            PortChain portChain = SfcManager.this.portChainService.getPortChain(portChainId);
            if (SfcManager.this.nshSpiPortChainMap.containsKey((Object)portChain.portChainId())) {
                nshSpiId = (Integer)SfcManager.this.nshSpiPortChainMap.get((Object)portChain.portChainId());
                nshSpi = NshServicePathId.of((int)SfcManager.this.getNshServicePathId(id, nshSpiId));
            } else {
                nshSpiId = SfcManager.this.getNextNshSpi();
                if (nshSpiId > 524287) {
                    SfcManager.this.log.error("Reached max limit of service path index.Failed to install SFC for port chain {}", (Object)portChain.portChainId());
                    return;
                }
                nshSpi = NshServicePathId.of((int)SfcManager.this.getNshServicePathId(id, nshSpiId));
                SfcManager.this.nshSpiPortChainMap.put((Object)portChain.portChainId(), (Object)new Integer(nshSpiId));
            }
            SfcFlowRuleInstallerImpl flowRuleInstaller = new SfcFlowRuleInstallerImpl(SfcManager.this.appId);
            flowRuleInstaller.installLoadBalancedFlowRules(portChain, fiveTuple, nshSpi);
            this.sendPacket(context);
        }

        private void sendPacket(PacketContext context) {
            ConnectPoint sourcePoint = context.inPacket().receivedFrom();
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(PortNumber.TABLE).build();
            DefaultOutboundPacket packet = new DefaultOutboundPacket(sourcePoint.deviceId(), treatment, context.inPacket().unparsed());
            SfcManager.this.packetService.emit((OutboundPacket)packet);
            SfcManager.this.log.trace("Sending packet: {}", (Object)packet);
        }
    }

    private class InnerVtnRscListener
    implements VtnRscListener {
        private InnerVtnRscListener() {
        }

        public void event(VtnRscEvent event) {
            if (VtnRscEvent.Type.PORT_PAIR_PUT == event.type()) {
                PortPair portPair = ((VtnRscEventFeedback)event.subject()).portPair();
                SfcManager.this.onPortPairCreated(portPair);
            } else if (VtnRscEvent.Type.PORT_PAIR_DELETE == event.type()) {
                PortPair portPair = ((VtnRscEventFeedback)event.subject()).portPair();
                SfcManager.this.onPortPairDeleted(portPair);
            } else if (VtnRscEvent.Type.PORT_PAIR_UPDATE == event.type()) {
                PortPair portPair = ((VtnRscEventFeedback)event.subject()).portPair();
                SfcManager.this.onPortPairDeleted(portPair);
                SfcManager.this.onPortPairCreated(portPair);
            } else if (VtnRscEvent.Type.PORT_PAIR_GROUP_PUT == event.type()) {
                PortPairGroup portPairGroup = ((VtnRscEventFeedback)event.subject()).portPairGroup();
                SfcManager.this.onPortPairGroupCreated(portPairGroup);
            } else if (VtnRscEvent.Type.PORT_PAIR_GROUP_DELETE == event.type()) {
                PortPairGroup portPairGroup = ((VtnRscEventFeedback)event.subject()).portPairGroup();
                SfcManager.this.onPortPairGroupDeleted(portPairGroup);
            } else if (VtnRscEvent.Type.PORT_PAIR_GROUP_UPDATE == event.type()) {
                PortPairGroup portPairGroup = ((VtnRscEventFeedback)event.subject()).portPairGroup();
                SfcManager.this.onPortPairGroupDeleted(portPairGroup);
                SfcManager.this.onPortPairGroupCreated(portPairGroup);
            } else if (VtnRscEvent.Type.FLOW_CLASSIFIER_PUT == event.type()) {
                FlowClassifier flowClassifier = ((VtnRscEventFeedback)event.subject()).flowClassifier();
                SfcManager.this.onFlowClassifierCreated(flowClassifier);
            } else if (VtnRscEvent.Type.FLOW_CLASSIFIER_DELETE == event.type()) {
                FlowClassifier flowClassifier = ((VtnRscEventFeedback)event.subject()).flowClassifier();
                SfcManager.this.onFlowClassifierDeleted(flowClassifier);
            } else if (VtnRscEvent.Type.FLOW_CLASSIFIER_UPDATE == event.type()) {
                FlowClassifier flowClassifier = ((VtnRscEventFeedback)event.subject()).flowClassifier();
                SfcManager.this.onFlowClassifierDeleted(flowClassifier);
                SfcManager.this.onFlowClassifierCreated(flowClassifier);
            } else if (VtnRscEvent.Type.PORT_CHAIN_PUT == event.type()) {
                PortChain portChain = ((VtnRscEventFeedback)event.subject()).portChain();
                if (portChain.oldPortChain() != null) {
                    SfcManager.this.onPortChainDeleted(portChain.oldPortChain());
                }
                SfcManager.this.onPortChainCreated(portChain);
            } else if (VtnRscEvent.Type.PORT_CHAIN_DELETE == event.type()) {
                PortChain portChain = ((VtnRscEventFeedback)event.subject()).portChain();
                SfcManager.this.onPortChainDeleted(portChain);
                SfcManager.this.portChainFiveTupleMap.remove((Object)portChain.portChainId());
            } else if (VtnRscEvent.Type.PORT_CHAIN_UPDATE == event.type()) {
                PortChain portChain = ((VtnRscEventFeedback)event.subject()).portChain();
                SfcManager.this.onPortChainDeleted(portChain);
                SfcManager.this.onPortChainCreated(portChain);
            }
        }
    }
}

