/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.DeviceId;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.vtnrsc.AllowedAddressPair;
import org.onosproject.vtnrsc.BindingHostId;
import org.onosproject.vtnrsc.DefaultVirtualPort;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.SecurityGroup;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;
import org.onosproject.vtnweb.web.VirtualPortCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="ports")
public class VirtualPortWebResource
extends AbstractWebResource {
    public static final String VPORT_NOT_FOUND = "VirtualPort is not found";
    public static final String VPORT_ID_EXIST = "VirtualPort id is exist";
    public static final String VPORT_ID_NOT_EXIST = "VirtualPort id is not exist";
    public static final String JSON_NOT_NULL = "JsonNode can not be null";
    protected static final Logger log = LoggerFactory.getLogger(VirtualPortService.class);

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getPorts() {
        Collection virtualPorts = ((VirtualPortService)this.get(VirtualPortService.class)).getPorts();
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("ports", (JsonNode)new VirtualPortCodec().encode(virtualPorts, (CodecContext)this));
        return VirtualPortWebResource.ok((Object)result.toString()).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getportsById(@PathParam(value="id") String id) {
        if (!((VirtualPortService)this.get(VirtualPortService.class)).exists(VirtualPortId.portId((String)id))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)VPORT_NOT_FOUND).build();
        }
        VirtualPort virtualPort = this.nullIsNotFound(((VirtualPortService)this.get(VirtualPortService.class)).getPort(VirtualPortId.portId((String)id)), VPORT_NOT_FOUND);
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("port", (JsonNode)new VirtualPortCodec().encode(virtualPort, (CodecContext)this));
        return VirtualPortWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createPorts(InputStream input) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode cfg = mapper.readTree(input);
            Iterable<VirtualPort> vPorts = this.createOrUpdateByInputStream(cfg);
            Boolean issuccess = this.nullIsNotFound(((VirtualPortService)this.get(VirtualPortService.class)).createPorts(vPorts), VPORT_NOT_FOUND);
            if (!issuccess.booleanValue()) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)VPORT_ID_NOT_EXIST).build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)issuccess.toString()).build();
        }
        catch (Exception e) {
            log.error("Creates VirtualPort failed because of exception {}", (Object)e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString()).build();
        }
    }

    @DELETE
    @Path(value="{portUUID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deletePorts(@PathParam(value="portUUID") String id) {
        HashSet<VirtualPortId> vPortIds = new HashSet<VirtualPortId>();
        try {
            Boolean issuccess;
            if (id != null) {
                vPortIds.add(VirtualPortId.portId((String)id));
            }
            if (!(issuccess = this.nullIsNotFound(((VirtualPortService)this.get(VirtualPortService.class)).removePorts(vPortIds), VPORT_NOT_FOUND)).booleanValue()) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)VPORT_ID_NOT_EXIST).build();
            }
            return VirtualPortWebResource.ok((Object)issuccess.toString()).build();
        }
        catch (Exception e) {
            log.error("Deletes VirtualPort failed because of exception {}", (Object)e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString()).build();
        }
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updatePorts(@PathParam(value="id") String id, InputStream input) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode cfg = mapper.readTree(input);
            Iterable<VirtualPort> vPorts = this.createOrUpdateByInputStream(cfg);
            Boolean issuccess = this.nullIsNotFound(((VirtualPortService)this.get(VirtualPortService.class)).updatePorts(vPorts), VPORT_NOT_FOUND);
            if (!issuccess.booleanValue()) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)VPORT_ID_NOT_EXIST).build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)issuccess.toString()).build();
        }
        catch (Exception e) {
            log.error("Updates failed because of exception {}", (Object)e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString()).build();
        }
    }

    public Iterable<VirtualPort> createOrUpdateByInputStream(JsonNode vPortNode) {
        Preconditions.checkNotNull((Object)vPortNode, (Object)JSON_NOT_NULL);
        JsonNode vPortNodes = vPortNode.get("ports");
        if (vPortNodes == null) {
            vPortNodes = vPortNode.get("port");
        }
        if (vPortNodes.isArray()) {
            return this.changeJsonToPorts(vPortNodes);
        }
        return this.changeJsonToPort(vPortNodes);
    }

    public Iterable<VirtualPort> changeJsonToPorts(JsonNode vPortNodes) {
        Preconditions.checkNotNull((Object)vPortNodes, (Object)JSON_NOT_NULL);
        HashMap<VirtualPortId, DefaultVirtualPort> portMap = new HashMap<VirtualPortId, DefaultVirtualPort>();
        HashMap<String, String> strMap = new HashMap<String, String>();
        for (JsonNode vPortnode : vPortNodes) {
            VirtualPortId id = VirtualPortId.portId((String)vPortnode.get("id").asText());
            String name = vPortnode.get("name").asText();
            TenantId tenantId = TenantId.tenantId((String)vPortnode.get("tenant_id").asText());
            TenantNetworkId networkId = TenantNetworkId.networkId((String)vPortnode.get("network_id").asText());
            Preconditions.checkArgument((boolean)vPortnode.get("admin_state_up").isBoolean(), (Object)"admin_state_up should be boolean");
            Boolean adminStateUp = vPortnode.get("admin_state_up").asBoolean();
            String state = vPortnode.get("status").asText();
            MacAddress macAddress = MacAddress.valueOf((String)vPortnode.get("mac_address").asText());
            DeviceId deviceId = DeviceId.deviceId((String)vPortnode.get("device_id").asText());
            String deviceOwner = vPortnode.get("device_owner").asText();
            JsonNode fixedIpNodes = vPortNodes.get("fixed_ips");
            HashSet<FixedIp> fixedIps = new HashSet<FixedIp>();
            for (JsonNode fixedIpNode : fixedIpNodes) {
                FixedIp fixedIp = this.jsonNodeToFixedIps(fixedIpNode);
                fixedIps.add(fixedIp);
            }
            BindingHostId bindingHostId = BindingHostId.bindingHostId((String)vPortnode.get("binding:host_id").asText());
            String bindingVnicType = vPortnode.get("binding:vnic_type").asText();
            String bindingVifType = vPortnode.get("binding:vif_type").asText();
            String bindingVifDetails = vPortnode.get("binding:vif_details").asText();
            JsonNode allowedAddressPairJsonNode = vPortnode.get("allowed_address_pairs");
            Collection<AllowedAddressPair> allowedAddressPairs = this.jsonNodeToAllowedAddressPair(allowedAddressPairJsonNode);
            JsonNode securityGroupNode = vPortnode.get("security_groups");
            Collection<SecurityGroup> securityGroups = this.jsonNodeToSecurityGroup(securityGroupNode);
            strMap.put("name", name);
            strMap.put("deviceOwner", deviceOwner);
            strMap.put("bindingVnicType", bindingVnicType);
            strMap.put("bindingVifType", bindingVifType);
            strMap.put("bindingVifDetails", bindingVifDetails);
            DefaultVirtualPort vPort = new DefaultVirtualPort(id, networkId, adminStateUp, strMap, this.isState(state), macAddress, tenantId, deviceId, fixedIps, bindingHostId, (Set)Sets.newHashSet(allowedAddressPairs), (Set)Sets.newHashSet(securityGroups));
            portMap.put(id, vPort);
        }
        return Collections.unmodifiableCollection(portMap.values());
    }

    public Iterable<VirtualPort> changeJsonToPort(JsonNode vPortNodes) {
        Preconditions.checkNotNull((Object)vPortNodes, (Object)JSON_NOT_NULL);
        HashMap<VirtualPortId, DefaultVirtualPort> vportMap = new HashMap<VirtualPortId, DefaultVirtualPort>();
        HashMap<String, String> strMap = new HashMap<String, String>();
        VirtualPortId id = VirtualPortId.portId((String)vPortNodes.get("id").asText());
        String name = vPortNodes.get("name").asText();
        TenantId tenantId = TenantId.tenantId((String)vPortNodes.get("tenant_id").asText());
        TenantNetworkId networkId = TenantNetworkId.networkId((String)vPortNodes.get("network_id").asText());
        Boolean adminStateUp = vPortNodes.get("admin_state_up").asBoolean();
        String state = vPortNodes.get("status").asText();
        MacAddress macAddress = MacAddress.valueOf((String)vPortNodes.get("mac_address").asText());
        DeviceId deviceId = DeviceId.deviceId((String)vPortNodes.get("device_id").asText());
        String deviceOwner = vPortNodes.get("device_owner").asText();
        JsonNode fixedIpNodes = vPortNodes.get("fixed_ips");
        HashSet<FixedIp> fixedIps = new HashSet<FixedIp>();
        for (JsonNode fixedIpNode : fixedIpNodes) {
            FixedIp fixedIp = this.jsonNodeToFixedIps(fixedIpNode);
            fixedIps.add(fixedIp);
        }
        BindingHostId bindingHostId = BindingHostId.bindingHostId((String)vPortNodes.get("binding:host_id").asText());
        String bindingVnicType = vPortNodes.get("binding:vnic_type").asText();
        String bindingVifType = vPortNodes.get("binding:vif_type").asText();
        String bindingVifDetails = vPortNodes.get("binding:vif_details").asText();
        JsonNode allowedAddressPairJsonNode = vPortNodes.get("allowed_address_pairs");
        Collection<AllowedAddressPair> allowedAddressPairs = this.jsonNodeToAllowedAddressPair(allowedAddressPairJsonNode);
        JsonNode securityGroupNode = vPortNodes.get("security_groups");
        Collection<SecurityGroup> securityGroups = this.jsonNodeToSecurityGroup(securityGroupNode);
        strMap.put("name", name);
        strMap.put("deviceOwner", deviceOwner);
        strMap.put("bindingVnicType", bindingVnicType);
        strMap.put("bindingVifType", bindingVifType);
        strMap.put("bindingVifDetails", bindingVifDetails);
        DefaultVirtualPort vPort = new DefaultVirtualPort(id, networkId, adminStateUp, strMap, this.isState(state), macAddress, tenantId, deviceId, fixedIps, bindingHostId, (Set)Sets.newHashSet(allowedAddressPairs), (Set)Sets.newHashSet(securityGroups));
        vportMap.put(id, vPort);
        return Collections.unmodifiableCollection(vportMap.values());
    }

    public Collection<AllowedAddressPair> jsonNodeToAllowedAddressPair(JsonNode allowedAddressPairs) {
        Preconditions.checkNotNull((Object)allowedAddressPairs, (Object)JSON_NOT_NULL);
        ConcurrentMap allowMaps = Maps.newConcurrentMap();
        int i = 0;
        for (JsonNode node : allowedAddressPairs) {
            IpAddress ip = IpAddress.valueOf((String)node.get("ip_address").asText());
            MacAddress mac = MacAddress.valueOf((String)node.get("mac_address").asText());
            AllowedAddressPair allows = AllowedAddressPair.allowedAddressPair((IpAddress)ip, (MacAddress)mac);
            allowMaps.put(i, allows);
            ++i;
        }
        log.debug("The jsonNode of allowedAddressPairallow is {}" + allowedAddressPairs.toString());
        return Collections.unmodifiableCollection(allowMaps.values());
    }

    public Collection<SecurityGroup> jsonNodeToSecurityGroup(JsonNode securityGroups) {
        Preconditions.checkNotNull((Object)securityGroups, (Object)JSON_NOT_NULL);
        ConcurrentMap securMaps = Maps.newConcurrentMap();
        int i = 0;
        for (JsonNode node : securityGroups) {
            SecurityGroup securityGroup = SecurityGroup.securityGroup((String)node.asText());
            securMaps.put(i, securityGroup);
            ++i;
        }
        return Collections.unmodifiableCollection(securMaps.values());
    }

    public FixedIp jsonNodeToFixedIps(JsonNode fixedIpNode) {
        SubnetId subnetId = SubnetId.subnetId((String)fixedIpNode.get("subnet_id").asText());
        IpAddress ipAddress = IpAddress.valueOf((String)fixedIpNode.get("ip_address").asText());
        FixedIp fixedIps = FixedIp.fixedIp((SubnetId)subnetId, (IpAddress)ipAddress);
        return fixedIps;
    }

    private VirtualPort.State isState(String state) {
        if (state.equals("ACTIVE")) {
            return VirtualPort.State.ACTIVE;
        }
        return VirtualPort.State.DOWN;
    }

    protected <T> T nullIsNotFound(T item, String message) {
        if (item == null) {
            throw new ItemNotFoundException(message);
        }
        return item;
    }
}

