/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnweb.web.AllowedAddressPairCodec;
import org.onosproject.vtnweb.web.FixedIpCodec;
import org.onosproject.vtnweb.web.SecurityGroupCodec;

public final class VirtualPortCodec
extends JsonCodec<VirtualPort> {
    public ObjectNode encode(VirtualPort vPort, CodecContext context) {
        Preconditions.checkNotNull((Object)vPort, (Object)"VPort cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put("id", vPort.portId().toString()).put("network_id", vPort.networkId().toString()).put("admin_state_up", vPort.adminStateUp()).put("name", vPort.name()).put("status", vPort.state().toString()).put("mac_address", vPort.macAddress().toString()).put("tenant_id", vPort.tenantId().toString()).put("device_id", vPort.deviceId().toString()).put("device_owner", vPort.deviceOwner()).put("binding:vnic_type", vPort.bindingVnicType()).put("binding:Vif_type", vPort.bindingVifType()).put("binding:host_id", vPort.bindingHostId().toString()).put("binding:vif_details", vPort.bindingVifDetails());
        result.set("allowed_address_pairs", (JsonNode)new AllowedAddressPairCodec().encode(vPort.allowedAddressPairs(), context));
        result.set("fixed_ips", (JsonNode)new FixedIpCodec().encode(vPort.fixedIps(), context));
        result.set("security_groups", (JsonNode)new SecurityGroupCodec().encode(vPort.securityGroups(), context));
        return result;
    }
}

