/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.client.WebTarget;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.rest.BaseResource;
import org.onosproject.codec.CodecService;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.ServiceFunctionGroup;
import org.onosproject.vtnrsc.portchainsfmap.PortChainSfMapService;
import org.onosproject.vtnweb.resources.VtnResourceTest;
import org.onosproject.vtnweb.web.SfcCodecContext;

public class PortChainSfMapResourceTest
extends VtnResourceTest {
    final PortChainSfMapService portChainSfMapService = (PortChainSfMapService)EasyMock.createMock(PortChainSfMapService.class);
    String name1 = "Firewall";
    String description1 = "Firewall service function";
    Map<PortPairId, Integer> portPairLoadMap1 = new ConcurrentHashMap<PortPairId, Integer>();
    ServiceFunctionGroup serviceFunction1 = new ServiceFunctionGroup(this.name1, this.description1, this.portPairLoadMap1);

    @Before
    public void setUpTest() {
        SfcCodecContext context = new SfcCodecContext();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(PortChainSfMapService.class, (Object)this.portChainSfMapService).add(CodecService.class, (Object)context.codecManager());
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
    }

    @Test
    public void testGetPortChainId() {
        ArrayList serviceFunctions = Lists.newArrayList();
        serviceFunctions.add(this.serviceFunction1);
        EasyMock.expect((Object)this.portChainSfMapService.getServiceFunctions((PortChainId)EasyMock.anyObject())).andReturn((Object)serviceFunctions).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portChainSfMapService});
        WebTarget wt = this.target();
        String response = (String)wt.path("portChainSfMap/1278dcd4-459f-62ed-754b-87fc5e4a6751").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"portChainSfMap"));
    }
}

