/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.gui;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.onlab.packet.IpAddress;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.table.TableModel;
import org.onosproject.ui.table.TableRequestHandler;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierService;
import org.onosproject.vtnrsc.portchain.PortChainService;
import org.onosproject.vtnrsc.portpair.PortPairService;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupService;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;

public class SfcViewMessageHandler
extends UiMessageHandler {
    private static final String SLASH = " -> ";
    private static final String NONE = "none";
    private static final String SFCTYPE = "Service Function Chain";
    private static final String SFC_DATA_REQ = "sfcDataRequest";
    private static final String SFC_DATA_RESP = "sfcDataResponse";
    private static final String SFCS = "sfcs";
    private static final String ID = "id";
    private static final String STATE = "_iconid_state";
    private static final String PORTCHAINNAME = "portChainName";
    private static final String SFS = "sfs";
    private static final String TYPE = "type";
    private static final String SRCIP = "srcIp";
    private static final String DSTIP = "dstIp";
    private static final String[] COL_IDS = new String[]{"id", "_iconid_state", "portChainName", "sfs", "type", "srcIp", "dstIp"};
    private static final String ICON_ID_ONLINE = "active";
    private static final String ICON_ID_OFFLINE = "inactive";

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)((Object)new SfcDataRequest()));
    }

    private final class SfcDataRequest
    extends TableRequestHandler {
        private static final String NO_ROWS_MESSAGE = "No Service Function Chain found";

        private SfcDataRequest() {
            super(SfcViewMessageHandler.SFC_DATA_REQ, SfcViewMessageHandler.SFC_DATA_RESP, SfcViewMessageHandler.SFCS);
        }

        protected String[] getColumnIds() {
            return COL_IDS;
        }

        protected String defaultColumnId() {
            return SfcViewMessageHandler.PORTCHAINNAME;
        }

        protected String noRowsMessage(ObjectNode payload) {
            return NO_ROWS_MESSAGE;
        }

        protected void populateTable(TableModel tm, ObjectNode payload) {
            PortChainService pcs = (PortChainService)this.get(PortChainService.class);
            Iterable portChains = pcs.getPortChains();
            portChains.forEach(pchain -> this.populateRow(tm.addRow(), (PortChain)pchain));
        }

        private void populateRow(TableModel.Row row, PortChain pchain) {
            PortChainIpRange portChainIpRange = this.portChainIpRange(pchain);
            List<VirtualPort> vpList = this.sfcPorts(pchain);
            row.cell(SfcViewMessageHandler.ID, (Object)pchain.portChainId().value().toString()).cell(SfcViewMessageHandler.STATE, (Object)this.sfcState(vpList)).cell(SfcViewMessageHandler.PORTCHAINNAME, (Object)pchain.name()).cell(SfcViewMessageHandler.SFS, (Object)this.sfcHosts(vpList)).cell(SfcViewMessageHandler.TYPE, (Object)SfcViewMessageHandler.SFCTYPE).cell(SfcViewMessageHandler.SRCIP, (Object)portChainIpRange.srcip()).cell(SfcViewMessageHandler.DSTIP, (Object)portChainIpRange.dstip());
        }

        private PortChainIpRange portChainIpRange(PortChain pchain) {
            List flowClassifierList = pchain.flowClassifiers();
            FlowClassifierService fcs = (FlowClassifierService)this.get(FlowClassifierService.class);
            StringBuffer srcipbuf = new StringBuffer();
            StringBuffer dstipbuf = new StringBuffer();
            if (flowClassifierList != null) {
                flowClassifierList.forEach(fcid -> {
                    FlowClassifier fc = fcs.getFlowClassifier(fcid);
                    String srcip = fc.srcIpPrefix().toString();
                    String dstip = fc.dstIpPrefix().toString();
                    srcipbuf.append(srcip).append(SfcViewMessageHandler.SLASH);
                    dstipbuf.append(dstip).append(SfcViewMessageHandler.SLASH);
                });
            }
            String srcip = SfcViewMessageHandler.NONE;
            String dstip = SfcViewMessageHandler.NONE;
            if (srcipbuf.length() > 0) {
                srcip = srcipbuf.substring(0, srcipbuf.length() - SfcViewMessageHandler.SLASH.length());
            }
            if (dstipbuf.length() > 0) {
                dstip = dstipbuf.substring(0, dstipbuf.length() - SfcViewMessageHandler.SLASH.length());
            }
            PortChainIpRange portChainIpRange = new PortChainIpRange(srcip, dstip);
            return portChainIpRange;
        }

        private List<VirtualPort> sfcPorts(PortChain pchain) {
            List portPairGroupList = pchain.portPairGroups();
            PortPairGroupService ppgs = (PortPairGroupService)this.get(PortPairGroupService.class);
            PortPairService pps = (PortPairService)this.get(PortPairService.class);
            VirtualPortService vps = (VirtualPortService)this.get(VirtualPortService.class);
            ArrayList<VirtualPort> vpList = new ArrayList<VirtualPort>();
            if (portPairGroupList != null) {
                portPairGroupList.forEach(ppgid -> {
                    PortPairGroup ppg = ppgs.getPortPairGroup(ppgid);
                    List portPairList = ppg.portPairs();
                    if (portPairList != null) {
                        portPairList.forEach(ppid -> {
                            PortPair pp = pps.getPortPair(ppid);
                            VirtualPort vp = vps.getPort(VirtualPortId.portId((String)pp.ingress()));
                            vpList.add(vp);
                        });
                    }
                });
            }
            return vpList;
        }

        private String sfcState(List<VirtualPort> vpList) {
            for (VirtualPort vp : vpList) {
                if (!vp.state().equals((Object)VirtualPort.State.DOWN)) continue;
                return SfcViewMessageHandler.ICON_ID_OFFLINE;
            }
            return SfcViewMessageHandler.ICON_ID_ONLINE;
        }

        private String sfcHosts(List<VirtualPort> vpList) {
            StringBuffer hostsbuf = new StringBuffer();
            for (VirtualPort vp : vpList) {
                Iterator fixedIps = vp.fixedIps().iterator();
                if (!fixedIps.hasNext()) continue;
                FixedIp fixedIp = (FixedIp)fixedIps.next();
                IpAddress ip = fixedIp.ip();
                hostsbuf.append(ip.toString()).append(SfcViewMessageHandler.SLASH);
            }
            if (hostsbuf.length() > 0) {
                return hostsbuf.substring(0, hostsbuf.length() - SfcViewMessageHandler.SLASH.length());
            }
            return hostsbuf.toString();
        }

        private final class PortChainIpRange {
            private final String srcip;
            private final String dstip;

            private PortChainIpRange(String srcip, String dstip) {
                this.srcip = srcip;
                this.dstip = dstip;
            }

            public String srcip() {
                return this.srcip;
            }

            public String dstip() {
                return this.dstip;
            }
        }
    }
}

