/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.CoreService;
import org.onosproject.vtnrsc.DefaultPortPair;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.TenantId;

public final class PortPairCodec
extends JsonCodec<PortPair> {
    private static final String ID = "id";
    private static final String TENANT_ID = "tenant_id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String INGRESS = "ingress";
    private static final String EGRESS = "egress";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in PortPair";

    public PortPair decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        DefaultPortPair.Builder resultBuilder = new DefaultPortPair.Builder();
        CoreService coreService = (CoreService)context.getService(CoreService.class);
        String id = ((JsonNode)Tools.nullIsIllegal((Object)json.get(ID), (String)"id member is required in PortPair")).asText();
        resultBuilder.setId(PortPairId.of((String)id));
        String tenantId = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TENANT_ID), (String)"tenant_id member is required in PortPair")).asText();
        resultBuilder.setTenantId(TenantId.tenantId((String)tenantId));
        String name = ((JsonNode)Tools.nullIsIllegal((Object)json.get(NAME), (String)"name member is required in PortPair")).asText();
        resultBuilder.setName(name);
        String description = ((JsonNode)Tools.nullIsIllegal((Object)json.get(DESCRIPTION), (String)"description member is required in PortPair")).asText();
        resultBuilder.setDescription(description);
        String ingressPort = ((JsonNode)Tools.nullIsIllegal((Object)json.get(INGRESS), (String)"ingress member is required in PortPair")).asText();
        resultBuilder.setIngress(ingressPort);
        String egressPort = ((JsonNode)Tools.nullIsIllegal((Object)json.get(EGRESS), (String)"egress member is required in PortPair")).asText();
        resultBuilder.setEgress(egressPort);
        return resultBuilder.build();
    }

    public ObjectNode encode(PortPair portPair, CodecContext context) {
        Preconditions.checkNotNull((Object)portPair, (Object)"port pair cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(ID, portPair.portPairId().toString()).put(TENANT_ID, portPair.tenantId().toString()).put(NAME, portPair.name()).put(DESCRIPTION, portPair.description()).put(INGRESS, portPair.ingress()).put(EGRESS, portPair.egress());
        return result;
    }
}

