/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.rest.BaseResource;
import org.onosproject.codec.CodecService;
import org.onosproject.net.DeviceId;
import org.onosproject.vtnrsc.FiveTuple;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.LoadBalanceId;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.portchain.PortChainService;
import org.onosproject.vtnweb.resources.VtnResourceTest;
import org.onosproject.vtnweb.web.SfcCodecContext;

public class PortChainResourceTest
extends VtnResourceTest {
    final PortChainService portChainService = (PortChainService)EasyMock.createMock(PortChainService.class);
    PortChainId portChainId1 = PortChainId.of((String)"78dcd363-fc23-aeb6-f44b-56dc5e2fb3ae");
    TenantId tenantId1 = TenantId.tenantId((String)"d382007aa9904763a801f68ecf065cf5");
    private final List<PortPairGroupId> portPairGroupList1 = Lists.newArrayList();
    private final List<FlowClassifierId> flowClassifierList1 = Lists.newArrayList();
    final MockPortChain portChain1 = new MockPortChain(this.portChainId1, this.tenantId1, "portChain1", "Mock port chain", this.portPairGroupList1, this.flowClassifierList1);

    @Before
    public void setUpTest() {
        SfcCodecContext context = new SfcCodecContext();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(PortChainService.class, (Object)this.portChainService).add(CodecService.class, (Object)context.codecManager());
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
    }

    @Test
    public void testPortChainsEmpty() {
        EasyMock.expect((Object)this.portChainService.getPortChains()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portChainService});
        WebTarget wt = this.target();
        String response = (String)wt.path("port_chains").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"port_chains\":[]}"));
    }

    @Test
    public void testGetPortChainId() {
        HashSet<MockPortChain> portChains = new HashSet<MockPortChain>();
        portChains.add(this.portChain1);
        EasyMock.expect((Object)this.portChainService.exists((PortChainId)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.portChainService.getPortChain((PortChainId)EasyMock.anyObject())).andReturn((Object)this.portChain1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portChainService});
        WebTarget wt = this.target();
        String response = (String)wt.path("port_chains/1278dcd4-459f-62ed-754b-87fc5e4a6751").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testBadGet() {
        EasyMock.expect((Object)this.portChainService.getPortChain((PortChainId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portChainService});
        WebTarget wt = this.target();
        try {
            wt.path("port_chains/78dcd363-fc23-aeb6-f44b-56dc5aafb3ae").request().get(String.class);
            Assert.fail((String)"Fetch of non-existent port chain did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
    }

    @Test
    public void testPost() {
        EasyMock.expect((Object)this.portChainService.createPortChain((PortChain)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portChainService});
        WebTarget wt = this.target();
        InputStream jsonStream = PortChainResourceTest.class.getResourceAsStream("post-PortChain.json");
        Response response = wt.path("port_chains").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testDelete() {
        EasyMock.expect((Object)this.portChainService.removePortChain((PortChainId)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portChainService});
        WebTarget wt = this.target();
        String location = "port_chains/1278dcd4-459f-62ed-754b-87fc5e4a6751";
        Response deleteResponse = wt.path(location).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_PLAIN_TYPE}).delete();
        Assert.assertThat((Object)deleteResponse.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    private static class MockPortChain
    implements PortChain {
        private final PortChainId portChainId;
        private final TenantId tenantId;
        private final String name;
        private final String description;
        private final List<PortPairGroupId> portPairGroupList;
        private final List<FlowClassifierId> flowClassifierList;

        public MockPortChain(PortChainId portChainId, TenantId tenantId, String name, String description, List<PortPairGroupId> portPairGroupList, List<FlowClassifierId> flowClassifierList) {
            this.portChainId = portChainId;
            this.tenantId = tenantId;
            this.name = name;
            this.description = description;
            this.portPairGroupList = portPairGroupList;
            this.flowClassifierList = flowClassifierList;
        }

        public PortChainId portChainId() {
            return this.portChainId;
        }

        public TenantId tenantId() {
            return this.tenantId;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public List<PortPairGroupId> portPairGroups() {
            return ImmutableList.copyOf(this.portPairGroupList);
        }

        public List<FlowClassifierId> flowClassifiers() {
            return ImmutableList.copyOf(this.flowClassifierList);
        }

        public boolean exactMatch(PortChain portChain) {
            return this.equals(portChain) && Objects.equals(this.portChainId, portChain.portChainId()) && Objects.equals(this.tenantId, portChain.tenantId());
        }

        public void addLoadBalancePath(FiveTuple fiveTuple, LoadBalanceId id, List<PortPairId> path) {
        }

        public LoadBalanceId getLoadBalanceId(FiveTuple fiveTuple) {
            return null;
        }

        public Set<FiveTuple> getLoadBalanceIdMapKeys() {
            return null;
        }

        public List<PortPairId> getLoadBalancePath(LoadBalanceId id) {
            return null;
        }

        public List<PortPairId> getLoadBalancePath(FiveTuple fiveTuple) {
            return null;
        }

        public LoadBalanceId matchPath(List<PortPairId> path) {
            return null;
        }

        public int getLoadBalancePathSize() {
            return 0;
        }

        public void addSfcClassifiers(LoadBalanceId id, List<DeviceId> classifierList) {
        }

        public void addSfcForwarders(LoadBalanceId id, List<DeviceId> forwarderList) {
        }

        public void removeSfcClassifiers(LoadBalanceId id, List<DeviceId> classifierList) {
        }

        public void removeSfcForwarders(LoadBalanceId id, List<DeviceId> forwarderList) {
        }

        public List<DeviceId> getSfcClassifiers(LoadBalanceId id) {
            return null;
        }

        public List<DeviceId> getSfcForwarders(LoadBalanceId id) {
            return null;
        }

        public Set<LoadBalanceId> getLoadBalancePathMapKeys() {
            return null;
        }

        public PortChain oldPortChain() {
            return null;
        }
    }
}

