/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.vtnrsc.LoadBalanceId;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.portchain.PortChainService;

@Path(value="portChainDeviceMap")
public class PortChainDeviceMapWebResource
extends AbstractWebResource {
    public static final String PORT_CHAIN_NOT_FOUND = "Port chain not found";
    public static final String PORT_CHAIN_ID_EXIST = "Port chain exists";
    public static final String PORT_CHAIN_ID_NOT_EXIST = "Port chain does not exist with identifier";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String CLASSIFIERS = "classifiers";
    private static final String FORWARDERS = "forwarders";
    private static final String LOADBALANCEID = "loadBalanceId";

    @GET
    @Path(value="{chain_id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getPortChainDeviceMap(@PathParam(value="chain_id") String id) {
        PortChain portChain = (PortChain)Tools.nullIsNotFound((Object)((PortChainService)this.get(PortChainService.class)).getPortChain(PortChainId.of((String)id)), (String)PORT_CHAIN_NOT_FOUND);
        ObjectNode result = this.mapper().createObjectNode();
        result.set("portChainDeviceMap", (JsonNode)this.encode(portChain, (CodecContext)this));
        return PortChainDeviceMapWebResource.ok((Object)result.toString()).build();
    }

    private ObjectNode encode(PortChain portChain, CodecContext context) {
        Preconditions.checkNotNull((Object)portChain, (Object)"portChain cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        result.put(ID, portChain.portChainId().toString()).put(NAME, portChain.name());
        Set loadBalanceIds = portChain.getLoadBalancePathMapKeys();
        for (LoadBalanceId id : loadBalanceIds) {
            result.put(LOADBALANCEID, id.toString()).put(CLASSIFIERS, portChain.getSfcClassifiers(id).toString()).put(FORWARDERS, portChain.getSfcForwarders(id).toString());
        }
        return result;
    }
}

