/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.portchain.PortChainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="port_chains")
public class PortChainWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(PortChainWebResource.class);
    public static final String PORT_CHAIN_NOT_FOUND = "Port chain not found";
    public static final String PORT_CHAIN_ID_EXIST = "Port chain exists";
    public static final String PORT_CHAIN_ID_NOT_EXIST = "Port chain does not exist with identifier";

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getPortChains() {
        Iterable portChains = ((PortChainService)this.get(PortChainService.class)).getPortChains();
        ObjectNode result = this.mapper().createObjectNode();
        ArrayNode portChainEntry = result.putArray("port_chains");
        if (portChains != null) {
            for (PortChain portChain : portChains) {
                portChainEntry.add((JsonNode)this.codec(PortChain.class).encode((Object)portChain, (CodecContext)this));
            }
        }
        return PortChainWebResource.ok((Object)result.toString()).build();
    }

    @GET
    @Path(value="{chain_id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getPortPain(@PathParam(value="chain_id") String id) {
        PortChain portChain = (PortChain)Tools.nullIsNotFound((Object)((PortChainService)this.get(PortChainService.class)).getPortChain(PortChainId.of((String)id)), (String)PORT_CHAIN_NOT_FOUND);
        ObjectNode result = this.mapper().createObjectNode();
        result.set("port_chain", (JsonNode)this.codec(PortChain.class).encode((Object)portChain, (CodecContext)this));
        return PortChainWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createPortChain(InputStream stream) {
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode port = jsonTree.get("port_chain");
            PortChain portChain = (PortChain)this.codec(PortChain.class).decode((ObjectNode)port, (CodecContext)this);
            Boolean issuccess = (Boolean)Tools.nullIsNotFound((Object)((PortChainService)this.get(PortChainService.class)).createPortChain(portChain), (String)PORT_CHAIN_NOT_FOUND);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)issuccess.toString()).build();
        }
        catch (IOException e) {
            this.log.error("Exception while creating port chain {}.", (Object)e.toString());
            throw new IllegalArgumentException(e);
        }
    }

    @PUT
    @Path(value="{chain_id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updatePortPain(@PathParam(value="chain_id") String id, InputStream stream) {
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode port = jsonTree.get("port_chain");
            PortChain portChain = (PortChain)this.codec(PortChain.class).decode((ObjectNode)port, (CodecContext)this);
            Boolean result = (Boolean)Tools.nullIsNotFound((Object)((PortChainService)this.get(PortChainService.class)).updatePortChain(portChain), (String)PORT_CHAIN_NOT_FOUND);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result.toString()).build();
        }
        catch (IOException e) {
            this.log.error("Update port chain failed because of exception {}.", (Object)e.toString());
            throw new IllegalArgumentException(e);
        }
    }

    @Path(value="{chain_id}")
    @DELETE
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deletePortPain(@PathParam(value="chain_id") String id) {
        this.log.debug("Deletes port chain by identifier {}.", (Object)id);
        PortChainId portChainId = PortChainId.of((String)id);
        Boolean issuccess = (Boolean)Tools.nullIsNotFound((Object)((PortChainService)this.get(PortChainService.class)).removePortChain(portChainId), (String)PORT_CHAIN_NOT_FOUND);
        if (!issuccess.booleanValue()) {
            this.log.debug("Port Chain identifier {} does not exist", (Object)id);
        }
        return Response.noContent().build();
    }
}

