/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="flow_classifiers")
public class FlowClassifierWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(FlowClassifierWebResource.class);
    public static final String FLOW_CLASSIFIER_NOT_FOUND = "Flow classifier not found";

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getFlowClassifiers() {
        Iterable flowClassifiers = ((FlowClassifierService)this.get(FlowClassifierService.class)).getFlowClassifiers();
        ObjectNode result = this.mapper().createObjectNode();
        ArrayNode flowClassifierEntry = result.putArray("flow_classifiers");
        if (flowClassifiers != null) {
            for (FlowClassifier flowClassifier : flowClassifiers) {
                flowClassifierEntry.add((JsonNode)this.codec(FlowClassifier.class).encode((Object)flowClassifier, (CodecContext)this));
            }
        }
        return FlowClassifierWebResource.ok((Object)result.toString()).build();
    }

    @GET
    @Path(value="{flow_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getFlowClassifier(@PathParam(value="flow_id") String id) {
        FlowClassifier flowClassifier = (FlowClassifier)Tools.nullIsNotFound((Object)((FlowClassifierService)this.get(FlowClassifierService.class)).getFlowClassifier(FlowClassifierId.of((String)id)), (String)FLOW_CLASSIFIER_NOT_FOUND);
        ObjectNode result = this.mapper().createObjectNode();
        result.set("flow_classifier", (JsonNode)this.codec(FlowClassifier.class).encode((Object)flowClassifier, (CodecContext)this));
        return FlowClassifierWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createFlowClassifier(InputStream stream) {
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode flow = jsonTree.get("flow_classifier");
            FlowClassifier flowClassifier = (FlowClassifier)this.codec(FlowClassifier.class).decode((ObjectNode)flow, (CodecContext)this);
            Boolean issuccess = (Boolean)Tools.nullIsNotFound((Object)((FlowClassifierService)this.get(FlowClassifierService.class)).createFlowClassifier(flowClassifier), (String)FLOW_CLASSIFIER_NOT_FOUND);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)issuccess.toString()).build();
        }
        catch (IOException ex) {
            this.log.error("Exception while creating flow classifier {}.", (Object)ex.toString());
            throw new IllegalArgumentException(ex);
        }
    }

    @PUT
    @Path(value="{flow_id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateFlowClassifier(@PathParam(value="flow_id") String id, InputStream stream) {
        try {
            JsonNode jsonTree = this.mapper().readTree(stream);
            JsonNode flow = jsonTree.get("flow_classifier");
            FlowClassifier flowClassifier = (FlowClassifier)this.codec(FlowClassifier.class).decode((ObjectNode)flow, (CodecContext)this);
            Boolean result = (Boolean)Tools.nullIsNotFound((Object)((FlowClassifierService)this.get(FlowClassifierService.class)).updateFlowClassifier(flowClassifier), (String)FLOW_CLASSIFIER_NOT_FOUND);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result.toString()).build();
        }
        catch (IOException e) {
            this.log.error("Update flow classifier failed because of exception {}.", (Object)e.toString());
            throw new IllegalArgumentException(e);
        }
    }

    @Path(value="{flow_id}")
    @DELETE
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteFlowClassifier(@PathParam(value="flow_id") String id) {
        this.log.debug("Deletes flow classifier by identifier {}.", (Object)id);
        FlowClassifierId flowClassifierId = FlowClassifierId.of((String)id);
        Boolean issuccess = (Boolean)Tools.nullIsNotFound((Object)((FlowClassifierService)this.get(FlowClassifierService.class)).removeFlowClassifier(flowClassifierId), (String)FLOW_CLASSIFIER_NOT_FOUND);
        return Response.noContent().build();
    }
}

