/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnweb.web.SfcCodecContext;

public class PortPairGroupCodecTest {
    SfcCodecContext context;
    JsonCodec<PortPairGroup> portPairGroupCodec;

    @Before
    public void setUp() {
        this.context = new SfcCodecContext();
        this.portPairGroupCodec = this.context.codec(PortPairGroup.class);
        MatcherAssert.assertThat(this.portPairGroupCodec, (Matcher)Matchers.notNullValue());
    }

    private PortPairGroup getPortPairGroup(String resourceName) throws IOException {
        InputStream jsonStream = PortPairGroupCodecTest.class.getResourceAsStream(resourceName);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(jsonStream);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.notNullValue());
        PortPairGroup portPairGroup = (PortPairGroup)this.portPairGroupCodec.decode((ObjectNode)json, (CodecContext)this.context);
        MatcherAssert.assertThat((Object)portPairGroup, (Matcher)Matchers.notNullValue());
        return portPairGroup;
    }

    @Test
    public void codecPortPairGroupTest() throws IOException {
        PortPairGroup portPairGroup = this.getPortPairGroup("portPairGroup.json");
        MatcherAssert.assertThat((Object)portPairGroup, (Matcher)Matchers.notNullValue());
        PortPairGroupId portPairGroupId = PortPairGroupId.of((String)"4512d643-24fc-4fae-af4b-321c5e2eb3d1");
        TenantId tenantId = TenantId.tenantId((String)"d382007aa9904763a801f68ecf065cf5");
        MatcherAssert.assertThat((Object)portPairGroup.portPairGroupId().toString(), (Matcher)Matchers.is((Object)portPairGroupId.toString()));
        MatcherAssert.assertThat((Object)portPairGroup.name(), (Matcher)Matchers.is((Object)"PG1"));
        MatcherAssert.assertThat((Object)portPairGroup.tenantId().toString(), (Matcher)Matchers.is((Object)tenantId.toString()));
        MatcherAssert.assertThat((Object)portPairGroup.description(), (Matcher)Matchers.is((Object)"Two port-pairs"));
        MatcherAssert.assertThat((Object)portPairGroup.portPairs(), (Matcher)Matchers.notNullValue());
    }
}

