/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.List;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.vtnrsc.Router;
import org.onosproject.vtnweb.web.RouterGatewayInfoCodec;

public class RouterCodec
extends JsonCodec<Router> {
    public ObjectNode encode(Router router, CodecContext context) {
        Preconditions.checkNotNull((Object)router, (Object)"router cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put("id", router.id().routerId()).put("status", router.status().toString()).put("name", router.name().toString()).put("admin_state_up", router.adminStateUp()).put("tenant_id", router.tenantId().toString()).put("routes", router.routes() == null ? null : router.routes().toString());
        result.set("external_gateway_info", router.externalGatewayInfo() == null ? null : new RouterGatewayInfoCodec().encode(router.externalGatewayInfo(), context));
        return result;
    }

    public ObjectNode extracFields(Router router, CodecContext context, List<String> fields) {
        Preconditions.checkNotNull((Object)router, (Object)"router cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        for (String s : fields) {
            if (s.equals("id")) {
                result.put("id", router.id().routerId());
            }
            if (s.equals("status")) {
                result.put("status", router.status().toString());
            }
            if (s.equals("name")) {
                result.put("name", router.name().toString());
            }
            if (s.equals("admin_state_up")) {
                result.put("admin_state_up", router.adminStateUp());
            }
            if (s.equals("tenant_id")) {
                result.put("tenant_id", router.tenantId().toString());
            }
            if (s.equals("routes")) {
                result.put("routes", router.routes() == null ? null : router.routes().toString());
            }
            if (!s.equals("external_gateway_info")) continue;
            result.set("external_gateway_info", router.externalGatewayInfo() == null ? null : new RouterGatewayInfoCodec().encode(router.externalGatewayInfo(), context));
        }
        return result;
    }
}

