/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.packet.IpPrefix;
import org.onlab.rest.BaseResource;
import org.onosproject.codec.CodecService;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierService;
import org.onosproject.vtnweb.resources.VtnResourceTest;
import org.onosproject.vtnweb.web.SfcCodecContext;

public class FlowClassifierResourceTest
extends VtnResourceTest {
    final FlowClassifierService flowClassifierService = (FlowClassifierService)EasyMock.createMock(FlowClassifierService.class);
    FlowClassifierId flowClassifierId1 = FlowClassifierId.of((String)"4a334cd4-fe9c-4fae-af4b-321c5e2eb051");
    TenantId tenantId1 = TenantId.tenantId((String)"1814726e2d22407b8ca76db5e567dcf1");
    VirtualPortId srcPortId1 = VirtualPortId.portId((String)"dace4513-24fc-4fae-af4b-321c5e2eb3d1");
    VirtualPortId dstPortId1 = VirtualPortId.portId((String)"aef3478a-4a56-2a6e-cd3a-9dee4e2ec345");
    final MockFlowClassifier flowClassifier1 = new MockFlowClassifier(this.flowClassifierId1, this.tenantId1, "flowClassifier1", "Mock flow classifier", "IPv4", "IP", 10000, 1001, 1500, 5001, 6000, IpPrefix.valueOf((String)"1.1.1.1/16"), IpPrefix.valueOf((String)"22.12.34.45/16"), this.srcPortId1, this.dstPortId1);

    @Before
    public void setUpTest() {
        SfcCodecContext context = new SfcCodecContext();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(FlowClassifierService.class, (Object)this.flowClassifierService).add(CodecService.class, (Object)context.codecManager());
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
    }

    @Test
    public void testFlowClassifiersEmpty() {
        EasyMock.expect((Object)this.flowClassifierService.getFlowClassifiers()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.flowClassifierService});
        WebTarget wt = this.target();
        String response = (String)wt.path("flow_classifiers").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"flow_classifiers\":[]}"));
    }

    @Test
    public void testGetFlowClassifierId() {
        HashSet<MockFlowClassifier> flowClassifiers = new HashSet<MockFlowClassifier>();
        flowClassifiers.add(this.flowClassifier1);
        EasyMock.expect((Object)this.flowClassifierService.exists((FlowClassifierId)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.flowClassifierService.getFlowClassifier((FlowClassifierId)EasyMock.anyObject())).andReturn((Object)this.flowClassifier1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.flowClassifierService});
        WebTarget wt = this.target();
        String response = (String)wt.path("flow_classifiers/4a334cd4-fe9c-4fae-af4b-321c5e2eb051").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testBadGet() {
        EasyMock.expect((Object)this.flowClassifierService.getFlowClassifier((FlowClassifierId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.flowClassifierService});
        WebTarget wt = this.target();
        try {
            wt.path("flow_classifiers/78dcd363-fc23-aeb6-f44b-56dc5aafb3ae").request().get(String.class);
            Assert.fail((String)"Fetch of non-existent flow classifier did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
    }

    @Test
    public void testPost() {
        EasyMock.expect((Object)this.flowClassifierService.createFlowClassifier((FlowClassifier)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.flowClassifierService});
        WebTarget wt = this.target();
        InputStream jsonStream = FlowClassifierResourceTest.class.getResourceAsStream("post-FlowClassifier.json");
        Response response = wt.path("flow_classifiers").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testDelete() {
        EasyMock.expect((Object)this.flowClassifierService.removeFlowClassifier((FlowClassifierId)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.flowClassifierService});
        WebTarget wt = this.target();
        String location = "flow_classifiers/4a334cd4-fe9c-4fae-af4b-321c5e2eb051";
        Response deleteResponse = wt.path(location).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_PLAIN_TYPE}).delete();
        Assert.assertThat((Object)deleteResponse.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    private static class MockFlowClassifier
    implements FlowClassifier {
        private final FlowClassifierId flowClassifierId;
        private final TenantId tenantId;
        private final String name;
        private final String description;
        private final String etherType;
        private final String protocol;
        private final int priority;
        private final int minSrcPortRange;
        private final int maxSrcPortRange;
        private final int minDstPortRange;
        private final int maxDstPortRange;
        private final IpPrefix srcIpPrefix;
        private final IpPrefix dstIpPrefix;
        private final VirtualPortId srcPort;
        private final VirtualPortId dstPort;

        public MockFlowClassifier(FlowClassifierId flowClassifierId, TenantId tenantId, String name, String description, String etherType, String protocol, int priority, int minSrcPortRange, int maxSrcPortRange, int minDstPortRange, int maxDstPortRange, IpPrefix srcIpPrefix, IpPrefix dstIpPrefix, VirtualPortId srcPort, VirtualPortId dstPort) {
            this.flowClassifierId = flowClassifierId;
            this.tenantId = tenantId;
            this.name = name;
            this.description = description;
            this.etherType = etherType;
            this.protocol = protocol;
            this.priority = priority;
            this.minSrcPortRange = minSrcPortRange;
            this.maxSrcPortRange = maxSrcPortRange;
            this.minDstPortRange = minDstPortRange;
            this.maxDstPortRange = maxDstPortRange;
            this.srcIpPrefix = srcIpPrefix;
            this.dstIpPrefix = dstIpPrefix;
            this.srcPort = srcPort;
            this.dstPort = dstPort;
        }

        public FlowClassifierId flowClassifierId() {
            return this.flowClassifierId;
        }

        public TenantId tenantId() {
            return this.tenantId;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public String etherType() {
            return this.etherType;
        }

        public String protocol() {
            return this.protocol;
        }

        public int priority() {
            return this.priority;
        }

        public int minSrcPortRange() {
            return this.minSrcPortRange;
        }

        public int maxSrcPortRange() {
            return this.maxSrcPortRange;
        }

        public int minDstPortRange() {
            return this.minDstPortRange;
        }

        public int maxDstPortRange() {
            return this.maxDstPortRange;
        }

        public IpPrefix srcIpPrefix() {
            return this.srcIpPrefix;
        }

        public IpPrefix dstIpPrefix() {
            return this.dstIpPrefix;
        }

        public VirtualPortId srcPort() {
            return this.srcPort;
        }

        public VirtualPortId dstPort() {
            return this.dstPort;
        }

        public boolean exactMatch(FlowClassifier flowClassifier) {
            return this.equals(flowClassifier) && Objects.equals(this.flowClassifierId, flowClassifier.flowClassifierId()) && Objects.equals(this.tenantId, flowClassifier.tenantId());
        }
    }
}

