/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnweb.web.SfcCodecContext;

public class FlowClassifierCodecTest {
    SfcCodecContext context;
    JsonCodec<FlowClassifier> flowClassifierCodec;

    @Before
    public void setUp() {
        this.context = new SfcCodecContext();
        this.flowClassifierCodec = this.context.codec(FlowClassifier.class);
        MatcherAssert.assertThat(this.flowClassifierCodec, (Matcher)Matchers.notNullValue());
    }

    private FlowClassifier getFlowClassifier(String resourceName) throws IOException {
        InputStream jsonStream = FlowClassifierCodecTest.class.getResourceAsStream(resourceName);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(jsonStream);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.notNullValue());
        FlowClassifier flowClassifier = (FlowClassifier)this.flowClassifierCodec.decode((ObjectNode)json, (CodecContext)this.context);
        MatcherAssert.assertThat((Object)flowClassifier, (Matcher)Matchers.notNullValue());
        return flowClassifier;
    }

    @Test
    public void codecFlowClassifierTest() throws IOException {
        FlowClassifier flowClassifier = this.getFlowClassifier("flowClassifier.json");
        MatcherAssert.assertThat((Object)flowClassifier, (Matcher)Matchers.notNullValue());
        FlowClassifierId flowClassifierId = FlowClassifierId.of((String)"4a334cd4-fe9c-4fae-af4b-321c5e2eb051");
        TenantId tenantId = TenantId.tenantId((String)"1814726e2d22407b8ca76db5e567dcf1");
        MatcherAssert.assertThat((Object)flowClassifier.flowClassifierId().toString(), (Matcher)Matchers.is((Object)flowClassifierId.toString()));
        MatcherAssert.assertThat((Object)flowClassifier.name(), (Matcher)Matchers.is((Object)"flow1"));
        MatcherAssert.assertThat((Object)flowClassifier.tenantId().toString(), (Matcher)Matchers.is((Object)tenantId.toString()));
        MatcherAssert.assertThat((Object)flowClassifier.description(), (Matcher)Matchers.is((Object)"flow classifier"));
        MatcherAssert.assertThat((Object)flowClassifier.protocol(), (Matcher)Matchers.is((Object)"tcp"));
        MatcherAssert.assertThat((Object)flowClassifier.priority(), (Matcher)Matchers.is((Object)65535));
        MatcherAssert.assertThat((Object)flowClassifier.minSrcPortRange(), (Matcher)Matchers.is((Object)22));
        MatcherAssert.assertThat((Object)flowClassifier.maxSrcPortRange(), (Matcher)Matchers.is((Object)4000));
        MatcherAssert.assertThat((Object)flowClassifier.minDstPortRange(), (Matcher)Matchers.is((Object)80));
        MatcherAssert.assertThat((Object)flowClassifier.maxDstPortRange(), (Matcher)Matchers.is((Object)80));
    }
}

