/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onlab.packet.IpAddress;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.vtnrsc.DefaultFloatingIp;
import org.onosproject.vtnrsc.FloatingIp;
import org.onosproject.vtnrsc.FloatingIpId;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.floatingip.FloatingIpService;
import org.onosproject.vtnweb.web.FloatingIpCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="floatingips")
public class FloatingIpWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(FloatingIpWebResource.class);
    public static final String CREATE_FAIL = "Floating IP is failed to create!";
    public static final String UPDATE_FAIL = "Floating IP is failed to update!";
    public static final String DELETE_FAIL = "Floating IP is failed to delete!";
    public static final String GET_FAIL = "Floating IP is failed to get!";
    public static final String NOT_EXIST = "Floating IP does not exist!";
    public static final String DELETE_SUCCESS = "Floating IP delete success!";
    public static final String JSON_NOT_NULL = "JsonNode can not be null";

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response listFloatingIps() {
        Collection floatingIps = ((FloatingIpService)this.get(FloatingIpService.class)).getFloatingIps();
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("floatingips", (JsonNode)new FloatingIpCodec().encode((Iterable)floatingIps, (CodecContext)this));
        return FloatingIpWebResource.ok((Object)result.toString()).build();
    }

    @GET
    @Path(value="{floatingIpUUID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getFloatingIp(@PathParam(value="floatingIpUUID") String id, @QueryParam(value="fields") List<String> fields) {
        if (!((FloatingIpService)this.get(FloatingIpService.class)).exists(FloatingIpId.of((String)id))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Floating IP does not exist!").build();
        }
        FloatingIp sub = (FloatingIp)this.nullIsNotFound((Object)((FloatingIpService)this.get(FloatingIpService.class)).getFloatingIp(FloatingIpId.of((String)id)), "Floating IP is failed to get!");
        ObjectNode result = new ObjectMapper().createObjectNode();
        if (fields.size() > 0) {
            result.set("floatingip", (JsonNode)new FloatingIpCodec().extracFields(sub, (CodecContext)this, fields));
        } else {
            result.set("floatingip", (JsonNode)new FloatingIpCodec().encode(sub, (CodecContext)this));
        }
        return FloatingIpWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createFloatingIp(InputStream input) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode subnode = mapper.readTree(input);
            Collection floatingIps = this.createOrUpdateByInputStream(subnode);
            Boolean result = (Boolean)this.nullIsNotFound((Object)((FloatingIpService)this.get(FloatingIpService.class)).createFloatingIps(floatingIps), "Floating IP is failed to create!");
            if (!result.booleanValue()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Floating IP is failed to create!").build();
            }
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result.toString()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="{floatingIpUUID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateFloatingIp(@PathParam(value="floatingIpUUID") String id, InputStream input) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode subnode = mapper.readTree(input);
            Collection floatingIps = this.createOrUpdateByInputStream(subnode);
            Boolean result = (Boolean)this.nullIsNotFound((Object)((FloatingIpService)this.get(FloatingIpService.class)).updateFloatingIps(floatingIps), "Floating IP is failed to update!");
            if (!result.booleanValue()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Floating IP is failed to update!").build();
            }
            return FloatingIpWebResource.ok((Object)result.toString()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="{floatingIpUUID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteSingleFloatingIp(@PathParam(value="floatingIpUUID") String id) throws IOException {
        try {
            FloatingIpId floatingIpId = FloatingIpId.of((String)id);
            HashSet floatingIpIds = Sets.newHashSet((Object[])new FloatingIpId[]{floatingIpId});
            Boolean result = (Boolean)this.nullIsNotFound((Object)((FloatingIpService)this.get(FloatingIpService.class)).removeFloatingIps((Collection)floatingIpIds), "Floating IP is failed to delete!");
            if (!result.booleanValue()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Floating IP is failed to delete!").build();
            }
            return Response.noContent().entity((Object)"Floating IP delete success!").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    private Collection<FloatingIp> createOrUpdateByInputStream(JsonNode subnode) throws Exception {
        Preconditions.checkNotNull((Object)subnode, (Object)"JsonNode can not be null");
        Collection floatingIps = null;
        JsonNode floatingIpNodes = subnode.get("floatingips");
        if (floatingIpNodes == null) {
            floatingIpNodes = subnode.get("floatingip");
        }
        this.log.debug("floatingNodes is {}", (Object)floatingIpNodes.toString());
        if (floatingIpNodes.isArray()) {
            throw new IllegalArgumentException("only singleton requests allowed");
        }
        floatingIps = this.changeJsonToSub(floatingIpNodes);
        return floatingIps;
    }

    public Collection<FloatingIp> changeJsonToSub(JsonNode floatingIpNodes) throws Exception {
        Preconditions.checkNotNull((Object)floatingIpNodes, (Object)"JsonNode can not be null");
        HashMap<FloatingIpId, DefaultFloatingIp> subMap = new HashMap<FloatingIpId, DefaultFloatingIp>();
        if (!floatingIpNodes.hasNonNull("id")) {
            throw new IllegalArgumentException("id should not be null");
        }
        if (floatingIpNodes.get("id").asText().isEmpty()) {
            throw new IllegalArgumentException("id should not be empty");
        }
        FloatingIpId id = FloatingIpId.of((String)floatingIpNodes.get("id").asText());
        if (!floatingIpNodes.hasNonNull("tenant_id")) {
            throw new IllegalArgumentException("tenant_id should not be null");
        }
        if (floatingIpNodes.get("tenant_id").asText().isEmpty()) {
            throw new IllegalArgumentException("tenant_id should not be empty");
        }
        TenantId tenantId = TenantId.tenantId((String)floatingIpNodes.get("tenant_id").asText());
        if (!floatingIpNodes.hasNonNull("floating_network_id")) {
            throw new IllegalArgumentException("floating_network_id should not be null");
        }
        if (floatingIpNodes.get("floating_network_id").asText().isEmpty()) {
            throw new IllegalArgumentException("floating_network_id should not be empty");
        }
        TenantNetworkId networkId = TenantNetworkId.networkId((String)floatingIpNodes.get("floating_network_id").asText());
        VirtualPortId portId = null;
        if (floatingIpNodes.hasNonNull("port_id")) {
            portId = VirtualPortId.portId((String)floatingIpNodes.get("port_id").asText());
        }
        RouterId routerId = null;
        if (floatingIpNodes.hasNonNull("router_id")) {
            routerId = RouterId.valueOf((String)floatingIpNodes.get("router_id").asText());
        }
        IpAddress fixedIp = null;
        if (floatingIpNodes.hasNonNull("fixed_ip_address")) {
            fixedIp = IpAddress.valueOf((String)floatingIpNodes.get("fixed_ip_address").asText());
        }
        if (!floatingIpNodes.hasNonNull("floating_ip_address")) {
            throw new IllegalArgumentException("floating_ip_address should not be null");
        }
        if (floatingIpNodes.get("floating_ip_address").asText().isEmpty()) {
            throw new IllegalArgumentException("floating_ip_address should not be empty");
        }
        IpAddress floatingIp = IpAddress.valueOf((String)floatingIpNodes.get("floating_ip_address").asText());
        if (!floatingIpNodes.hasNonNull("status")) {
            throw new IllegalArgumentException("status should not be null");
        }
        if (floatingIpNodes.get("status").asText().isEmpty()) {
            throw new IllegalArgumentException("status should not be empty");
        }
        FloatingIp.Status status = FloatingIp.Status.valueOf((String)floatingIpNodes.get("status").asText());
        DefaultFloatingIp floatingIpObj = new DefaultFloatingIp(id, tenantId, networkId, portId, routerId, floatingIp, fixedIp, status);
        subMap.put(id, floatingIpObj);
        return Collections.unmodifiableCollection(subMap.values());
    }

    protected <T> T nullIsNotFound(T item, String message) {
        if (item == null) {
            throw new ItemNotFoundException(message);
        }
        return item;
    }
}

