/*
 * Copyright 2015-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onosproject.vtnweb.web;

import static com.google.common.base.Preconditions.checkNotNull;

import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.vtnrsc.TenantNetwork;

import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * TenantNetwork JSON codec.
 */
public final class TenantNetworkCodec extends JsonCodec<TenantNetwork> {

    @Override
    public ObjectNode encode(TenantNetwork network, CodecContext context) {
        checkNotNull(network, "Network cannot be null");
        ObjectNode result = context.mapper().createObjectNode()
                .put("id", network.id().toString())
                .put("name", network.name())
                .put("admin_state_up", network.adminStateUp())
                .put("status", "" + network.state())
                .put("shared", network.shared())
                .put("tenant_id", network.tenantId().toString())
                .put("router:external", network.routerExternal())
                .put("provider:network_type", "" + network.type())
                .put("provider:physical_network", network.physicalNetwork().toString())
                .put("provider:segmentation_id", network.segmentationId().toString());
        return result;
    }
}
