/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.rest.BaseResource;
import org.onosproject.codec.CodecService;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupService;
import org.onosproject.vtnweb.resources.VtnResourceTest;
import org.onosproject.vtnweb.web.SfcCodecContext;

public class PortPairGroupResourceTest
extends VtnResourceTest {
    final PortPairGroupService portPairGroupService = (PortPairGroupService)EasyMock.createMock(PortPairGroupService.class);
    PortPairGroupId portPairGroupId1 = PortPairGroupId.of((String)"4512d643-24fc-4fae-af4b-321c5e2eb3d1");
    TenantId tenantId1 = TenantId.tenantId((String)"d382007aa9904763a801f68ecf065cf5");
    private final List<PortPairId> portPairList1 = Lists.newArrayList();
    final MockPortPairGroup portPairGroup1 = new MockPortPairGroup(this.portPairGroupId1, this.tenantId1, "portPairGroup1", "Mock port pair group", this.portPairList1);

    @Before
    public void setUpTest() {
        SfcCodecContext context = new SfcCodecContext();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(PortPairGroupService.class, (Object)this.portPairGroupService).add(CodecService.class, (Object)context.codecManager());
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
    }

    @Test
    public void testPortPairGroupsEmpty() {
        EasyMock.expect((Object)this.portPairGroupService.getPortPairGroups()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portPairGroupService});
        WebTarget wt = this.target();
        String response = (String)wt.path("port_pair_groups").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"port_pair_groups\":[]}"));
    }

    @Test
    public void testGetPortPairGroupId() {
        HashSet<MockPortPairGroup> portPairGroups = new HashSet<MockPortPairGroup>();
        portPairGroups.add(this.portPairGroup1);
        EasyMock.expect((Object)this.portPairGroupService.exists((PortPairGroupId)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.portPairGroupService.getPortPairGroup((PortPairGroupId)EasyMock.anyObject())).andReturn((Object)this.portPairGroup1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portPairGroupService});
        WebTarget wt = this.target();
        String response = (String)wt.path("port_pair_groups/4512d643-24fc-4fae-af4b-321c5e2eb3d1").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testBadGet() {
        EasyMock.expect((Object)this.portPairGroupService.getPortPairGroup((PortPairGroupId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portPairGroupService});
        WebTarget wt = this.target();
        try {
            wt.path("port_pair_groups/78dcd363-fc23-aeb6-f44b-56dc5aafb3ae").request().get(String.class);
            Assert.fail((String)"Fetch of non-existent port pair group did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
    }

    @Test
    public void testPost() {
        EasyMock.expect((Object)this.portPairGroupService.createPortPairGroup((PortPairGroup)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portPairGroupService});
        WebTarget wt = this.target();
        InputStream jsonStream = PortPairGroupResourceTest.class.getResourceAsStream("post-PortPairGroup.json");
        Response response = wt.path("port_pair_groups").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testDelete() {
        EasyMock.expect((Object)this.portPairGroupService.removePortPairGroup((PortPairGroupId)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portPairGroupService});
        WebTarget wt = this.target();
        String location = "port_pair_groups/4512d643-24fc-4fae-af4b-321c5e2eb3d1";
        Response deleteResponse = wt.path(location).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_PLAIN_TYPE}).delete();
        Assert.assertThat((Object)deleteResponse.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    private static class MockPortPairGroup
    implements PortPairGroup {
        private final PortPairGroupId portPairGroupId;
        private final TenantId tenantId;
        private final String name;
        private final String description;
        private final List<PortPairId> portPairList;

        public MockPortPairGroup(PortPairGroupId portPairGroupId, TenantId tenantId, String name, String description, List<PortPairId> portPairList) {
            this.portPairGroupId = portPairGroupId;
            this.tenantId = tenantId;
            this.name = name;
            this.description = description;
            this.portPairList = portPairList;
        }

        public PortPairGroupId portPairGroupId() {
            return this.portPairGroupId;
        }

        public TenantId tenantId() {
            return this.tenantId;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public List<PortPairId> portPairs() {
            return ImmutableList.copyOf(this.portPairList);
        }

        public void addLoad(PortPairId portPairId) {
        }

        public int getLoad(PortPairId portPairId) {
            return 0;
        }

        public Map<PortPairId, Integer> portPairLoadMap() {
            return null;
        }

        public boolean exactMatch(PortPairGroup portPairGroup) {
            return this.equals(portPairGroup) && Objects.equals(this.portPairGroupId, portPairGroup.portPairGroupId()) && Objects.equals(this.tenantId, portPairGroup.tenantId());
        }

        public void resetLoad() {
        }
    }
}

